/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.path;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.PathException;
import org.brackit.xquery.util.path.PathParser;

public final class Path<E> {
    private final ArrayList<Step<E>> path;

    public Path() {
        this.path = new ArrayList();
    }

    private Path(ArrayList<Step<E>> path) {
        this.path = path;
    }

    public Path<E> append(Path<E> other) {
        this.path.addAll(other.steps());
        return this;
    }

    public Path<E> child(E value) {
        this.path.add(new Step<E>(Axis.CHILD, value));
        return this;
    }

    public Path<E> descendant(E value) {
        this.path.add(new Step<E>(Axis.DESC, value));
        return this;
    }

    public Path<E> attribute(E value) {
        this.path.add(new Step<E>(Axis.CHILD_ATTRIBUTE, value));
        return this;
    }

    public Path<E> descendantAttribute(E value) {
        this.path.add(new Step<E>(Axis.DESC_ATTRIBUTE, value));
        return this;
    }

    public Path<E> child() {
        this.path.add(new Step<Object>(Axis.CHILD, null));
        return this;
    }

    public Path<E> descendant() {
        this.path.add(new Step<Object>(Axis.DESC, null));
        return this;
    }

    public Path<E> attribute() {
        this.path.add(new Step<Object>(Axis.CHILD_ATTRIBUTE, null));
        return this;
    }

    public Path<E> descendantAttribute() {
        this.path.add(new Step<Object>(Axis.DESC_ATTRIBUTE, null));
        return this;
    }

    public Path<E> self() {
        this.path.add(new Step<Object>(Axis.SELF, null));
        return this;
    }

    public Path<E> parent() {
        this.path.add(new Step<Object>(Axis.PARENT, null));
        return this;
    }

    public Path<E> childArray() {
        this.path.add(new Step<Object>(Axis.CHILD_ARRAY, null));
        return this;
    }

    public Path<E> descendantArray() {
        this.path.add(new Step<Object>(Axis.DESC_ARRAY, null));
        return this;
    }

    public boolean matches(Path<E> other) throws PathException {
        boolean match;
        if (this.isEmpty()) {
            throw new PathException("Empty pattern", new Object[0]);
        }
        if (this.path.isEmpty()) {
            throw new PathException("Illegal path: %s", this.path);
        }
        Step[] o = other.path.toArray((Step[])Array.newInstance(this.path.get(0).getClass(), other.path.size()));
        Step[] p = this.path.toArray((Step[])Array.newInstance(this.path.get(0).getClass(), this.path.size()));
        int oLen = o.length;
        int pLen = p.length;
        int[] matchTable = new int[pLen];
        if (oLen < pLen) {
            return false;
        }
        int oPos = oLen - 1;
        int pPos = pLen - 1;
        while (pPos >= 0) {
            boolean oIsNodeStep;
            Axis pAxis = p[pPos].axis;
            boolean pIsAttributeStep = pAxis == Axis.CHILD_ATTRIBUTE || pAxis == Axis.DESC_ATTRIBUTE;
            boolean pIsArrayStep = pAxis == Axis.CHILD_ARRAY || pAxis == Axis.DESC_ARRAY;
            boolean pIsNodeStep = pAxis == Axis.CHILD || pAxis == Axis.DESC;
            Axis oAxis = o[oPos].axis;
            boolean oIsAttributeStep = oAxis == Axis.CHILD_ATTRIBUTE || oAxis == Axis.DESC_ATTRIBUTE;
            boolean oIsArrayStep = oAxis == Axis.CHILD_ARRAY || oAxis == Axis.DESC_ARRAY;
            boolean bl = oIsNodeStep = oAxis == Axis.CHILD || oAxis == Axis.DESC;
            if (!(pIsNodeStep || pIsAttributeStep || pIsArrayStep)) {
                throw new PathException("Illegal pattern path: %s", this);
            }
            if (!(oIsAttributeStep || oIsArrayStep || oIsNodeStep)) {
                throw new PathException("Illegal path: %s", this.path);
            }
            if ((p[pPos].value == null && o[oPos].value == null || p[pPos].value != null && p[pPos].value.equals(o[oPos].value)) && (pAxis == oAxis || pAxis == Axis.DESC && oAxis == Axis.CHILD || pAxis == Axis.DESC_ATTRIBUTE && oAxis == Axis.CHILD_ATTRIBUTE || pAxis == Axis.DESC_ARRAY && oAxis == Axis.CHILD_ARRAY)) {
                matchTable[pPos] = oPos--;
                --pPos;
            } else if (pPos < pLen - 1) {
                while (p[pPos + 1].axis != Axis.DESC && p[pPos + 1].axis != Axis.DESC_ATTRIBUTE && p[pPos + 1].axis != Axis.DESC_ARRAY) {
                    if (++pPos == pLen - 1) {
                        return false;
                    }
                    oPos = matchTable[pPos];
                }
                --oPos;
            } else {
                return false;
            }
            if (oPos >= pPos) continue;
            return false;
        }
        boolean bl = match = oPos == -1 || p[0].axis == Axis.DESC || p[0].axis == Axis.DESC_ATTRIBUTE || p[0].axis == Axis.DESC_ARRAY;
        if (match) {
            // empty if block
        }
        return match;
    }

    public E head() {
        int size = this.path.size();
        return size > 0 ? (E)this.path.get((int)0).value : null;
    }

    public E tail() {
        int index = this.path.size() - 1;
        return index >= 0 ? (E)this.path.get((int)index).value : null;
    }

    public Path<E> leading() {
        if (this.path.size() == 0) {
            return new Path<E>();
        }
        return new Path<E>(new ArrayList<Step<E>>(this.path.subList(0, this.path.size() - 1)));
    }

    public Path<E> trailing() {
        int index = this.path.size();
        return index > 0 ? new Path<E>(new ArrayList<Step<E>>(this.path.subList(1, index))) : new Path<E>();
    }

    public List<Step<E>> steps() {
        return Collections.unmodifiableList(this.path);
    }

    public List<Path<?>> explode() {
        Path[] list = new Path[this.path.size()];
        Path<E> current = this;
        for (int i = this.path.size() - 1; i >= 0; --i) {
            list[i] = current;
            current = current.leading();
        }
        return Arrays.asList(list);
    }

    public boolean isEmpty() {
        return this.path.size() == 0;
    }

    public boolean isAbsolute() {
        for (Step<E> section : this.path) {
            if (section.axis == Axis.CHILD && section.value != null) continue;
            return false;
        }
        return true;
    }

    public boolean isBackward() {
        if (this.isEmpty()) {
            return true;
        }
        for (Step<E> step : this.path) {
            Axis a = step.axis;
            if (a == Axis.PARENT || a == Axis.SELF) continue;
            return false;
        }
        return true;
    }

    public boolean isForward() {
        if (this.isEmpty()) {
            return true;
        }
        for (Step<E> step : this.path) {
            Axis a = step.axis;
            if (a == Axis.CHILD || a == Axis.CHILD_ATTRIBUTE || a == Axis.SELF || a == Axis.DESC || a == Axis.DESC_ATTRIBUTE) continue;
            return false;
        }
        return true;
    }

    public boolean isRelative() {
        return this.path.size() != 0 && this.path.get((int)0).axis != Axis.CHILD;
    }

    public boolean isAttribute() {
        return this.path.size() != 0 && (this.path.get((int)(this.path.size() - 1)).axis == Axis.DESC_ATTRIBUTE || this.path.get((int)(this.path.size() - 1)).axis == Axis.CHILD_ATTRIBUTE);
    }

    public Path<E> normalize() {
        return null;
    }

    public Path<E> copy() {
        return new Path<E>(this.path != null ? new ArrayList<Step<Step<Step<Step<E>>>>>(this.path) : null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Path other = (Path)obj;
        if (other.path.size() != this.path.size()) {
            return false;
        }
        for (int i = 0; i < this.path.size(); ++i) {
            if (this.path.get(i).equals(other.path.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int[] hashes = new int[this.path.size()];
        int i = 0;
        for (Step<E> section : this.path) {
            hashes[i++] = section.hashCode();
        }
        return Arrays.hashCode(hashes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Step<E> previous = null;
        for (Step<E> section : this.path) {
            if (!(section.axis != Axis.SELF && section.axis != Axis.PARENT || previous == null || previous.axis != Axis.SELF && previous.axis != Axis.PARENT)) {
                builder.append("/");
            }
            builder.append(section);
            previous = section;
        }
        return builder.toString();
    }

    public int getLength() {
        return this.path.size();
    }

    public static Path<QNm> parse(String path) throws PathException {
        return new PathParser(path).parse();
    }

    public static void main(String[] args) {
        Path<String> path = new Path<String>();
        path.child("bib").descendant().descendant("book").child("title");
        System.out.println("Tail " + (String)path.tail());
        System.out.println("Leading " + path.leading());
        System.out.println("Explode " + path.explode());
        path = new Path();
        path.child("bib");
        System.out.println("Tail " + (String)path.tail());
        System.out.println("Leading " + path.leading());
        System.out.println("trailing " + path.leading());
        System.out.println("Explode " + path.explode());
        path = new Path();
        System.out.println("Tail " + (String)path.tail());
        System.out.println("Leading " + path.leading());
        System.out.println("trailing " + path.leading());
        System.out.println("Explode " + path.explode());
    }

    public static class Step<T> {
        private final Axis axis;
        private final T value;

        private Step(Axis axis, T value) {
            if (axis == null) {
                throw new NullPointerException();
            }
            this.axis = axis;
            this.value = value;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public T getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Step)) {
                return false;
            }
            Step other = (Step)obj;
            return other.axis.equals((Object)this.axis) && (other.value == this.value || other.value.equals(this.value));
        }

        public int hashCode() {
            return this.value != null ? this.axis.hashCode() ^ this.value.hashCode() : this.axis.hashCode();
        }

        public String toString() {
            String axisString = this.axis.getText();
            String valueString = this.value != null ? this.value.toString() : (this.axis == Axis.PARENT || this.axis == Axis.SELF || this.axis == Axis.CHILD_ARRAY || this.axis == Axis.DESC_ARRAY ? "" : "*");
            return axisString + valueString;
        }
    }

    public static enum Axis {
        PARENT(".."),
        SELF("."),
        DESC("//"),
        CHILD("/"),
        DESC_ATTRIBUTE("//@"),
        CHILD_ATTRIBUTE("/@"),
        CHILD_ARRAY("/[]"),
        DESC_ARRAY("//[]");

        private final String text;

        private Axis(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

