/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.path;

import java.util.Map;
import java.util.TreeMap;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.parser.Tokenizer;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;

public final class PathParser
extends Tokenizer {
    private final Path<QNm> p = new Path();
    private Map<String, String> namespaces;

    public PathParser(String s) {
        super(s);
    }

    public Path<QNm> parse() {
        try {
            this.nsPreamble();
            this.attemptS();
            this.startStep();
            while (this.axisStep()) {
            }
            this.attributeStep();
            this.consumeEOF();
            return this.p;
        }
        catch (Tokenizer.TokenizerException e) {
            throw new PathException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    private void nsPreamble() throws Tokenizer.TokenizerException, PathException {
        Tokenizer.Token la = this.laSymSkipS("namespace");
        while (la != null) {
            this.consume(la);
            Tokenizer.Token pfx = this.laNCNameSkipS();
            if (pfx == null) {
                throw (Tokenizer)this.new Tokenizer.MismatchException("NCName");
            }
            String prefix = pfx.toString();
            this.consume(pfx);
            if (!this.attemptSkipS("=")) {
                throw (Tokenizer)this.new Tokenizer.MismatchException("=");
            }
            this.attemptS();
            Tokenizer.Token uriToken = this.laString(false);
            if (uriToken == null) {
                throw (Tokenizer)this.new Tokenizer.MismatchException("URI");
            }
            String uri = uriToken.toString();
            this.consume(uriToken);
            if (!this.attemptSkipS(";")) {
                throw (Tokenizer)this.new Tokenizer.MismatchException(";");
            }
            if (this.namespaces == null) {
                this.namespaces = new TreeMap<String, String>();
            }
            if (this.namespaces.put(prefix, uri) != null) {
                throw new PathException("Multiple declaration of namespace prefix: '%s'", prefix);
            }
            la = this.laSymSkipS("namespace");
        }
    }

    private void startStep() throws PathException {
        if (this.attempt("..")) {
            this.p.parent();
        } else if (this.attempt(".")) {
            this.p.self();
        } else {
            Tokenizer.EQNameToken la = this.laQName();
            if (la != null) {
                this.consume(la);
                this.p.self().child(this.expand(la.qname()));
            }
        }
    }

    private boolean axisStep() throws Tokenizer.TokenizerException, PathException {
        return this.parentStep() || this.selfStep() || this.namedStep();
    }

    private boolean parentStep() {
        if (this.attempt("/..")) {
            this.p.parent();
            return true;
        }
        return false;
    }

    private boolean selfStep() {
        if (this.attempt("/.")) {
            this.p.self();
            return true;
        }
        return false;
    }

    private boolean namedStep() throws Tokenizer.TokenizerException, PathException {
        QNm q = null;
        Tokenizer.Token la = this.la("//");
        if (la != null) {
            if (this.la(la, "@") != null) {
                return false;
            }
            this.consume(la);
            la = this.la("[]");
            if (la != null) {
                this.consume(la);
                this.p.descendantArray();
                return true;
            }
            if (!this.attempt("*")) {
                q = this.name();
            }
            this.p.descendant(this.expand(q));
            return true;
        }
        la = this.la("/");
        if (la != null) {
            if (this.la(la, "@") != null) {
                return false;
            }
            this.consume(la);
            la = this.la("[]");
            if (la != null) {
                this.consume(la);
                this.p.childArray();
                return true;
            }
            if (!this.attempt("*")) {
                q = this.name();
            }
            this.p.child(this.expand(q));
            return true;
        }
        return false;
    }

    private QNm name() throws Tokenizer.TokenizerException {
        int pos = this.position();
        StringBuilder pathSegmentName = new StringBuilder(this.scanString(this.position(), '/'));
        while (pathSegmentName.toString().endsWith("\\") && pos + pathSegmentName.length() + 1 <= this.getEnd()) {
            this.resetTo(pos + pathSegmentName.length() + 1);
            String segment = this.scanString(this.position(), '/');
            if (segment == null) continue;
            pathSegmentName.append("/");
            pathSegmentName.append(segment);
        }
        this.resetTo(pos);
        String[] prefixAndLocalName = pathSegmentName.toString().split(":");
        Tokenizer.EQNameToken token = prefixAndLocalName.length > 1 ? new Tokenizer.EQNameToken(pos, pos + pathSegmentName.length(), null, prefixAndLocalName[0], prefixAndLocalName[1]) : new Tokenizer.EQNameToken(pos, pos + pathSegmentName.length(), null, null, pathSegmentName.toString());
        this.consume(token);
        return token.qname();
    }

    private void attributeStep() throws Tokenizer.TokenizerException, PathException {
        QNm q = null;
        if (this.attempt("//@")) {
            if (!this.attempt("*")) {
                Tokenizer.EQNameToken la = this.laQName();
                if (la == null) {
                    throw (Tokenizer)this.new Tokenizer.MismatchException("Wildcard", "QName");
                }
                this.consume(la);
                q = la.qname();
            }
            this.p.descendantAttribute(this.expand(q));
        } else if (this.attempt("/@")) {
            if (!this.attempt("*")) {
                Tokenizer.EQNameToken la = this.laQName();
                if (la == null) {
                    throw (Tokenizer)this.new Tokenizer.MismatchException("Wildcard", "QName");
                }
                this.consume(la);
                q = la.qname();
            }
            this.p.attribute(this.expand(q));
        }
    }

    private QNm expand(QNm qname) throws PathException {
        if (this.namespaces == null || qname.getPrefix() == null) {
            return qname;
        }
        String uri = this.namespaces.get(qname.getPrefix());
        if (uri == null) {
            throw new PathException("Undefined namespace prefix: %s", qname.getPrefix());
        }
        return new QNm(uri, qname.getPrefix(), qname.getLocalName());
    }
}

