/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.serialize;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Null;
import org.brackit.xquery.atomic.Numeric;
import org.brackit.xquery.util.serialize.Serializer;
import org.brackit.xquery.util.serialize.SubtreePrinter;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Type;
import org.brackit.xquery.xdm.json.Array;
import org.brackit.xquery.xdm.json.JsonItem;
import org.brackit.xquery.xdm.json.Record;
import org.brackit.xquery.xdm.node.Node;

public class StringSerializer
implements Serializer {
    private final PrintWriter out;
    private boolean format;
    private String indent = "  ";

    public StringSerializer(PrintWriter out) {
        this.out = out;
    }

    public StringSerializer(PrintStream out) {
        this.out = new PrintWriter(out);
    }

    public boolean isFormat() {
        return this.format;
    }

    public Serializer setFormat(boolean format) {
        this.format = format;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public Serializer setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Sequence s) throws QueryException {
        if (s == null) {
            return;
        }
        boolean first = true;
        SubtreePrinter printer = new SubtreePrinter(this.out);
        printer.setPrettyPrint(this.format);
        printer.setIndent(this.indent);
        printer.setAutoFlush(false);
        if (this.printJson(s, printer)) {
            return;
        }
        try (Iter it = s.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                if (item instanceof Node) {
                    Node node = (Node)item;
                    Kind kind = node.getKind();
                    if (kind == Kind.ATTRIBUTE) {
                        throw new QueryException(ErrorCode.ERR_SERIALIZE_ATTRIBUTE_OR_NAMESPACE_NODE);
                    }
                    if (kind == Kind.DOCUMENT && (node = node.getFirstChild()) != null) {
                        while (node.getKind() != Kind.ELEMENT) {
                            node = node.getNextSibling();
                        }
                    }
                    if (node != null) {
                        printer.print(node);
                    }
                    first = true;
                    continue;
                }
                if (item instanceof Atomic) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    if (item instanceof JsonItem) {
                        this.json(item, printer, false);
                    } else {
                        this.out.write(item.toString());
                    }
                    first = false;
                    continue;
                }
                if (item instanceof Array) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    this.json(item, printer, true);
                    first = false;
                    continue;
                }
                if (item instanceof Record) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    this.json(item, printer, false);
                    first = false;
                    continue;
                }
                throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Serialization of item type '%s' not implemented yet.", item.itemType());
            }
        }
        finally {
            printer.flush();
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean printJson(Sequence s, SubtreePrinter printer) {
        if (s instanceof Array) {
            try {
                this.json(s, printer, true);
                boolean bl = true;
                return bl;
            }
            finally {
                printer.flush();
                this.out.flush();
            }
        }
        if (s instanceof Record) {
            try {
                this.json(s, printer, false);
                boolean bl = true;
                return bl;
            }
            finally {
                printer.flush();
                this.out.flush();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void json(Sequence s, SubtreePrinter p, boolean isArrayContent) throws QueryException {
        if (s == null || s instanceof Null) {
            this.out.print("null");
            return;
        }
        if (s instanceof Item) {
            if (s instanceof Atomic) {
                if (s instanceof Numeric) {
                    this.out.write(s.toString());
                    return;
                } else if (((Atomic)s).type() == Type.BOOL) {
                    this.out.write(s.booleanValue() ? "true" : "false");
                    return;
                } else if (((Atomic)s).type() == Type.NULL) {
                    this.out.write("null");
                    return;
                } else {
                    this.out.write("\"");
                    this.out.write(s.toString());
                    this.out.write("\"");
                }
                return;
            } else if (s instanceof Array) {
                Array array = (Array)s;
                this.out.write("[");
                for (int i = 0; i < array.len(); ++i) {
                    if (i > 0) {
                        this.out.append(",");
                    }
                    this.json(array.at(i), p, true);
                }
                this.out.write("]");
                return;
            } else if (s instanceof Record) {
                Record record = (Record)s;
                this.out.write("{");
                for (int i = 0; i < record.len(); ++i) {
                    if (i > 0) {
                        this.out.write(",");
                    }
                    this.out.write("\"");
                    this.out.write(record.name(i).stringValue());
                    this.out.write("\":");
                    Sequence value = record.value(i);
                    this.json(value, p, value instanceof Array);
                }
                this.out.write("}");
                return;
            } else {
                void var4_10;
                if (!(s instanceof Node)) throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Serialization of item type '%s' not implemented yet.", ((Item)s).itemType());
                Node node = (Node)s;
                Kind kind = node.getKind();
                if (kind == Kind.ATTRIBUTE) {
                    throw new QueryException(ErrorCode.ERR_SERIALIZE_ATTRIBUTE_OR_NAMESPACE_NODE);
                }
                if (kind == Kind.DOCUMENT) {
                    void var4_8;
                    Object e = node.getFirstChild();
                    while (var4_8.getKind() != Kind.ELEMENT) {
                        Object e2 = var4_8.getNextSibling();
                    }
                }
                this.out.write("\"");
                p.print((Node<?>)var4_10);
                this.out.write("\"");
            }
            return;
        }
        if (!isArrayContent) {
            this.out.write("[");
        }
        try (Iter iter = s.iterate();){
            Item i;
            boolean first = true;
            while ((i = iter.next()) != null) {
                if (!first) {
                    this.out.write(",");
                }
                this.json(i, p, i instanceof Array);
                first = false;
            }
        }
        if (isArrayContent) return;
        this.out.write("]");
    }
}

