/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.serialize;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.node.parser.DefaultHandler;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.node.Node;

public class SubtreePrinter
extends DefaultHandler {
    private final PrintWriter out;
    private boolean printXmlHead = false;
    private boolean prettyPrint = true;
    private boolean autoFlush = true;
    private boolean printEmptyElementTag = true;
    private String indent = "  ";
    private int level;
    private boolean emptyElement;
    private boolean openElement;
    private NS ns;
    private Atomic pendingText;

    public SubtreePrinter(PrintWriter out) {
        this(out, false);
    }

    public SubtreePrinter(PrintWriter out, boolean printXmlHead) {
        this.out = out;
        this.printXmlHead = printXmlHead;
    }

    public SubtreePrinter(PrintWriter out, boolean printXmlHead, boolean prettyPrint) {
        this.out = out;
        this.printXmlHead = printXmlHead;
        this.prettyPrint = prettyPrint;
    }

    public SubtreePrinter(PrintStream out) {
        this(out, false, true);
    }

    public SubtreePrinter(PrintStream out, boolean printXmlHead) {
        this(new PrintWriter(out, false), printXmlHead, false);
    }

    public SubtreePrinter(PrintStream out, boolean printXmlHead, boolean prettyPrint) {
        this(new PrintWriter(out, false), printXmlHead, prettyPrint);
    }

    @Override
    public void attribute(QNm name, Atomic value) throws DocumentException {
        this.out.print(" ");
        this.out.print(name);
        this.out.print("=\"");
        this.out.print(value);
        this.out.print("\"");
    }

    @Override
    public void startDocument() throws DocumentException {
        this.level = 0;
        this.emptyElement = false;
        if (this.printXmlHead) {
            this.out.println("<?xml version=\"1.0\"?>");
        }
    }

    @Override
    public void endDocument() throws DocumentException {
    }

    @Override
    public void end() throws DocumentException {
        if (this.autoFlush) {
            this.out.flush();
        }
        if (this.prettyPrint) {
            this.out.println();
        }
    }

    @Override
    public void endElement(QNm name) throws DocumentException {
        --this.level;
        if (this.emptyElement) {
            if (this.pendingText != null) {
                this.out.print(">");
                this.out.print(this.pendingText);
                this.out.print("</");
                this.out.print(name);
                this.out.print(">");
                this.pendingText = null;
            } else if (this.printEmptyElementTag) {
                this.out.print("/>");
            } else {
                this.out.print(">");
                this.out.print("</");
                this.out.print(name);
                this.out.print(">");
            }
        } else {
            if (this.prettyPrint) {
                this.out.println();
            }
            this.indent();
            this.out.print("</");
            this.out.print(name);
            this.out.print(">");
        }
        this.openElement = false;
        this.emptyElement = false;
    }

    @Override
    public void fail() throws DocumentException {
        this.out.append("Terminating due tu error!");
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    @Override
    public void startElement(QNm name) throws DocumentException {
        this.newChild();
        this.out.print("<");
        this.out.print(name);
        NS n = this.ns;
        while (n != null) {
            if (n.prefix != null && !n.prefix.isEmpty()) {
                this.out.print(" xmlns:");
                this.out.print(n.prefix);
            } else {
                this.out.print(" xmlns");
            }
            this.out.print("=\"");
            this.out.print(n.uri);
            this.out.print("\"");
            n = n.next;
        }
        this.ns = null;
        ++this.level;
        this.openElement = true;
        this.emptyElement = true;
    }

    @Override
    public void text(Atomic value) throws DocumentException {
        if (this.emptyElement) {
            this.pendingText = value;
        } else {
            this.newChild();
            this.out.print(value);
            this.emptyElement = false;
        }
    }

    @Override
    public void comment(Atomic value) throws DocumentException {
        this.newChild();
        this.out.print("<!-- ");
        this.out.print(value);
        this.out.print(" -->");
        this.emptyElement = false;
    }

    @Override
    public void processingInstruction(QNm target, Atomic value) throws DocumentException {
        this.newChild();
        this.out.print("<?");
        this.out.print(target);
        this.out.print(" ");
        this.out.print(value);
        this.out.print("?>");
        this.emptyElement = false;
    }

    private void newChild() {
        if (this.openElement) {
            this.out.print(">");
            this.openElement = false;
        }
        if (this.pendingText != null) {
            if (this.prettyPrint) {
                this.out.println();
            }
            this.indent();
            this.out.print(this.pendingText);
            this.pendingText = null;
        }
        if (this.level > 0 && this.prettyPrint) {
            this.out.println();
        }
        this.indent();
    }

    private void indent() {
        if (this.prettyPrint) {
            for (int i = 0; i < this.level; ++i) {
                this.out.print(this.indent);
            }
        }
    }

    public boolean isPrintXmlHead() {
        return this.printXmlHead;
    }

    public void setPrintXmlHead(boolean printXmlHead) {
        this.printXmlHead = printXmlHead;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public SubtreePrinter setPrettyPrint(boolean indent) {
        this.prettyPrint = indent;
        return this;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public SubtreePrinter setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
        return this;
    }

    public void flush() {
        this.out.flush();
    }

    public boolean isPrintEmptyElementTag() {
        return this.printEmptyElementTag;
    }

    public SubtreePrinter setPrintEmptyElementTag(boolean print) {
        this.printEmptyElementTag = print;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public SubtreePrinter setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public void print(Node<?> node) throws DocumentException {
        node.parse(this);
    }

    public static void print(Node<?> node, PrintStream out) throws DocumentException {
        node.parse(new SubtreePrinter(out));
    }

    public static void print(Node<?> node, PrintWriter out) throws DocumentException {
        node.parse(new SubtreePrinter(out));
    }

    @Override
    public void endMapping(String prefix) throws DocumentException {
    }

    @Override
    public void startMapping(String prefix, String uri) throws DocumentException {
        NS tmp = this.ns;
        this.ns = new NS(prefix, uri);
        this.ns.next = tmp;
    }

    private static class NS {
        private final String prefix;
        private final String uri;
        private NS next;

        NS(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }
    }
}

