/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.sort;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.util.Cfg;
import org.brackit.xquery.util.log.Logger;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Stream;

public class TupleSort {
    private static final Logger log = Logger.getLogger(TupleSort.class);
    private final long maxSize;
    private final Comparator<Tuple> comparator;
    private final File sortDir = new File(Cfg.asString("java.io.tmpdir"));
    private File[] runs;
    private Tuple[] buffer;
    private byte[] mergeBuffer;
    private int count;
    private int runCount;
    private long size;
    private OutputStream currentRun;
    private Tuple lastInRun;
    long leftMergeItemCount;
    long rightMergeItemCount;
    int mergeCount;
    private long directMergeSize;
    private int initialRuns;

    public TupleSort(Comparator<Tuple> comparator, long maxSize) {
        this.comparator = comparator;
        this.maxSize = maxSize;
        this.runs = new File[2];
        this.buffer = new Tuple[10];
    }

    public void add(Tuple item) throws QueryException {
        long itemSize = this.getSize(item);
        if (this.maxSize > 0L && this.size + itemSize > this.maxSize) {
            this.writeRun();
        }
        if (this.count == this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 3 / 2 + 1);
        }
        this.buffer[this.count++] = item;
        this.size += itemSize;
    }

    private long getSize(Tuple item) throws QueryException {
        return 0L;
    }

    private void writeRun() throws QueryException {
        this.sortBuffer();
        if (this.lastInRun != null && this.comparator.compare(this.lastInRun, this.buffer[0]) <= 0) {
            System.out.println("append to run");
            this.appendToRun();
            return;
        }
        try {
            if (this.currentRun != null) {
                this.currentRun.close();
            }
            File run = File.createTempFile("sort", ".run", this.sortDir);
            run.deleteOnExit();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Writing new run '%s'", run));
            }
            this.currentRun = new BufferedOutputStream(new FileOutputStream(run));
            for (int i = 0; i < this.count; ++i) {
                this.lastInRun = this.buffer[i];
                this.writeItem(this.currentRun, this.lastInRun);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Wrote run '%s'", run));
            }
            if (this.runCount == this.runs.length) {
                this.runs = Arrays.copyOf(this.runs, this.runs.length * 3 / 2 + 1);
            }
            this.runs[this.runCount++] = run;
            this.size = 0L;
            this.count = 0;
            ++this.initialRuns;
        }
        catch (IOException e) {
            this.errorCleanup();
            throw new QueryException(e, ErrorCode.BIT_DYN_INT_ERROR);
        }
    }

    private void sortBuffer() throws QueryException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Start main memory sort of %s items.'", this.count));
        }
        try {
            Arrays.sort(this.buffer, 0, this.count, this.comparator);
        }
        catch (ClassCastException e) {
            throw new QueryException(e, ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
        }
        catch (RuntimeException e) {
            throw new QueryException(e, ErrorCode.BIT_DYN_INT_ERROR);
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("Finished main memory sort of %s items", this.count));
        }
    }

    private void appendToRun() throws QueryException {
        try {
            for (int i = 0; i < this.count; ++i) {
                this.lastInRun = this.buffer[i];
                this.writeItem(this.currentRun, this.lastInRun);
            }
            this.count = 0;
            this.size = 0L;
        }
        catch (IOException e) {
            this.errorCleanup();
            throw new QueryException(e, ErrorCode.BIT_DYN_INT_ERROR);
        }
    }

    private void errorCleanup() {
        if (this.currentRun != null) {
            try {
                this.currentRun.close();
            }
            catch (IOException e1) {
                log.error(e1);
            }
        }
        for (File run : this.runs) {
            if (run == null || !run.exists()) continue;
            run.delete();
        }
    }

    private Tuple readItem(InputStream in) throws IOException {
        return null;
    }

    private void writeItem(OutputStream out, Tuple item) throws IOException {
    }

    public Stream<Tuple> stream() {
        return this.runCount == 0 ? this.mainMemorySortOnly() : this.mergeFinalRunAndBuffer();
    }

    public void sort() throws QueryException {
        this.sortBuffer();
        if (this.runCount > 0) {
            this.closeLastRun();
            this.mergeRuns();
        }
    }

    public void clear() {
        if (this.runCount > 0) {
            this.runs[0].delete();
        }
    }

    private void closeLastRun() throws QueryException {
        try {
            this.currentRun.close();
            this.lastInRun = null;
        }
        catch (IOException e) {
            this.errorCleanup();
            throw new QueryException(e, ErrorCode.BIT_DYN_INT_ERROR);
        }
    }

    private Stream<Tuple> mergeFinalRunAndBuffer() {
        final Tuple[] sBuffer = this.buffer;
        return new Stream<Tuple>(){
            private final Comparator<Tuple> cmp;
            private final Tuple[] sortedBuffer;
            private InputStream sorted;
            private Tuple left;
            private Tuple right;
            private int pos;
            {
                this.cmp = TupleSort.this.comparator;
                this.sortedBuffer = sBuffer;
            }

            @Override
            public void close() {
                try {
                    this.sorted.close();
                    TupleSort.this.clear();
                }
                catch (IOException e) {
                    log.error(e);
                }
            }

            @Override
            public Tuple next() throws DocumentException {
                try {
                    Tuple next;
                    if (this.sorted == null) {
                        this.sorted = new BufferedInputStream(new FileInputStream(TupleSort.this.runs[0]));
                        this.left = TupleSort.this.readItem(this.sorted);
                    }
                    if (this.pos == 0) {
                        Tuple tuple = this.right = this.pos < TupleSort.this.count ? this.sortedBuffer[this.pos++] : null;
                    }
                    if (this.left == null) {
                        Tuple next2 = this.right;
                        this.right = this.pos < TupleSort.this.count ? this.sortedBuffer[this.pos++] : null;
                        return next2;
                    }
                    if (this.right == null) {
                        Tuple next3 = this.left;
                        this.left = TupleSort.this.readItem(this.sorted);
                        return next3;
                    }
                    if (this.cmp.compare(this.left, this.right) <= 0) {
                        next = this.left;
                        this.left = TupleSort.this.readItem(this.sorted);
                    } else {
                        next = this.right;
                        this.right = this.pos < TupleSort.this.count ? this.sortedBuffer[this.pos++] : null;
                    }
                    return next;
                }
                catch (IOException e) {
                    throw new DocumentException(e);
                }
            }
        };
    }

    private void mergeRuns() throws QueryException {
        File[] newRuns = null;
        int mergePhase = 0;
        boolean forward = true;
        while (this.runCount > 1) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Starting merge phase %s type %s", mergePhase, forward));
            }
            if (this.mergeBuffer == null) {
                this.mergeBuffer = new byte[Math.max((int)this.maxSize / 20, 1024)];
            }
            if (log.isTraceEnabled()) {
                log.trace("Merge table");
                for (int i = 0; i < this.runCount; ++i) {
                    log.trace(String.format("%3s: %s", i, this.runs[i]));
                }
            }
            int merges = this.runCount / 2;
            boolean singleRun = this.runCount % 2 == 1;
            int newRunCount = merges + (singleRun ? 1 : 0);
            newRuns = new File[newRunCount];
            if (log.isDebugEnabled()) {
                log.debug(String.format("Merge %s -> %s (single run: %s)", this.runCount, newRunCount, singleRun));
            }
            try {
                if (forward) {
                    pos = 0;
                    if (singleRun) {
                        for (i = newRunCount - 1; i > 0; --i) {
                            newRuns[pos++] = this.merge(this.runs[2 * i - 1], this.runs[2 * i]);
                        }
                        newRuns[newRunCount - 1] = this.runs[0];
                    } else {
                        for (i = newRunCount - 1; i >= 0; --i) {
                            newRuns[pos++] = this.merge(this.runs[2 * i], this.runs[2 * i + 1]);
                        }
                    }
                } else {
                    pos = 0;
                    if (singleRun) {
                        for (i = newRunCount - 1; i > 0; --i) {
                            newRuns[pos++] = this.merge(this.runs[2 * i], this.runs[2 * i - 1]);
                        }
                        newRuns[newRunCount - 1] = this.runs[0];
                    } else {
                        for (i = newRunCount - 1; i >= 0; --i) {
                            newRuns[pos++] = this.merge(this.runs[2 * i + 1], this.runs[2 * i]);
                        }
                    }
                }
            }
            catch (QueryException e) {
                for (File newRun : newRuns) {
                    if (newRun == null || !newRun.exists()) continue;
                    newRun.delete();
                }
                throw e;
            }
            forward = !forward;
            this.runCount = newRunCount;
            this.runs = newRuns;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Finished merge phase %s", mergePhase));
            }
            ++mergePhase;
        }
    }

    private Stream<Tuple> mainMemorySortOnly() {
        final Tuple[] sorted = this.buffer;
        final int sortedCount = this.count;
        return new Stream<Tuple>(){
            private int pos;

            @Override
            public void close() {
            }

            @Override
            public Tuple next() throws DocumentException {
                return this.pos < sortedCount ? sorted[this.pos++] : null;
            }
        };
    }

    private File merge(File run1, File run2) throws QueryException {
        InputStream lIn = null;
        InputStream rIn = null;
        OutputStream out = null;
        try {
            int read;
            InputStream pendingIn;
            ++this.mergeCount;
            File run = File.createTempFile("sort", ".run", this.sortDir);
            run.deleteOnExit();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Merging run '%s' and '%s' in new run '%s'", run1, run2, run));
            }
            lIn = new BufferedInputStream(new FileInputStream(run1));
            rIn = new BufferedInputStream(new FileInputStream(run2));
            Tuple left = null;
            Tuple right = null;
            out = new BufferedOutputStream(new FileOutputStream(run));
            left = this.readItem(lIn);
            right = this.readItem(rIn);
            while (left != null && right != null) {
                if (this.comparator.compare(left, right) <= 0) {
                    this.writeItem(out, left);
                    left = this.readItem(lIn);
                    ++this.leftMergeItemCount;
                    continue;
                }
                this.writeItem(out, right);
                right = this.readItem(rIn);
                ++this.rightMergeItemCount;
            }
            Tuple pending = left == null ? right : left;
            InputStream inputStream = pendingIn = left == null ? rIn : lIn;
            if (pending != null) {
                this.writeItem(out, pending);
            }
            while ((read = pendingIn.read(this.mergeBuffer)) > 0) {
                out.write(this.mergeBuffer, 0, read);
                this.directMergeSize += (long)read;
            }
            run1.delete();
            run2.delete();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Wrote run '%s'", run));
            }
            File file = run;
            return file;
        }
        catch (IOException e) {
            this.errorCleanup();
            throw new DocumentException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e1) {
                    log.error(e1);
                }
            }
            if (lIn != null) {
                try {
                    lIn.close();
                }
                catch (IOException e1) {
                    log.error(e1);
                }
            }
            if (rIn != null) {
                try {
                    rIn.close();
                }
                catch (IOException e1) {
                    log.error(e1);
                }
            }
        }
    }

    public String printStats() {
        StringBuilder out = new StringBuilder();
        out.append(String.format("# initial runs: %s # merges: %s", this.initialRuns, this.mergeCount));
        out.append("\n");
        out.append(String.format("Total left merge items: %10s Avg. left merge items per merge: %10.3f", this.leftMergeItemCount, (double)this.leftMergeItemCount / (double)this.mergeCount));
        out.append("\n");
        out.append(String.format("Total right merge items: %10s Avg. right merge items per merge: %10.3f", this.rightMergeItemCount, (double)this.rightMergeItemCount / (double)this.mergeCount));
        out.append("\n");
        out.append(String.format("Directly merged %10.2f MB", (double)this.directMergeSize / 1048576.0));
        out.append("\n");
        return out.toString();
    }
}

