/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.xdm;

import java.math.BigDecimal;
import org.brackit.xquery.atomic.Int;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.Int64;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.xdm.Facets;

public final class Type {
    public static final String NAME_START_CHAR_WITHOUT_COLON_PATTERN = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    public static final String NAME_CHAR_OTHER_PATTERN = "|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    public static final String NAME_START_CHAR_PATTERN = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    public static final String NAME_CHAR_PATTERN = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    public static final String NMTOKEN_PATTERN = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+";
    public static final String NAME_PATTERN = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    public static final String NCNAME_PATTERN = "([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+";
    public static final int DATI_CODE = 1;
    public static final int DATE_CODE = 2;
    public static final int TIME_CODE = 3;
    public static final int DUR_CODE = 4;
    public static final int YMD_CODE = 5;
    public static final int DTD_CODE = 6;
    public static final int NUMERIC_CODE = 7;
    public static final int GYM_CODE = 8;
    public static final int GYE_CODE = 9;
    public static final int GMD_CODE = 10;
    public static final int GDAY_CODE = 11;
    public static final int GMON_CODE = 12;
    public static final int BOOL_CODE = 13;
    public static final int B64_CODE = 14;
    public static final int HEX_CODE = 15;
    public static final int STRING_CODE = 16;
    public static final int QNM_CODE = 17;
    public static final int NOT_CODE = 18;
    public static final int NULL_CODE = 19;
    public static final Type ANY = new Type("anyType", null, true, -1, false, false, false, false);
    public static final Type UN = new Type("untyped", ANY, true, -1, false, false, false, false);
    public static final Type ANS = new Type("anySimpleType", ANY, true, -1, false, false, false, false);
    public static final Type IDRS = new Type("IDREFS", ANS, true, -1, false, false, false, false, new Facets(-1, 1, -1, null, null, null, null, null, null, null, -1, -1));
    public static final Type NMT = new Type("NMTOKENS", ANS, true, -1, false, false, false, false, new Facets(-1, 1, -1, null, null, null, null, null, null, null, -1, -1));
    public static final Type ENTS = new Type("ENTITIES", ANS, true, -1, false, false, false, false, new Facets(-1, 1, -1, null, null, null, null, null, null, null, -1, -1));
    public static final Type ANA = new Type("anyAtomicType", ANS, true, 0, false, false, false, false);
    public static final Type UNA = new Type("untypedAtomic", ANA, true, 16, true, false, false, false);
    public static final Type DATI = new Type("dateTime", ANA, true, 1, true, false, false, true, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type DATE = new Type("date", ANA, true, 2, true, false, false, true, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type TIME = new Type("time", ANA, true, 3, true, false, false, true, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type DUR = new Type("duration", ANA, true, 4, true, false, true, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type YMD = new Type("yearMonthDuration", DUR, true, 5, true, false, true, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type DTD = new Type("dayTimeDuration", DUR, true, 6, true, false, true, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type FLO = new Type("float", ANA, true, 7, true, true, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type DBL = new Type("double", ANA, true, 7, true, true, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type DEC = new Type("decimal", ANA, true, 7, true, true, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type INR = new Type("integer", DEC, true, 7, true, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type NPI = new Type("nonPositiveInteger", INR, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, Int32.ZERO, null, null, null, -1, -1));
    public static final Type NINR = new Type("negativeInteger", NPI, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, Int32.N_ONE, null, null, null, -1, -1));
    public static final Type LON = new Type("long", INR, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, Int64.MAX_VALUE, Int64.MIN_VALUE, null, null, -1, -1));
    public static final Type INT = new Type("int", LON, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, Int32.MAX_VALUE, Int32.MIN_VALUE, null, null, -1, -1));
    public static final Type SHO = new Type("short", INT, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, new Int32(Short.MAX_VALUE), new Int32(Short.MIN_VALUE), null, null, -1, -1));
    public static final Type BYT = new Type("byte", INT, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, new Int32(127), new Int32(-128), null, null, -1, -1));
    public static final Type NNI = new Type("nonNegativeInteger", INR, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, null, Int32.ZERO, null, null, -1, -1));
    public static final Type ULON = new Type("unsignedLong", NNI, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, new Int(new BigDecimal("18446744073709551615")), Int32.ZERO, null, null, -1, -1));
    public static final Type UINT = new Type("unsignedInt", ULON, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, new Int64(0xFFFFFFFFL), Int32.ZERO, null, null, -1, -1));
    public static final Type USHO = new Type("unsignedShort", UINT, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, new Int32(65535), Int32.ZERO, null, null, -1, -1));
    public static final Type UBYT = new Type("unsignedByte", USHO, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, new Int32(255), Int32.ZERO, null, null, -1, -1));
    public static final Type PINR = new Type("positiveInteger", NNI, true, 7, false, true, false, false, new Facets(-1, -1, -1, "[-+]?[0-9]+", null, Facets.WS.COLLAPSE, null, Int32.ONE, null, null, -1, -1));
    public static final Type NULL = new Type("null", ANA, true, 19, true, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.PRESERVE, null, null, null, null, -1, -1));
    public static final Type STR = new Type("string", ANA, true, 16, true, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.PRESERVE, null, null, null, null, -1, -1));
    public static final Type NSTR = new Type("normalizedString", STR, true, 16, false, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.REPLACE, null, null, null, null, -1, -1));
    public static final Type TOK = new Type("token", NSTR, true, 16, false, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type LAN = new Type("language", TOK, true, 16, false, false, false, false, new Facets(-1, -1, -1, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*", null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type NMTS = new Type("NMTOKEN", TOK, true, 16, false, false, false, false, new Facets(-1, -1, -1, "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+", null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type NAM = new Type("Name", TOK, true, 16, false, false, false, false, new Facets(-1, -1, -1, "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*", null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type NCN = new Type("NCName", NAM, true, 16, false, false, false, false, new Facets(-1, -1, -1, "([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+", null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type ID = new Type("ID", NCN, true, 16, false, false, false, false);
    public static final Type IDR = new Type("IDREF", NCN, true, 16, false, false, false, false);
    public static final Type ENT = new Type("ENTITY", NCN, true, 16, false, false, false, false);
    public static final Type GYM = new Type("gYearMonth", ANA, true, 8, true, false, false, true, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type GYE = new Type("gYear", ANA, true, 9, true, false, false, true, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type GMD = new Type("gMonthDay", ANA, true, 10, true, false, false, true, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type GDAY = new Type("gDay", ANA, true, 11, true, false, false, true, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type GMON = new Type("gMonth", ANA, true, 12, true, false, false, true, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type BOOL = new Type("boolean", ANA, true, 13, true, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type B64 = new Type("base64Binary", ANA, true, 14, true, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type HEX = new Type("hexBinary", ANA, true, 15, true, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type AURI = new Type("anyURI", ANA, true, 16, true, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type QNM = new Type("QName", ANA, true, 17, true, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type NOT = new Type("NOTATION", ANA, true, 18, true, false, false, false, new Facets(-1, -1, -1, null, null, Facets.WS.COLLAPSE, null, null, null, null, -1, -1));
    public static final Type[] builtInTypes = new Type[]{ANY, UN, ANS, IDRS, NMT, ENTS, ANA, UNA, DATI, DATE, TIME, DUR, YMD, DTD, FLO, DBL, DEC, INR, NPI, NINR, LON, INT, SHO, BYT, NNI, ULON, UINT, USHO, UBYT, PINR, STR, NSTR, TOK, LAN, NMTS, NAM, NCN, ID, IDR, ENT, GYM, GYE, GMD, GDAY, GMON, BOOL, B64, HEX, AURI, QNM, NOT};
    private final QNm name;
    private final Type parent;
    private final Type primitiveBase;
    private final boolean builtIn;
    private final boolean castPrimitive;
    private final boolean atomic;
    private final int atomicCode;
    private final boolean numeric;
    private final boolean duration;
    private final boolean timeInstance;
    private final Facets facets;

    public Type(QNm name, Type parent, Facets facets) {
        this.name = name;
        this.parent = parent;
        this.builtIn = false;
        this.castPrimitive = false;
        this.atomic = this.instanceOf(ANA);
        this.numeric = parent.numeric;
        this.duration = parent.duration;
        this.timeInstance = parent.timeInstance;
        if (this.atomic) {
            Type t = this;
            while (t != null && !t.castPrimitive) {
                t = t.parent;
            }
            this.primitiveBase = t;
            this.atomicCode = this.primitiveBase.atomicCode;
        } else {
            this.primitiveBase = null;
            this.atomicCode = -1;
        }
        this.facets = facets != null ? facets : (parent != null ? parent.getFacets() : null);
    }

    private Type(String name, Type parent, boolean builtIn, int atomicCode, boolean castPrimitive, boolean numeric, boolean duration, boolean timeInstant) {
        this(name, parent, builtIn, atomicCode, castPrimitive, numeric, duration, timeInstant, null);
    }

    private Type(String name, Type parent, boolean builtIn, int atomicCode, boolean castPrimitive, boolean numeric, boolean duration, boolean timeInstant, Facets facets) {
        this.name = new QNm("http://www.w3.org/2001/XMLSchema", "xs", name);
        this.parent = parent;
        this.builtIn = builtIn;
        this.castPrimitive = castPrimitive;
        this.atomic = atomicCode >= 0;
        this.numeric = numeric;
        this.duration = duration;
        this.timeInstance = timeInstant;
        this.atomicCode = atomicCode;
        if (this.atomic) {
            Type t = this;
            while (t != null && !t.castPrimitive) {
                t = t.parent;
            }
            this.primitiveBase = t;
        } else {
            this.primitiveBase = null;
        }
        this.facets = facets != null ? facets : (parent != null ? parent.getFacets() : null);
    }

    public boolean instanceOf(Type type) {
        Type t = this;
        do {
            if (t != type) continue;
            return true;
        } while ((t = t.parent) != null);
        return false;
    }

    public QNm getName() {
        return this.name;
    }

    public Type getParent() {
        return this.parent;
    }

    public boolean isBuiltin() {
        return this.builtIn;
    }

    public boolean isCastPrimitive() {
        return this.castPrimitive;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isDuration() {
        return this.duration;
    }

    public boolean isTimeInstance() {
        return this.timeInstance;
    }

    public Type getPrimitiveBase() {
        return this.primitiveBase;
    }

    public int atomicCode() {
        return this.atomicCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        return other.name.equals(this.name);
    }

    public Facets getFacets() {
        return this.facets;
    }
}

