/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.xdm;

public class XMLChar {
    public static final String NAME_START_CHAR_WITHOUT_COLON_PATTERN = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    public static final String NAME_CHAR_OTHER_PATTERN = "|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    public static final String NAME_START_CHAR_PATTERN = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    public static final String NAME_CHAR_PATTERN = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    public static final String NMTOKEN_PATTERN = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+";
    public static final String NAME_PATTERN = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    public static final String NCNAME_PATTERN = "([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]||-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+";

    public static boolean isNameStartChar(int c) {
        return c == 58 || 65 <= c && c <= 90 || c == 95 || 97 <= c && c <= 122 || 192 <= c && c <= 214 || 216 <= c && c <= 246 || 248 <= c && c <= 767 || 880 <= c && c <= 893 || 895 <= c && c <= 8191 || 8204 <= c && c <= 8205 || 8304 <= c && c <= 8591 || 11264 <= c && c <= 12271 || 12289 <= c && c <= 55295 || 63744 <= c && c <= 64975 || 65008 <= c && c <= 65533 || 65536 <= c && c <= 983039;
    }

    public static boolean isNameChar(int c) {
        return XMLChar.isNameStartChar(c) || c == 45 || c == 46 || 48 <= c && c <= 57 || c == 183 || 768 <= c && c <= 879 || 8255 <= c && c <= 8256;
    }

    public static boolean isWS(int c) {
        return c == 32 || c == 13 || c == 9 || c == 10;
    }

    public static boolean isChar(int c) {
        return c == 9 || c == 10 || c == 13 || 32 <= c && c <= 55295 || 57344 <= c && c <= 65533 || 65536 <= c && c <= 983039;
    }

    public static String toString(int c) {
        return new String(Character.toChars(c));
    }

    public static boolean isQName(String s) {
        int pos = s.indexOf(58);
        if (pos == -1) {
            return XMLChar.isNCName(s);
        }
        if (pos > 0 && pos < s.length() - 1) {
            return XMLChar.isNCName(s, 0, pos) && XMLChar.isNCName(s, pos + 1, s.length());
        }
        return false;
    }

    public static boolean isNCName(String s) {
        return XMLChar.isNCName(s, 0, s.length());
    }

    public static boolean isNCName(String s, int start, int end) {
        char c;
        if (end <= start) {
            return false;
        }
        int i = start;
        if ((c = s.charAt(i++)) == ':' || !XMLChar.isNameStartChar(c)) {
            return false;
        }
        while (i < end) {
            if ((c = s.charAt(i++)) != ':' && XMLChar.isNameChar(c)) continue;
            return false;
        }
        return true;
    }
}

