/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.xdm.type;

import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Type;
import org.brackit.xquery.xdm.type.ItemType;

public class AtomicType
implements ItemType {
    public static final AtomicType BOOL = new AtomicType(Type.BOOL);
    public static final AtomicType STR = new AtomicType(Type.STR);
    public static final AtomicType DBL = new AtomicType(Type.DBL);
    public static final AtomicType INT = new AtomicType(Type.INT);
    public static final AtomicType INR = new AtomicType(Type.INR);
    public static final AtomicType DEC = new AtomicType(Type.DEC);
    public static final AtomicType DATI = new AtomicType(Type.DATI);
    public static final AtomicType DATE = new AtomicType(Type.DATE);
    public static final AtomicType TIME = new AtomicType(Type.TIME);
    public static final AtomicType DUR = new AtomicType(Type.DUR);
    public static final AtomicType DTD = new AtomicType(Type.DTD);
    public static final AtomicType YMD = new AtomicType(Type.YMD);
    public static final AtomicType QNM = new AtomicType(Type.QNM);
    public static final AtomicType AURI = new AtomicType(Type.AURI);
    public static final AtomicType ANA = new AtomicType(Type.ANA);
    private final Type type;

    public AtomicType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isAnyItem() {
        return false;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isListOrUnion() {
        return false;
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    @Override
    public boolean isJsonItem() {
        return false;
    }

    @Override
    public boolean isStructuredItem() {
        return false;
    }

    @Override
    public boolean matches(Item item) throws QueryException {
        return item instanceof Atomic && ((Atomic)item).type().instanceOf(this.type);
    }

    public boolean instanceOf(AtomicType other) {
        return this.type.instanceOf(other.type);
    }

    public String toString() {
        return this.type.toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AtomicType && ((AtomicType)obj).type.equals(this.type);
    }
}

