/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.brackit.xquery.ResultChecker;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.XQueryBaseTest;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.Null;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.CompileChain;
import org.brackit.xquery.jsonitem.array.DArray;
import org.brackit.xquery.jsonitem.object.ArrayObject;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public final class JsonTest
extends XQueryBaseTest {
    private static final Path JSON_RESOURCES = Paths.get("src", "test", "resources", "json");

    @Ignore
    @Test
    public void testDescVarDeref() throws IOException {
        String query = "let $object := {\"blabla\":{\"foo\":{\"baz\":{\"foo\":\"bar\"}}}}\nlet $foo := \"foo\"\nlet $baz := \"baz\"\nlet $sequence := $object==>$foo=>$baz=>foo\nreturn $sequence\n";
        String result = this.query("let $object := {\"blabla\":{\"foo\":{\"baz\":{\"foo\":\"bar\"}}}}\nlet $foo := \"foo\"\nlet $baz := \"baz\"\nlet $sequence := $object==>$foo=>$baz=>foo\nreturn $sequence\n");
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test
    public void testVarDeref() throws IOException {
        String query = "let $object := {\"foo\":{\"baz\":{\"foo\":\"bar\"}}}\nlet $foo := \"foo\"\nlet $baz := \"baz\"\nlet $sequence := $object=>$foo=>$baz=>foo\nreturn $sequence\n";
        String result = this.query("let $object := {\"foo\":{\"baz\":{\"foo\":\"bar\"}}}\nlet $foo := \"foo\"\nlet $baz := \"baz\"\nlet $sequence := $object=>$foo=>$baz=>foo\nreturn $sequence\n");
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test
    public void testVarDeref2() throws IOException {
        String query = "let $array := [true,false,\"true\",{\"foo\":[\"tada\",{\"baz\":[\"yes\",\"no\",null],\"bar\": null, \"foobar\":\"text\"},{\"baz\":true},{\"baz\":{\"foo\":\"bar\"}}]}]\nlet $sequence := $array[]=>foo[]\nlet $baz := \"baz\"\nlet $sequence2 := $sequence=>$baz=>foo\nreturn $sequence2\n";
        String result = this.query("let $array := [true,false,\"true\",{\"foo\":[\"tada\",{\"baz\":[\"yes\",\"no\",null],\"bar\": null, \"foobar\":\"text\"},{\"baz\":true},{\"baz\":{\"foo\":\"bar\"}}]}]\nlet $sequence := $array[]=>foo[]\nlet $baz := \"baz\"\nlet $sequence2 := $sequence=>$baz=>foo\nreturn $sequence2\n");
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test
    public void testDeref() throws IOException {
        String query = "let $object := {\"foo\":{\"baz\":{\"foo\":\"bar\"}}}\nlet $foo := \"foo\"\nlet $baz := \"baz\"\nlet $sequence := $object=>foo=>baz=>foo\nreturn $sequence\n";
        String result = this.query("let $object := {\"foo\":{\"baz\":{\"foo\":\"bar\"}}}\nlet $foo := \"foo\"\nlet $baz := \"baz\"\nlet $sequence := $object=>foo=>baz=>foo\nreturn $sequence\n");
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test
    public void customModule() throws IOException {
        CompileChain compileChain = new CompileChain();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Path currentRelativePath = Paths.get("", new String[0]).resolve("src").resolve("test").resolve("resources").resolve("modules").resolve("sort.xq");
            String currentPath = currentRelativePath.toAbsolutePath().toString();
            String query = "import module namespace sort = \"https://sirix.io/ns/sort\" at \"%path\";\n\nsort:qsort((7,8,4,5,6,9,3,2,0,1))\n".replace("%path", currentPath);
            XQuery xquery = new XQuery(compileChain, query);
            xquery.serialize(this.ctx, new PrintStream(out));
        }
    }

    @Test
    public void ampersandInFieldAndValue() throws IOException {
        String query = "{\"bar & baz\":\"foo & bar\"}\n";
        String result = this.query("{\"bar & baz\":\"foo & bar\"}\n");
        Assert.assertEquals((Object)"{\"bar & baz\":\"foo & bar\"}", (Object)result);
    }

    @Test
    public void random() throws IOException {
        String query = "let $array := [true,false,\"true\",{\"foo\":[\"tada\",{\"baz\":[\"yes\",\"no\",null],\"bar\": null, \"foobar\":\"text\"},{\"baz\":true}]}]\nlet $sequence := $array[]=>foo[[1]]{baz,foobar}\nlet $resultArray := for $item in bit:values($sequence)\n                    where $item instance of array()\n                    return $item\nreturn $resultArray\n";
        String result = this.query("let $array := [true,false,\"true\",{\"foo\":[\"tada\",{\"baz\":[\"yes\",\"no\",null],\"bar\": null, \"foobar\":\"text\"},{\"baz\":true}]}]\nlet $sequence := $array[]=>foo[[1]]{baz,foobar}\nlet $resultArray := for $item in bit:values($sequence)\n                    where $item instance of array()\n                    return $item\nreturn $resultArray\n");
        Assert.assertEquals((Object)"[\"yes\",\"no\",null]", (Object)result);
    }

    @Test
    public void join() throws IOException {
        String query = "let $stores :=\n[\n  { \"store number\" : 1, \"state\" : \"MA\" },\n  { \"store number\" : 2, \"state\" : \"MA\" },\n  { \"store number\" : 3, \"state\" : \"CA\" },\n  { \"store number\" : 4, \"state\" : \"CA\" }\n]\nlet $sales := [\n   { \"product\" : \"broiler\", \"store number\" : 1, \"quantity\" : 20  },\n   { \"product\" : \"toaster\", \"store number\" : 2, \"quantity\" : 100 },\n   { \"product\" : \"toaster\", \"store number\" : 2, \"quantity\" : 50 },\n   { \"product\" : \"toaster\", \"store number\" : 3, \"quantity\" : 50 },\n   { \"product\" : \"blender\", \"store number\" : 3, \"quantity\" : 100 },\n   { \"product\" : \"blender\", \"store number\" : 3, \"quantity\" : 150 },\n   { \"product\" : \"socks\", \"store number\" : 1, \"quantity\" : 500 },\n   { \"product\" : \"socks\", \"store number\" : 2, \"quantity\" : 10 },\n   { \"product\" : \"shirt\", \"store number\" : 3, \"quantity\" : 10 }\n]\nlet $join :=\n  for $store in $stores, $sale in $sales\n  where $store=>\"store number\" = $sale=>\"store number\"\n  return {\n    \"nb\" : $store=>\"store number\",\n    \"state\" : $store=>state,\n    \"sold\" : $sale=>product\n  }\nreturn [$join]\n";
        String result = this.query("let $stores :=\n[\n  { \"store number\" : 1, \"state\" : \"MA\" },\n  { \"store number\" : 2, \"state\" : \"MA\" },\n  { \"store number\" : 3, \"state\" : \"CA\" },\n  { \"store number\" : 4, \"state\" : \"CA\" }\n]\nlet $sales := [\n   { \"product\" : \"broiler\", \"store number\" : 1, \"quantity\" : 20  },\n   { \"product\" : \"toaster\", \"store number\" : 2, \"quantity\" : 100 },\n   { \"product\" : \"toaster\", \"store number\" : 2, \"quantity\" : 50 },\n   { \"product\" : \"toaster\", \"store number\" : 3, \"quantity\" : 50 },\n   { \"product\" : \"blender\", \"store number\" : 3, \"quantity\" : 100 },\n   { \"product\" : \"blender\", \"store number\" : 3, \"quantity\" : 150 },\n   { \"product\" : \"socks\", \"store number\" : 1, \"quantity\" : 500 },\n   { \"product\" : \"socks\", \"store number\" : 2, \"quantity\" : 10 },\n   { \"product\" : \"shirt\", \"store number\" : 3, \"quantity\" : 10 }\n]\nlet $join :=\n  for $store in $stores, $sale in $sales\n  where $store=>\"store number\" = $sale=>\"store number\"\n  return {\n    \"nb\" : $store=>\"store number\",\n    \"state\" : $store=>state,\n    \"sold\" : $sale=>product\n  }\nreturn [$join]\n");
        Assert.assertEquals((Object)Files.readString(JSON_RESOURCES.resolve("joinresult.json")), (Object)result);
    }

    @Ignore
    @Test
    public void testDynamicFunction() throws IOException {
        String query = "xquery version \"3.0\";\ndeclare namespace db=\"http://sirix.io/xquery/db\";\ndeclare function db:map($func, $list) {\n    for $item in $list return $func($item)\n};\nlet $fun := function($x) { $x * $x }\nreturn db:map($fun, 1 to 5)\n";
        String result = this.query("xquery version \"3.0\";\ndeclare namespace db=\"http://sirix.io/xquery/db\";\ndeclare function db:map($func, $list) {\n    for $item in $list return $func($item)\n};\nlet $fun := function($x) { $x * $x }\nreturn db:map($fun, 1 to 5)\n");
        Assert.assertEquals((Object)"{\"foo\":0} bar {\"baz\":true}", (Object)result);
    }

    @Test
    public void testObjectWithNullAndBooleans() throws IOException {
        String query = "  {\"foo\":null,\"tada\":\"bar\",\"bar\":true,\"baz\":false}\n";
        String result = this.query("  {\"foo\":null,\"tada\":\"bar\",\"bar\":true,\"baz\":false}\n");
        Assert.assertEquals((Object)"{\"foo\":null,\"tada\":\"bar\",\"bar\":true,\"baz\":false}", (Object)result);
    }

    @Test
    public void arrayUnboxing1() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array()\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array()\n");
        Assert.assertEquals((Object)"{\"foo\":0} bar {\"baz\":true}", (Object)result);
    }

    @Test
    public void objectUnboxing() throws IOException {
        String query = "  let $object := {\"foo\": 0, \"bar\": true(), \"baz\":\"tada\"}\n  return $object()\n";
        String result = this.query("  let $object := {\"foo\": 0, \"bar\": true(), \"baz\":\"tada\"}\n  return $object()\n");
        Assert.assertEquals((Object)"foo bar baz", (Object)result);
    }

    @Test
    public void objectLookup() throws IOException {
        String query = "  let $object := {\"foo\": 0, \"bar\": true(), \"baz\":\"tada\"}\n  return $object(\"foo\")\n";
        String result = this.query("  let $object := {\"foo\": 0, \"bar\": true(), \"baz\":\"tada\"}\n  return $object(\"foo\")\n");
        Assert.assertEquals((Object)"0", (Object)result);
    }

    @Test
    public void arrayLookup() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array(0)\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array(0)\n");
        Assert.assertEquals((Object)"{\"foo\":0}", (Object)result);
    }

    @Test
    public void arrayIndex() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array[[1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array[[1]]\n");
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test
    public void negativeArrayIndex() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true}]\n  return $array[[-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true}]\n  return $array[[-1]]\n");
        Assert.assertEquals((Object)"{\"baz\":true}", (Object)result);
    }

    @Test
    public void negativeArrayIndex1() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true}]\n  return $array[[-2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true}]\n  return $array[[-2]]\n");
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test
    public void negativeArrayIndex2() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true}]\n  return $array[[-3]]\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true}]\n  return $array[[-3]]\n");
        Assert.assertEquals((Object)"{\"foo\":0}", (Object)result);
    }

    @Test
    public void negativeArrayIndex3() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true}]\n  return $array[[-1*-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true}]\n  return $array[[-1*-1]]\n");
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test
    public void spreadOperator() throws IOException {
        String query = "  [=(1 to 5)]\n";
        String result = this.query("  [=(1 to 5)]\n");
        Assert.assertEquals((Object)"[1,2,3,4,5]", (Object)result);
    }

    @Test
    public void derefExprWithNegativeArrayIndexExpr() throws IOException {
        String query = "  [true,false,\"true\",{\"foo\":[\"tada\",{\"baz\":\"yes\"},{\"baz\":true}]}][]=>foo[[-1]]=>baz\n";
        String result = this.query("  [true,false,\"true\",{\"foo\":[\"tada\",{\"baz\":\"yes\"},{\"baz\":true}]}][]=>foo[[-1]]=>baz\n");
        Assert.assertEquals((Object)"true", (Object)result);
    }

    @Test
    public void arrayUnboxing2() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[]\n");
        Assert.assertEquals((Object)"{\"foo\":0} bar {\"baz\":true}", (Object)result);
    }

    @Test
    public void arrayUnboxing3() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[]]\n");
        Assert.assertEquals((Object)"{\"foo\":0} bar {\"baz\":true}", (Object)result);
    }

    @Test
    public void arrayIndexSlice1() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:1]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void flattenAsCsv() throws IOException {
        String query = "  let $array := [{\"foo\":0,\"ddd\":\"tztz\"},{\"bar\":\"hello\",\"zzz\":null},{\"baz\":true,\"zzz\":\"yes\"}]\n  let $value := for $object in $array\n                return\n                  let $fields := bit:fields($object)\n                  let $len := bit:len($fields)\n                  for $field at $pos in $fields\n                  return if ($pos < $len) then (\n                    $object=>$field || \",\"\n                  ) else (\n                    $object=>$field || \"\n\"\n                  )\n  return string-join($value,\"\")\n";
        String result = this.query("  let $array := [{\"foo\":0,\"ddd\":\"tztz\"},{\"bar\":\"hello\",\"zzz\":null},{\"baz\":true,\"zzz\":\"yes\"}]\n  let $value := for $object in $array\n                return\n                  let $fields := bit:fields($object)\n                  let $len := bit:len($fields)\n                  for $field at $pos in $fields\n                  return if ($pos < $len) then (\n                    $object=>$field || \",\"\n                  ) else (\n                    $object=>$field || \"\n\"\n                  )\n  return string-join($value,\"\")\n");
        Assert.assertEquals((Object)"0,tztz\nhello,null\ntrue,yes\n".stripIndent(), (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:1:1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:1:1]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement2() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:1:2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:1:2]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement3() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:3:2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:3:2]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0},{\"baz\":true}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement4() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:3:3]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:3:3]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement5() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:3:3]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:3:3]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement6() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::1]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0},\"bar\",{\"baz\":true}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement7() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::2]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0},{\"baz\":true}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement8() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::3]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::3]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement9() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[1::3]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[1::3]]\n");
        Assert.assertEquals((Object)"[\"bar\"]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement10() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:1:3]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:1:3]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement11() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0},\"bar\",{\"baz\":true}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement12() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[1::]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[1::]]\n");
        Assert.assertEquals((Object)"[\"bar\",{\"baz\":true}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement13() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[::-1]]\n");
        Assert.assertEquals((Object)"[{\"baz\":true},\"bar\",{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement14() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:-3:-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:-3:-1]]\n");
        Assert.assertEquals((Object)"[{\"baz\":true},\"bar\"]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement15() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:-4:-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:-4:-1]]\n");
        Assert.assertEquals((Object)"[{\"baz\":true},\"bar\",{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement16() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:-5:-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:-5:-1]]\n");
        Assert.assertEquals((Object)"[{\"baz\":true},\"bar\",{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement17() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:-5:-2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:-5:-2]]\n");
        Assert.assertEquals((Object)"[{\"baz\":true},{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement18() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-1:-5:-2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-1:-5:-2]]\n");
        Assert.assertEquals((Object)"[{\"baz\":true},{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement19() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-2:-5:-2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-2:-5:-2]]\n");
        Assert.assertEquals((Object)"[\"bar\"]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement20() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-2:0:-2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-2:0:-2]]\n");
        Assert.assertEquals((Object)"[\"bar\"]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement21() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-3::-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-3::-1]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement22() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-3:0:-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-3:0:-1]]\n");
        Assert.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement23() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-3:-4:-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-3:-4:-1]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice1WithIncrement24() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-3:-1:-1]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[-3:-1:-1]]\n");
        Assert.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void arrayIndexSlice() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:-2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[0:-2]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0}]", (Object)result);
    }

    @Test
    public void allItemsInArray() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[:]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0},\"bar\",{\"baz\":true}]", (Object)result);
    }

    @Test
    public void emptyArrayIndexSlice1() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[2:2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[2:2]]\n");
        Assert.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void emptyArrayIndexSlice2() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[3:2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[3:2]]\n");
        Assert.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void emptyArrayIndexSlice3() throws IOException {
        String query = "  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[4:2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0}, \"bar\", {\"baz\": true()}]\n  return $array[[4:2]]\n");
        Assert.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void arrayIndexSlice2() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array[[1:]]\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array[[1:]]\n");
        Assert.assertEquals((Object)"[\"bar\",{\"baz\":true}]", (Object)result);
    }

    @Test
    public void arrayIndexSlice3() throws IOException {
        String query = "  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array[[:2]]\n";
        String result = this.query("  let $array := [{\"foo\": 0},\"bar\",{\"baz\":true()}]\n  return $array[[:2]]\n");
        Assert.assertEquals((Object)"[{\"foo\":0},\"bar\"]", (Object)result);
    }

    @Test
    public void objectConstructorWithConcatExpr() throws IOException {
        String query = "  {|\n    for $i in 1 to 3\n    return { \"foo\" || $i : $i }\n  |}\n";
        String result = this.query("  {|\n    for $i in 1 to 3\n    return { \"foo\" || $i : $i }\n  |}\n");
        Assert.assertEquals((Object)"{\"foo1\":1,\"foo2\":2,\"foo3\":3}", (Object)result);
    }

    @Test
    public void objectConstructorWithConcatExpr1() throws IOException {
        String query = "  {|\n    for $i in 1 to 3\n    return { \"foo\" || () || $i : $i }\n  |}\n";
        String result = this.query("  {|\n    for $i in 1 to 3\n    return { \"foo\" || () || $i : $i }\n  |}\n");
        Assert.assertEquals((Object)"{\"foo1\":1,\"foo2\":2,\"foo3\":3}", (Object)result);
    }

    @Test
    public void functionOverloading() throws IOException {
        String query = "declare function local:dummy($test) {\n    $test\n};\n\ndeclare function local:dummy() {\n    local:dummy(\"test\")\n};\n\nlocal:dummy()\n";
        String result = this.query("declare function local:dummy($test) {\n    $test\n};\n\ndeclare function local:dummy() {\n    local:dummy(\"test\")\n};\n\nlocal:dummy()\n");
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void remoteUrl() throws IOException {
        String query = "let $logs := jn:doc('https://raw.githubusercontent.com/sirixdb/brackit/master/logs.json')[]\nlet $total-count := count($logs)\n\nreturn for $log in $logs\n    let $status := $log=>status\n    group by $status\n    order by count($log) descending\n    return {\n        xs:string($status): {\n            \"count\": count($log),\n            \"fraction\": count($log) div $total-count[1]\n        }\n    }\n".stripIndent();
        String result = this.query(query);
        Assert.assertEquals((Object)"{\"200\":{\"count\":409,\"fraction\":0.818}} {\"404\":{\"count\":56,\"fraction\":0.112}} {\"500\":{\"count\":35,\"fraction\":0.07}}", (Object)result);
    }

    @Test
    public void jsonParserEmptyArray() throws IOException {
        String query = "  jn:parse('[]')\n";
        String result = this.query("  jn:parse('[]')\n");
        Assert.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void jsonParserNegativeNumber() throws IOException {
        String query = "  jn:parse('[ 1, -1,    1.1,  -2.5]')\n";
        String result = this.query("  jn:parse('[ 1, -1,    1.1,  -2.5]')\n");
        Assert.assertEquals((Object)"[1,-1,1.1,-2.5]", (Object)result);
    }

    @Test
    public void concatExpr() throws IOException {
        String query = " 1 || 2 || 'foobar'\n";
        String result = this.query(" 1 || 2 || 'foobar'\n");
        Assert.assertEquals((Object)"12foobar", (Object)result);
    }

    @Test
    public void jsonParserEmptyRecord() throws IOException {
        String query = "  jn:parse('{}')\n";
        String result = this.query("  jn:parse('{}')\n");
        Assert.assertEquals((Object)"{}", (Object)result);
    }

    @Test
    public void jsonParserNull() throws IOException {
        String query = "jn:parse('null')";
        String result = this.query("jn:parse('null')");
        Assert.assertEquals((Object)"null", (Object)result);
    }

    @Test
    public void renameObjectField() throws IOException {
        String query = "  let $object := {\"foo\": 0}\n  return rename json $object=>foo as \"bar\"\n";
        this.query("  let $object := {\"foo\": 0}\n  return rename json $object=>foo as \"bar\"\n");
    }

    @Test
    public void appendToArray() throws IOException {
        String query = "  append json (1, 2, 3) into [\"foo\", true(), false(), jn:null()]\n";
        this.query("  append json (1, 2, 3) into [\"foo\", true(), false(), jn:null()]\n");
    }

    @Test
    public void insertIntoArray() throws IOException {
        String query = "  insert json (1, 2, 3) into [\"foo\", true(), false(), jn:null()] at position 2\n";
        this.query("  insert json (1, 2, 3) into [\"foo\", true(), false(), jn:null()] at position 2\n");
    }

    @Test
    public void insertIntoObject1() throws IOException {
        String query = "  insert json {\"foo\": not(true), \"baz\": null} into {\"bar\": false}\n";
        this.query("  insert json {\"foo\": not(true), \"baz\": null} into {\"bar\": false}\n");
    }

    @Test
    public void insertIntoObject2() throws IOException {
        String query = "  let $object := {\"bar\": false()}\n  return insert json {\"foo\": not(true()), \"baz\": jn:null()} into $object\n";
        this.query("  let $object := {\"bar\": false()}\n  return insert json {\"foo\": not(true()), \"baz\": jn:null()} into $object\n");
    }

    @Test
    public void removeFromObject() throws IOException {
        String query = "  delete json {\"foo\": not(true()), \"baz\": jn:null()}=>foo\n";
        this.query("  delete json {\"foo\": not(true()), \"baz\": jn:null()}=>foo\n");
    }

    @Test
    public void removeFromArray() throws IOException {
        String query = "  delete json [\"foo\", 0, 1][[1]]\n";
        this.query("  delete json [\"foo\", 0, 1][[1]]\n");
    }

    @Test
    public void replaceObjectValue() throws IOException {
        String query = "  replace json value of {\"foo\": not(true()), \"baz\": jn:null()}=>foo with 1\n";
        this.query("  replace json value of {\"foo\": not(true()), \"baz\": jn:null()}=>foo with 1\n");
    }

    @Test
    public void replaceArrayValue() throws IOException {
        String query = "  replace json value of [\"foo\", 0, 1][[2]] with \"bar\"\n";
        this.query("  replace json value of [\"foo\", 0, 1][[2]] with \"bar\"\n");
    }

    @Test
    public void testNegativeArrayIndex() throws IOException {
        String query = "  let $array := [true,false,\"true\",{\"foo\":[\"tada\",{\"baz\":\"yes\"},{\"baz\":true}]}]\n  return $array[]=>foo[[-1]]=>baz\n";
        String result = this.query("  let $array := [true,false,\"true\",{\"foo\":[\"tada\",{\"baz\":\"yes\"},{\"baz\":true}]}]\n  return $array[]=>foo[[-1]]=>baz\n");
        Assert.assertEquals((Object)"true", (Object)result);
    }

    @Ignore
    @Test
    public void testDescendantDerefExpr() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("multiple-revisions.json"));
        String query = json + "==>revision=>tada[.=>foo=>baz = 'bar']";
        String result = this.query(query);
        Assert.assertEquals((Object)"[{\"foo\":\"bar\"},{\"baz\":false},\"boo\",{},[{\"foo\":[true,{\"baz\":\"bar\"}]}]]", (Object)result);
    }

    @Test
    public void testDerefExpr() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("multiple-revisions.json"));
        String query = json + "=>sirix[]=>revision=>tada[.[[4]][]=>foo[[0]] = true()]";
        String result = this.query(query);
        Assert.assertEquals((Object)"[{\"foo\":\"bar\"},{\"baz\":false},\"boo\",{},[{\"foo\":[true,{\"baz\":\"bar\"}]}]]", (Object)result);
    }

    @Test
    public void testDerefExpr1() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("multiple-revisions.json"));
        String query = json + "=>sirix[[2]]=>revision=>tada[.[][]=>foo[]=>baz eq 'bar']";
        String result = this.query(query);
        Assert.assertEquals((Object)"[{\"foo\":\"bar\"},{\"baz\":false},\"boo\",{},[{\"foo\":[true,{\"baz\":\"bar\"}]}]]", (Object)result);
    }

    @Test
    public void testDerefExpr2() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("multiple-revisions.json"));
        String query = json + "=>sirix[]=>revision=>tada[]=>foo";
        String result = this.query(query);
        Assert.assertEquals((Object)"bar bar bar", (Object)result);
    }

    @Test
    public void testDerefExpr3() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("multiple-revisions.json"));
        String query = json + "=>sirix[[2]]=>revision=>tada[[4]][[0]]=>foo[[1]]=>baz";
        String result = this.query(query);
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test
    public void testDerefExpr4() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("multiple-revisions.json"));
        String query = json + "=>sirix[[2]]=>revision=>tada[[4]]=>foo[[1]]=>baz";
        String result = this.query(query);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testDerefExpr5() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("multiple-revisions.json"));
        String query = json + "=>sirix[[2]]=>revision=>tada[[4]][[0]]=>foo[]";
        String result = this.query(query);
        Assert.assertEquals((Object)"true {\"baz\":\"bar\"}", (Object)result);
    }

    @Test
    public void testSimpleRecord() throws IOException {
        String query = "{\"key\":jn:null()}";
        String result = this.query("{\"key\":jn:null()}");
        Assert.assertEquals((Object)"{\"key\":null}", (Object)result);
    }

    @Test
    public void testNestedDerefsWithArrays() throws IOException {
        String query = "[{\"key\":0},{\"value\":[{\"key\":{\"boolean\":true()}},{\"newkey\":\"yes\"}]},{\"key\":\"hey\",\"value\":false()}][]=>value[]=>key=>boolean";
        String result = this.query("[{\"key\":0},{\"value\":[{\"key\":{\"boolean\":true()}},{\"newkey\":\"yes\"}]},{\"key\":\"hey\",\"value\":false()}][]=>value[]=>key=>boolean");
        Assert.assertEquals((Object)"true", (Object)result);
    }

    @Test
    public void testArray() throws IOException {
        String query = "{\"foo\": [\"bar\", jn:null(), 2.33],\"bar\": {\"hello\": \"world\", \"helloo\": true()},\"baz\": \"hello\",\"tada\": [{\"foo\": \"bar\"}, {\"baz\": false()}, \"boo\", {}, []]}=>foo";
        String result = this.query("{\"foo\": [\"bar\", jn:null(), 2.33],\"bar\": {\"hello\": \"world\", \"helloo\": true()},\"baz\": \"hello\",\"tada\": [{\"foo\": \"bar\"}, {\"baz\": false()}, \"boo\", {}, []]}=>foo");
        Assert.assertEquals((Object)"[\"bar\",null,2.33]", (Object)result);
    }

    @Test
    public void nestedExpressionsTest() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("user_profiles.json"));
        String query = json + "=>websites[]=>description";
        String result = this.query(query);
        Assert.assertEquals((Object)"work tutorials", (Object)result);
    }

    @Test
    public void nestedExpressionsWithPredicateTest() throws IOException {
        String json = Files.readString(JSON_RESOURCES.resolve("user_profiles.json"));
        String query = json + "=>websites[[]][.=>description eq \"work\"]{description}";
        String result = this.query(query);
        Assert.assertEquals((Object)"{\"description\":\"work\"}", (Object)result);
    }

    @Test
    public void arbitraryExpressionsTest() throws IOException {
        String query = "{ \"a\" : concat('f', 'oo') , 'b' : 1+1, \"c\" : [1,2,3] }";
        String result = this.query("{ \"a\" : concat('f', 'oo') , 'b' : 1+1, \"c\" : [1,2,3] }");
        Assert.assertEquals((Object)"{\"a\":\"foo\",\"b\":2,\"c\":[1,2,3]}", (Object)result);
    }

    @Test
    public void singleQuotedFieldValuesTest() throws IOException {
        String query = "{ 'b': 2, \"c\": 3 }";
        String result = this.query("{ 'b': 2, \"c\": 3 }");
        Assert.assertEquals((Object)"{\"b\":2,\"c\":3}", (Object)result);
    }

    @Test
    public void arrayForLoop1Test() throws IOException {
        String query = "    let $values := [{\"key\": \"hey\"}, {\"key\": 0}]\n    for $i in $values\n    where $i=>key instance of xs:integer and $i=>key eq 0\n    return $i\n";
        String result = this.query("    let $values := [{\"key\": \"hey\"}, {\"key\": 0}]\n    for $i in $values\n    where $i=>key instance of xs:integer and $i=>key eq 0\n    return $i\n");
        Assert.assertEquals((Object)"{\"key\":0}", (Object)result);
    }

    @Test
    public void arrayForLoop2Test() throws IOException {
        String query = "    let $values := [\"foo\",0,true(),jn:null()]\n    for $i in $values\n    return $i\n";
        String result = this.query("    let $values := [\"foo\",0,true(),jn:null()]\n    for $i in $values\n    return $i\n");
        Assert.assertEquals((Object)"foo 0 true null", (Object)result);
    }

    @Test
    public void arrayUnboxing1Test() throws IOException {
        String query = "let $json := [\"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\"] return $json[[]]";
        String result = this.query("let $json := [\"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\"] return $json[[]]");
        Assert.assertEquals((Object)"Sunday Monday Tuesday Wednesday Thursday Friday Saturday", (Object)result);
    }

    @Test
    public void arrayUnboxing2Test() throws IOException {
        String query = "let $json := [[ \"mercury\", \"venus\", \"earth\", \"mars\" ], [ \"monday\", \"tuesday\", \"wednesday\", \"thursday\" ]] return $json[[]]";
        String result = this.query("let $json := [[ \"mercury\", \"venus\", \"earth\", \"mars\" ], [ \"monday\", \"tuesday\", \"wednesday\", \"thursday\" ]] return $json[[]]");
        Assert.assertEquals((Object)"[\"mercury\",\"venus\",\"earth\",\"mars\"] [\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]", (Object)result);
    }

    @Test
    public void arraySizeTest() throws IOException {
        String query = "let $json := [\"mercury\",\"venus\",\"earth\",\"mars\"]\n return bit:len($json)";
        String result = this.query("let $json := [\"mercury\",\"venus\",\"earth\",\"mars\"]\n return bit:len($json)");
        Assert.assertEquals((Object)"4", (Object)result);
    }

    @Test
    public void nestedArrayTest() throws IOException {
        String query = "let $json := [[ \"mercury\", \"venus\", \"earth\", \"mars\" ], [ \"monday\", \"tuesday\", \"wednesday\", \"thursday\" ]] return $json[[0]]";
        String result = this.query("let $json := [[ \"mercury\", \"venus\", \"earth\", \"mars\" ], [ \"monday\", \"tuesday\", \"wednesday\", \"thursday\" ]] return $json[[0]]");
        Assert.assertEquals((Object)"[\"mercury\",\"venus\",\"earth\",\"mars\"]", (Object)result);
    }

    @Test
    public void comletelyNestedArrayTest() throws IOException {
        String query = "let $json := [[ \"mercury\", \"venus\", \"earth\", \"mars\" ], [ \"monday\", \"tuesday\", \"wednesday\", \"thursday\" ]] return $json[[1]][[1]]";
        String result = this.query("let $json := [[ \"mercury\", \"venus\", \"earth\", \"mars\" ], [ \"monday\", \"tuesday\", \"wednesday\", \"thursday\" ]] return $json[[1]][[1]]");
        Assert.assertEquals((Object)"tuesday", (Object)result);
    }

    @Test
    public void recordProjectionTest() throws IOException {
        String query = "let $json := {\"key\": 3, \"foo\": 0} return $json{key}";
        String result = this.query("let $json := {\"key\": 3, \"foo\": 0} return $json{key}");
        Assert.assertEquals((Object)"{\"key\":3}", (Object)result);
    }

    @Test
    public void forEachInRecordTest() throws IOException {
        String query = "let $json := {\"key\": 3, \"foo\": 0} for $key in bit:fields($json) where $json=>$key eq 3\nreturn { $key: $json=>$key }";
        String result = this.query("let $json := {\"key\": 3, \"foo\": 0} for $key in bit:fields($json) where $json=>$key eq 3\nreturn { $key: $json=>$key }");
        Assert.assertEquals((Object)"{\"key\":3}", (Object)result);
    }

    @Test
    public void forEachInArrayTest() throws IOException {
        String query = "for $i in [{\"key\": 3}, {\"key\": 0}] where $i=>key eq 0 return $i";
        String result = this.query("for $i in [{\"key\": 3}, {\"key\": 0}] where $i=>key eq 0 return $i");
        Assert.assertEquals((Object)"{\"key\":0}", (Object)result);
    }

    @Test
    public void arrayTest() throws IOException {
        String query = "[\"foo\",0,true(),jn:null()]";
        String result = this.query("[\"foo\",0,true(),jn:null()]");
        Assert.assertEquals((Object)"[\"foo\",0,true,null]", (Object)result);
    }

    @Test
    public void arrayValuesTest() throws IOException {
        String query = "let $array := [\"foo\",0,true(),jn:null()] for $i in $array return $i";
        String result = this.query("let $array := [\"foo\",0,true(),jn:null()] for $i in $array return $i");
        Assert.assertEquals((Object)"foo 0 true null", (Object)result);
    }

    @Test
    public void composableTest() {
        String query = "{\"foo\":jn:null(),\"bar\":(1,2)}";
        Sequence resultSequence = new XQuery("{\"foo\":jn:null(),\"bar\":(1,2)}").execute(this.ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new ArrayObject(new QNm[]{new QNm("foo"), new QNm("bar")}, new Sequence[]{new Null(), new DArray(List.of(new Int32(1), new Int32(2)))})}), resultSequence);
    }

    @Test
    public void testObjects() throws IOException {
        String query = "let $object1 := { \"Captain\" : \"Kirk\" }\nlet $object2 := { \"First officer\" : \"Spock\" }\nreturn ($object1, \" \", $object2)".indent(4);
        String result = this.query(query);
        Assert.assertEquals((Object)"{\"Captain\":\"Kirk\"}   {\"First officer\":\"Spock\"}", (Object)result);
    }

    @Test
    public void testComposeObjects1() throws IOException {
        String query = "    let $object1 := { \"Captain\" : \"Kirk\" }\n    let $object2 := { \"First officer\" : \"Spock\" }\n    return {| { \"foobar\": $object1 }, $object2 |}\n";
        String result = this.query("    let $object1 := { \"Captain\" : \"Kirk\" }\n    let $object2 := { \"First officer\" : \"Spock\" }\n    return {| { \"foobar\": $object1 }, $object2 |}\n");
        Assert.assertEquals((Object)"{\"foobar\":{\"Captain\":\"Kirk\"},\"First officer\":\"Spock\"}", (Object)result);
    }

    @Test
    public void testComposeObjects2() throws IOException {
        String query = "    let $object1 := { \"Captain\" : \"Kirk\" }\n    let $object2 := { \"First officer\" : \"Spock\" }\n    return {{ \"foobar\": $object1 }, $object2 }\n";
        String result = this.query("    let $object1 := { \"Captain\" : \"Kirk\" }\n    let $object2 := { \"First officer\" : \"Spock\" }\n    return {{ \"foobar\": $object1 }, $object2 }\n");
        Assert.assertEquals((Object)"{\"foobar\":{\"Captain\":\"Kirk\"},\"First officer\":\"Spock\"}", (Object)result);
    }

    @Test
    public void testComposeObjects3() throws IOException {
        String query = "let $r := { \"x\":1, \"y\":2 } return {| $r, { \"z\":3 } |}";
        String result = this.query("let $r := { \"x\":1, \"y\":2 } return {| $r, { \"z\":3 } |}");
        Assert.assertEquals((Object)"{\"x\":1,\"y\":2,\"z\":3}", (Object)result);
    }

    @Test
    public void testComposeObjects4() throws IOException {
        String query = "    let $object1 := { \"Captain\" : \"Kirk\" }\n    let $object2 := { \"First officer\" : \"Spock\" }\n    return {| $object1, $object2 |}\n";
        String result = this.query("    let $object1 := { \"Captain\" : \"Kirk\" }\n    let $object2 := { \"First officer\" : \"Spock\" }\n    return {| $object1, $object2 |}\n");
        Assert.assertEquals((Object)"{\"Captain\":\"Kirk\",\"First officer\":\"Spock\"}", (Object)result);
    }

    @Test
    public void testComposeObjects5() throws IOException {
        String query = "let $object1 := { \"Captain\" : \"Kirk\" } let $object2 := { \"First officer\" : \"Spock\" } return { $object1, $object2 }";
        String result = this.query("let $object1 := { \"Captain\" : \"Kirk\" } let $object2 := { \"First officer\" : \"Spock\" } return { $object1, $object2 }");
        Assert.assertEquals((Object)"{\"Captain\":\"Kirk\",\"First officer\":\"Spock\"}", (Object)result);
    }

    @Test
    public void testObjectLookup() throws IOException {
        String query = "    let $x := { \"eyes\": \"blue\", \"hair\": \"fuchsia\" }\n    let $y := { \"eyes\": \"brown\", \"hair\": \"brown\" }\n    return { \"eyes\": $x=>eyes, \"hair\": $y=>hair }\n";
        String result = this.query("    let $x := { \"eyes\": \"blue\", \"hair\": \"fuchsia\" }\n    let $y := { \"eyes\": \"brown\", \"hair\": \"brown\" }\n    return { \"eyes\": $x=>eyes, \"hair\": $y=>hair }\n");
        Assert.assertEquals((Object)"{\"eyes\":\"blue\",\"hair\":\"brown\"}", (Object)result);
    }

    @Test
    public void testGetAllKeys() throws IOException {
        String query = "let $seq := (\"foo\", [ 1, 2, 3 ], { \"a\" : 1, \"b\" : 2 }, { \"a\" : 3, \"c\" : 4 }) return jn:keys($seq)";
        String result = this.query("let $seq := (\"foo\", [ 1, 2, 3 ], { \"a\" : 1, \"b\" : 2 }, { \"a\" : 3, \"c\" : 4 }) return jn:keys($seq)");
        Assert.assertEquals((Object)"a b c", (Object)result);
    }

    @Test
    public void predicateClauseTest() throws IOException {
        String query = "{\"key\": 3, \"foo\": 0}[.=>key eq 3]";
        String result = this.query("{\"key\": 3, \"foo\": 0}[.=>key eq 3]");
        Assert.assertEquals((Object)"{\"key\":3,\"foo\":0}", (Object)result);
    }

    @Test
    public void dynamicPairsTest1() throws IOException {
        String query = "{ for $d at $i in (\"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ) return { $d : $i } }";
        String result = this.query("{ for $d at $i in (\"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ) return { $d : $i } }");
        Assert.assertEquals((Object)"{\"Sunday\":1,\"Monday\":2,\"Tuesday\":3,\"Wednesday\":4,\"Thursday\":5,\"Friday\":6,\"Saturday\":7}", (Object)result);
    }

    @Test
    public void dynamicPairsTest2() throws IOException {
        String query = "{| for $i in 1 to 10 return { concat(\"Square of \", $i) : $i * $i } |}";
        String result = this.query("{| for $i in 1 to 10 return { concat(\"Square of \", $i) : $i * $i } |}");
        Assert.assertEquals((Object)"{\"Square of 1\":1,\"Square of 2\":4,\"Square of 3\":9,\"Square of 4\":16,\"Square of 5\":25,\"Square of 6\":36,\"Square of 7\":49,\"Square of 8\":64,\"Square of 9\":81,\"Square of 10\":100}", (Object)result);
    }

    @Test
    public void dynamicPairsTest3() throws IOException {
        String query = "let $a := ({\"height\": 5.2}, {\"eyes\": \"blue\"}) return {| $a |}";
        String result = this.query("let $a := ({\"height\": 5.2}, {\"eyes\": \"blue\"}) return {| $a |}");
        Assert.assertEquals((Object)"{\"height\":5.2,\"eyes\":\"blue\"}", (Object)result);
    }

    private String query(String query) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            new XQuery(query).serialize(this.ctx, new PrintStream(out));
            String string = out.toString(StandardCharsets.UTF_8);
            return string;
        }
    }
}

