/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.operator.TupleImpl;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.OperationNotSupportedException;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.json.Array;
import org.brackit.xquery.xdm.json.Object;
import org.brackit.xquery.xdm.node.Node;
import org.junit.Assert;

public class ResultChecker {
    public static void dCheckS(QueryContext ctx, Cursor op, Sequence ... expected) throws QueryException {
        ResultChecker.checkS(ctx, op, expected);
        ResultChecker.checkS(ctx, op, expected);
    }

    public static void checkS(QueryContext ctx, Cursor op, Sequence ... expected) throws QueryException {
        Tuple[] e = new Tuple[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            e[i] = new TupleImpl(expected[i]);
        }
        ResultChecker.checkT(ctx, op, e);
    }

    public static void dCheckT(QueryContext ctx, Cursor op, Tuple ... expected) throws QueryException {
        ResultChecker.checkT(ctx, op, expected);
        ResultChecker.checkT(ctx, op, expected);
    }

    public static void checkT(QueryContext ctx, Cursor op, Tuple ... expected) throws QueryException {
        op.open(ctx);
        for (int i = 0; i < expected.length; ++i) {
            Tuple next = op.next(ctx);
            Assert.assertNotNull((String)"Result is empty", (java.lang.Object)next);
            ResultChecker.checkTuple(ctx, expected[i], next);
        }
        Assert.assertNull((String)"No more results delivered", (java.lang.Object)op.next(ctx));
        op.close(ctx);
    }

    public static void checkTuple(QueryContext ctx, Tuple expected, Tuple result) throws QueryException {
        int eSize = expected.getSize();
        int rSize = result.getSize();
        Assert.assertEquals((String)"Result tuple has same size", (long)eSize, (long)rSize);
        for (int i = 0; i < eSize; ++i) {
            Sequence eSequence = expected.get(i);
            Sequence rSequence = result.get(i);
            ResultChecker.check(eSequence, rSequence);
        }
    }

    public static void dCheck(Sequence expected, Sequence result) throws QueryException {
        ResultChecker.check(expected, result, true);
        ResultChecker.check(expected, result, true);
    }

    public static void dCheck(Sequence expected, Sequence result, boolean nodeIdentity) throws QueryException {
        ResultChecker.check(expected, result, nodeIdentity);
        ResultChecker.check(expected, result, nodeIdentity);
    }

    public static void check(Sequence expected, Sequence result) throws QueryException {
        ResultChecker.compare(expected, result, true);
    }

    public static void check(Sequence expected, Sequence result, boolean nodeIdentity) throws QueryException {
        ResultChecker.compare(expected, result, nodeIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compare(Sequence expected, Sequence result, boolean nodeIdentity) throws QueryException, AssertionError {
        if (expected == null) {
            if (result == null) return;
            try (Iter s = result.iterate();){
                Assert.assertNull((String)"Result sequence is empty", (java.lang.Object)s.next());
            }
            Assert.assertFalse((String)"Result has boolean value of empty sequence", (boolean)result.booleanValue());
            Assert.assertTrue((String)"Result has size of empty sequence", (Int32.ZERO.cmp((Atomic)result.size()) == 0 ? 1 : 0) != 0);
            return;
        }
        Assert.assertNotNull((String)"Result sequence is not empty", (java.lang.Object)result);
        try (Iter es = expected.iterate();
             Iter rs = result.iterate();){
            Item eItem;
            while ((eItem = es.next()) != null) {
                Item rItem = rs.next();
                Assert.assertNotNull((String)"Result sequence has more results", (java.lang.Object)rItem);
                try {
                    Assert.assertEquals((String)"Result item has same type", (java.lang.Object)eItem.itemType(), (java.lang.Object)rItem.itemType());
                    if (eItem instanceof Node) {
                        ResultChecker.compareNode(eItem, rItem, nodeIdentity);
                        continue;
                    }
                    if (eItem instanceof Object) {
                        ResultChecker.compareRecord(eItem, rItem);
                        continue;
                    }
                    if (eItem instanceof Array) {
                        ResultChecker.compareArray(eItem, rItem);
                        continue;
                    }
                    ResultChecker.compareAtomic(eItem, rItem);
                }
                catch (AssertionError e) {
                    System.err.println(String.format("Expected: '%s'\t Result: '%s'", eItem, rItem));
                    throw e;
                }
                catch (QueryException e) {
                    if (e.getCode() != ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) throw e;
                    Assert.fail((String)String.format("Wrong item (type) in result. Expected: '%s'\t Result: '%s'", eItem, rItem));
                    throw e;
                }
            }
            Assert.assertNull((String)"Result sequence has not more results than expected", (java.lang.Object)rs.next());
        }
        try {
            boolean expectedBooleanValue = expected.booleanValue();
            boolean resultBooleanValue = false;
            try {
                resultBooleanValue = result.booleanValue();
            }
            catch (QueryException e) {
                Assert.fail((String)"Result does not have defined boolean value");
            }
            Assert.assertEquals((String)"Result has expected boolean value", (java.lang.Object)expectedBooleanValue, (java.lang.Object)resultBooleanValue);
            return;
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (java.lang.Object)ErrorCode.ERR_INVALID_ARGUMENT_TYPE, (java.lang.Object)e.getCode());
            try {
                result.booleanValue();
                Assert.fail((String)"Result has defined boolean value");
                return;
            }
            catch (QueryException e1) {
                Assert.assertEquals((String)"Correct error code", (java.lang.Object)ErrorCode.ERR_INVALID_ARGUMENT_TYPE, (java.lang.Object)e1.getCode());
            }
        }
    }

    private static void compareArray(Item eItem, Item rItem) {
    }

    private static void compareAtomic(Item eItem, Item rItem) throws QueryException {
        Assert.assertTrue((String)"Result item is atomic", (boolean)(rItem instanceof Atomic));
        Assert.assertTrue((String)"Result atomic is equal to expected", (boolean)((Atomic)eItem).eq((Atomic)rItem));
    }

    private static void compareRecord(Item eItem, Item rItem) throws DocumentException {
        Assert.assertTrue((String)"Result item is record", (boolean)(rItem instanceof Object));
        Object eNode = (Object)eItem;
        Object rNode = (Object)rItem;
        Assert.assertEquals((java.lang.Object)eNode.size(), (java.lang.Object)rNode.size());
    }

    private static void compareNode(Item eItem, Item rItem, boolean nodeIdentity) throws DocumentException {
        Assert.assertTrue((String)"Result item is node", (boolean)(rItem instanceof Node));
        Node eNode = (Node)eItem;
        Node rNode = (Node)rItem;
        if (nodeIdentity) {
            Assert.assertTrue((String)"Result node is equal to expected", (boolean)eNode.isSelfOf(rNode));
        } else {
            ResultChecker.compareNode(eNode, rNode);
        }
    }

    private static void compareNode(Node<?> eNode, Node<?> rNode) throws DocumentException, OperationNotSupportedException {
        Assert.assertEquals((String)"Node kind is correct", (java.lang.Object)eNode.getKind(), (java.lang.Object)rNode.getKind());
        if (eNode.getKind() == Kind.DOCUMENT) {
            ResultChecker.compareChildren(eNode, rNode);
        } else {
            Assert.assertEquals((String)"Node name is correct", (java.lang.Object)eNode.getName(), (java.lang.Object)rNode.getName());
            if (eNode.getKind() == Kind.ELEMENT) {
                ResultChecker.compareAttributes(eNode, rNode);
                ResultChecker.compareChildren(eNode, rNode);
            } else {
                Assert.assertEquals((String)"Node value correct", (java.lang.Object)eNode.getValue(), (java.lang.Object)rNode.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compareChildren(Node<?> eNode, Node<?> rNode) throws DocumentException {
        try (Stream eChildren = eNode.getChildren();
             Stream rChildren = rNode.getChildren();){
            Node eChild;
            while ((eChild = (Node)eChildren.next()) != null) {
                Node rChild = (Node)rChildren.next();
                Assert.assertNotNull((String)"Child is in result", (java.lang.Object)rChild);
                ResultChecker.compareNode(eChild, rChild);
            }
            Assert.assertNull((String)"Result has no further children", (java.lang.Object)rChildren.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compareAttributes(Node<?> eNode, Node<?> rNode) throws DocumentException {
        try (Stream eAtts = eNode.getAttributes();
             Stream rAtts = rNode.getAttributes();){
            Node eAtt;
            while ((eAtt = (Node)eAtts.next()) != null) {
                Node rAtt = (Node)rAtts.next();
                Assert.assertNotNull((String)"Attribute is in result", (java.lang.Object)rAtt);
                Assert.assertEquals((String)"Node kind is correct", (java.lang.Object)Kind.ATTRIBUTE, (java.lang.Object)rAtt.getKind());
                Assert.assertEquals((String)"Node name is correct", (java.lang.Object)eAtt.getName(), (java.lang.Object)rAtt.getName());
                Assert.assertEquals((String)"Node name value correct", (java.lang.Object)eAtt.getValue(), (java.lang.Object)rAtt.getValue());
            }
            Assert.assertNull((String)"Result has no further attributes", (java.lang.Object)rAtts.next());
        }
    }
}

