/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery;

import org.brackit.xquery.QueryException;
import org.brackit.xquery.ResultChecker;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.XQueryBaseTest;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.node.parser.DocumentParser;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;
import org.junit.Before;
import org.junit.Test;

public class UpdateFacilityTest
extends XQueryBaseTest {
    private static final String DOCUMENT = "<a><b>text1<b>text2</b></b><c>text2</c></a>";
    Node<?> doc;
    Node<?> orig;

    @Test
    public void insertInto() {
        this.ctx.setContextItem(this.doc);
        this.orig.getFirstChild().append(Kind.ELEMENT, new QNm("test"), null);
        new XQuery("insert node <test/> into ./a").execute(this.ctx);
        ResultChecker.dCheck(this.orig, this.doc, false);
    }

    @Test
    public void simpleDelete() {
        this.ctx.setContextItem(this.doc);
        new XQuery("delete node ./a/c").execute(this.ctx);
        this.orig.getFirstChild().getLastChild().delete();
        ResultChecker.dCheck(this.orig, this.doc, false);
    }

    @Test
    public void simpleReplaceNode() {
        this.ctx.setContextItem(this.doc);
        new XQuery("replace node ./a/c with <d/>").execute(this.ctx);
        this.orig.getFirstChild().getLastChild().replaceWith(Kind.ELEMENT, new QNm("d"), null);
        ResultChecker.dCheck(this.orig, this.doc, false);
    }

    @Test
    public void simpleRename() {
        this.ctx.setContextItem(this.doc);
        new XQuery("rename node ./a as 'b'").execute(this.ctx);
        this.orig.getFirstChild().setName(new QNm("b"));
        ResultChecker.dCheck(this.orig, this.doc, false);
    }

    @Test
    public void transformTestSimple() {
        Sequence res = new XQuery("copy $n := <a att='1'><b/></a> modify delete node $n/@att return $n").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.append(Kind.ELEMENT, new QNm("b"), null);
        ResultChecker.dCheck((Sequence)a, res, false);
    }

    @Test
    public void transformTestDeleteBoundCopy() {
        Sequence res = new XQuery("copy $n := <a att='1'><b/></a> modify delete node $n return $n").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.setAttribute(new QNm("att"), (Atomic)new Una("1"));
        a.append(Kind.ELEMENT, new QNm("b"), null);
        ResultChecker.dCheck((Sequence)a, res, false);
    }

    @Test(expected=DocumentException.class)
    public void transformIllegalExpression() {
        new XQuery("copy $c := <x a='a'/> modify (delete node $c/@a, insert node attribute a { 'b' } into $c) return $c").execute(this.ctx);
    }

    @Test(expected=QueryException.class)
    public void transformIllegalExpressionSecond() {
        new XQuery("copy $c := <x a='a'/> modify (delete node $c/@a, insert node attribute a { 'b' } into $c, replace node $c/@a with attribute a { 'b' }) return $c").execute(this.ctx);
    }

    @Test
    public void transformModifyFirst() {
        Sequence res = new XQuery("copy $c := <n><a/><a/></n> modify for $a in $c//a return replace node $a with <b/> return $c").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("n"));
        a.append(Kind.ELEMENT, new QNm("b"), null);
        a.append(Kind.ELEMENT, new QNm("b"), null);
        ResultChecker.dCheck((Sequence)a, res, false);
    }

    @Test
    public void transformModifySecond() {
        String xq = "copy $foo := <foo/> modify   for $x in ('b', 'a')   order by $x   return insert node text { $x } into $foo return $foo";
        Sequence res = new XQuery("copy $foo := <foo/> modify   for $x in ('b', 'a')   order by $x   return insert node text { $x } into $foo return $foo").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("foo"));
        a.append(Kind.TEXT, null, (Atomic)new Str("ab"));
        ResultChecker.dCheck((Sequence)a, res, false);
    }

    @Test
    public void transformTestTwoCopyVars() {
        Sequence res = new XQuery("let $f := <a att='1'><b/></a> return copy $m := $f, $n := $f, $o := $f modify delete node $n/b return ($m, $n)").execute(this.ctx);
        Node a1 = this.ctx.getNodeFactory().element(new QNm("a"));
        a1.setAttribute(new QNm("att"), (Atomic)new Una("1"));
        a1.append(Kind.ELEMENT, new QNm("b"), null);
        Node a2 = this.ctx.getNodeFactory().element(new QNm("a"));
        a2.setAttribute(new QNm("att"), (Atomic)new Una("1"));
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{a1, a2}), res, false);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.doc = this.ctx.getNodeFactory().build((SubtreeParser)new DocumentParser(DOCUMENT));
        this.orig = this.ctx.getNodeFactory().build((SubtreeParser)new DocumentParser(DOCUMENT));
    }
}

