/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Random;
import org.brackit.xquery.BrackitQueryContext;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.atomic.DTD;
import org.brackit.xquery.node.SimpleNodeStore;
import org.brackit.xquery.node.parser.DocumentParser;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.util.serialize.SubtreePrinter;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.node.NodeCollection;
import org.brackit.xquery.xdm.node.NodeStore;
import org.junit.Before;
import org.junit.Ignore;

@Ignore
public class XQueryBaseTest {
    public static final Path RESOURCES = Paths.get("src", "test", "resources");
    protected QueryContext ctx;
    protected Random rand;
    protected NodeStore store;

    protected void print(Sequence s) throws QueryException {
        if (s == null) {
            return;
        }
        try (Iter it = s.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                System.out.print(item);
                System.out.print(" ");
                if (!(item instanceof Node) || ((Node)item).getKind() == Kind.ATTRIBUTE) continue;
                new SubtreePrinter(System.out, false, false).print((Node)item);
            }
        }
        System.out.println();
    }

    protected XQuery xquery(String query) throws QueryException {
        return new XQuery(query);
    }

    protected PrintStream createBuffer() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        return new PrintStream(out){
            final OutputStream baos;
            {
                this.baos = this.out;
            }

            public String toString() {
                return this.baos.toString();
            }
        };
    }

    protected String readFile(Path dirname, String filename) throws IOException {
        return Files.readString(dirname.resolve(filename));
    }

    protected NodeCollection<?> storeFile(String name, Path document) throws Exception {
        DocumentParser parser = new DocumentParser(document.toFile());
        parser.setRetainWhitespace(true);
        return this.storeDocument(name, (SubtreeParser)parser);
    }

    protected NodeCollection<?> storeDocument(String name, String document) {
        return this.storeDocument(name, (SubtreeParser)new DocumentParser(document));
    }

    protected NodeCollection<?> storeDocument(String name, SubtreeParser parser) {
        NodeCollection collection = this.store.create(name, parser);
        return collection;
    }

    protected NodeStore createStore() throws Exception {
        return new SimpleNodeStore();
    }

    protected QueryContext createContext() throws Exception {
        return new BrackitQueryContext(this.store){

            public DTD getImplicitTimezone() {
                return new DTD(false, 0, 2, 0, 0);
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        this.store = this.createStore();
        this.ctx = this.createContext();
        this.rand = new Random(12345678L);
    }
}

