/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler;

import java.util.ArrayList;
import java.util.List;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.ResultChecker;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.XQueryBaseTest;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.BaseResolver;
import org.brackit.xquery.compiler.CompileChain;
import org.brackit.xquery.compiler.ModuleResolver;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.junit.Assert;
import org.junit.Test;

public class LibraryModulesTest
extends XQueryBaseTest {
    private static final String RIGHT = "module namespace right='right'; import module namespace left='left'; declare function right:foo() {2};";
    private static final String LEFT = "module namespace left='left'; import module namespace right='right'; declare function left:foo() {1};";
    private static final String FOO = "module namespace foo=\"http://brackit.org/lib/foo\"; declare function foo:echo($s as item()*) as item()* { ($s, $s) };";
    private static final String FOO2 = "module namespace foo=\"http://brackit.org/lib/foo\"; declare function foo:echo2($s as item()*) as item()* { ($s, $s) };";
    private static final String BAR = "module namespace bar=\"http://brackit.org/lib/bar\"; declare function bar:echo2($s as item()*) as item()* { ($s, $s) };";
    private static final String IMPORT_FOO = "import module namespace foo=\"http://brackit.org/lib/foo\"; ";
    private static final String IMPORT_BAR = "import module namespace bar=\"http://brackit.org/lib/bar\"; ";

    @Test
    public void defineModule() {
        XQuery xq = new XQuery(FOO);
        xq.getModule();
    }

    @Test
    public void importModule() throws Exception {
        final BaseResolver res = new BaseResolver();
        CompileChain chain = new CompileChain(){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new XQuery(chain, FOO);
        XQuery xq = new XQuery(chain, "import module namespace foo=\"http://brackit.org/lib/foo\"; foo:echo('y')");
        QueryContext ctx = this.createContext();
        Sequence result = xq.execute(ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Str("y"), new Str("y")}), result);
    }

    @Test
    public void importModulesInSameTargetNS() throws Exception {
        final BaseResolver res = new BaseResolver();
        CompileChain chain = new CompileChain(){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new XQuery(chain, FOO);
        new XQuery(chain, FOO2);
        XQuery xq = new XQuery(chain, "import module namespace foo=\"http://brackit.org/lib/foo\"; (foo:echo('y'), foo:echo2('y'))");
        QueryContext ctx = this.createContext();
        Sequence result = xq.execute(ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Str("y"), new Str("y"), new Str("y"), new Str("y")}), result);
    }

    @Test
    public void importModulesInDifferentTargetNS() throws Exception {
        final BaseResolver res = new BaseResolver();
        CompileChain chain = new CompileChain(){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new XQuery(chain, FOO);
        new XQuery(chain, BAR);
        XQuery xq = new XQuery(chain, "import module namespace foo=\"http://brackit.org/lib/foo\"; import module namespace bar=\"http://brackit.org/lib/bar\"; (foo:echo('y'), bar:echo2('y'))");
        QueryContext ctx = this.createContext();
        Sequence result = xq.execute(ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Str("y"), new Str("y"), new Str("y"), new Str("y")}), result);
    }

    @Test
    public void importModulesInSameTargetNSWithConflict() {
        final BaseResolver res = new BaseResolver();
        CompileChain chain = new CompileChain(){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new XQuery(chain, FOO);
        new XQuery(chain, FOO);
        try {
            new XQuery(chain, "import module namespace foo=\"http://brackit.org/lib/foo\"; foo:echo('y')");
            Assert.fail((String)"double definition of function not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((Object)"XQST0034", (Object)e.getCode().getLocalName());
        }
    }

    @Test
    public void importDirectCyclicModule() {
        final BaseResolver res = new BaseResolver(){

            public List<String> load(String uri, String[] locations) {
                if (!uri.equals("right")) {
                    return null;
                }
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(LibraryModulesTest.RIGHT);
                return list;
            }
        };
        CompileChain chain = new CompileChain(){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new XQuery(chain, LEFT);
    }

    @Test
    public void importDirectCyclicModule2() {
        final BaseResolver res = new BaseResolver(){

            public List<String> load(String uri, String[] locations) {
                if (uri.equals("right")) {
                    ArrayList<String> l = new ArrayList<String>(1);
                    l.add(LibraryModulesTest.RIGHT);
                    return l;
                }
                if (uri.equals("left")) {
                    ArrayList<String> l = new ArrayList<String>(1);
                    l.add(LibraryModulesTest.LEFT);
                    return l;
                }
                return null;
            }
        };
        CompileChain chain = new CompileChain(){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        XQuery xq = new XQuery(chain, "import module namespace left='left'; import module namespace right='right'; right:foo() + left:foo()");
        Sequence result = xq.execute(this.ctx);
        ResultChecker.check((Sequence)new Int32(3), result);
    }
}

