/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.parser;

import java.nio.file.Files;
import java.nio.file.Path;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.XQueryBaseTest;
import org.brackit.xquery.compiler.parser.XQParser;
import org.junit.Assert;
import org.junit.Test;

public class XQParserTest
extends XQueryBaseTest {
    private static final Path PARSER = RESOURCES.resolve("parser");

    @Test
    public void emptyArray() {
        new XQParser("[]").parse();
    }

    @Test
    public void emptyRecord() {
        new XQParser("{}").parse();
    }

    @Test
    public void ncname() {
        new XQParser("declare").parse();
    }

    @Test
    public void qname() {
        new XQParser("declare").parse();
    }

    @Test
    public void emptyElement() {
        new XQParser("<a/>").parse();
    }

    @Test
    public void nestedElements() {
        new XQParser("<a><b></b></a>").parse();
    }

    @Test
    public void emptyElementWithAttribute() {
        new XQParser("<a b='a'/>").parse();
    }

    @Test
    public void elementWithAttribute() {
        new XQParser("<a b='a'></a>").parse();
    }

    @Test
    public void elementsWithComplexContent() {
        new XQParser("<a>1&amp;<b/>12 {'aha'}soso<c/></a>").parse();
    }

    @Test
    public void elementWithComplexContent2() {
        new XQParser("string(<elem>{'a'} a {1,2,3} b <![CDATA[ b ]]> c {'a', 'b'}</elem>)").parse();
    }

    @Test
    public void illegallyNestedElements() {
        try {
            new XQParser("<a><b></a>").parse();
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"illegal error code", (Object)ErrorCode.ERR_PARSING_ERROR, (Object)e.getCode());
        }
    }

    @Test
    public void nestedForBindNameOverlap() {
        new XQParser("for $a in for $a in 1 return $a return $a").parse();
    }

    @Test
    public void nestedForBindRename() {
        new XQParser("for $a in 1 return for $a in 2 return for $a in $a return $a").parse();
    }

    @Test
    public void weirdPart2() {
        new XQParser("else- +-++-**-* instance  of element(*)* * * **---++div- div -div").parse();
    }

    @Test
    public void weird() throws Exception {
        new XQParser(Files.readString(PARSER.resolve("weird.xq"))).parse();
    }

    @Test
    public void constructedAttributeWithEmptyContentSequence() {
        new XQParser("attribute {'foo'} {}").parse();
    }

    @Test
    public void constructedPI() {
        new XQParser("processing-instruction XmL {'pi'}").parse();
    }

    @Test
    public void onlyWSbetweenToken() {
        new XQParser("for\n$\na in 1 return $a").parse();
    }

    @Test
    public void parentAxis() {
        new XQParser("a/../b").parse();
    }

    @Test
    public void stringLiteralWithEntityReference() {
        new XQParser("\"a string &amp;\"").parse();
    }
}

