/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.io.PrintStream;
import org.brackit.xquery.ResultChecker;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.XQueryBaseTest;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.node.parser.DocumentParser;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DirConstructorTest
extends XQueryBaseTest {
    @Test
    public void dirAttributeContent1() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<shoe size=\"7\"/>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<shoe size=\"7\"/>", (Object)buf.toString());
    }

    @Test
    public void dirAttributeContent2() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<shoe size=\"{7}\"/>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<shoe size=\"7\"/>", (Object)buf.toString());
    }

    @Test
    public void dirAttributeContent3() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<shoe size=\"{()}\"/>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<shoe size=\"\"/>", (Object)buf.toString());
    }

    @Test
    public void dirAttributeContent4() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<shoe size=\"[{1, 5 to 7, 9}]\"/>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<shoe size=\"[1 5 6 7 9]\"/>", (Object)buf.toString());
    }

    @Test
    public void dirElementContent1() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<a>{1}</a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a>1</a>", (Object)buf.toString());
    }

    @Test
    public void dirElementContent2() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<a>{1, 2, 3}</a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a>1 2 3</a>", (Object)buf.toString());
    }

    @Test
    public void dirElementContent3() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<a>{1}{2}{3}</a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a>123</a>", (Object)buf.toString());
    }

    @Test
    public void dirElementContent4() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<a>{1, \"2\", \"3\"}</a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a>1 2 3</a>", (Object)buf.toString());
    }

    @Test
    public void dirElementContent5() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<fact>I saw {5 + 3} cats.</fact>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<fact>I saw 8 cats.</fact>", (Object)buf.toString());
    }

    @Test
    public void dirElementContent6a() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("<fact>I saw <howmany>{5 + 3}</howmany> cats.</fact>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<fact>I saw <howmany>8</howmany> cats.</fact>", (Object)buf.toString());
    }

    @Test
    public void dirElementContent6b() throws Exception {
        Sequence res = new XQuery("<fact>I saw <howmany>{5 + 3}</howmany> cats.</fact>").execute(this.ctx);
        DocumentParser parser = new DocumentParser("<fact>I saw <howmany>8</howmany> cats.</fact>");
        parser.setRetainWhitespace(true);
        Node doc = this.ctx.getNodeFactory().build((SubtreeParser)parser);
        Node fact = doc.getFirstChild();
        ResultChecker.dCheck((Sequence)fact, res, false);
    }

    @Test
    public void boundarySpaceStrip() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("declare boundary-space strip; <cat>\n    <breed>2</breed>\n    <color>4</color>2 \t\n</cat>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<cat><breed>2</breed><color>4</color>2 \t\n</cat>", (Object)buf.toString());
    }

    @Test
    public void directElementExpr() throws Exception {
        Sequence result = new XQuery("<a/>").execute(this.ctx);
        ResultChecker.dCheck((Sequence)this.ctx.getNodeFactory().element(new QNm("a")), result, false);
    }

    @Test
    public void directElementExprWithEmptyAttribute() throws Exception {
        Sequence result = new XQuery("<a b=''/>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.setAttribute(new QNm("b"), (Atomic)new Una(""));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void directElementExprWithAttribute() throws Exception {
        Sequence result = new XQuery("<a b='c'/>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.setAttribute(new QNm("b"), (Atomic)new Una("c"));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void directElementExprWithAttributeAndComputedValue() throws Exception {
        Sequence result = new XQuery("<a b=\"{1 + 2}\"/> ").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.setAttribute(new QNm("b"), (Atomic)new Una("3"));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void directElementExprWith2Attributes() throws Exception {
        Sequence result = new XQuery("<a b='c' d='e'/>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.setAttribute(new QNm("b"), (Atomic)new Una("c"));
        a.setAttribute(new QNm("d"), (Atomic)new Una("e"));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void directElementExprWith2AttributesAndComputedValue() throws Exception {
        Sequence result = new XQuery("<a b='{1 + 2}'   c='{2 + 2}'/>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.setAttribute(new QNm("b"), (Atomic)new Una("3"));
        a.setAttribute(new QNm("c"), (Atomic)new Una("4"));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void directElementExprWithText() throws Exception {
        Sequence result = new XQuery("<a>test</a>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.append(Kind.TEXT, null, (Atomic)new Una("test"));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void directElementExprWithChildren() throws Exception {
        Sequence result = new XQuery("<a><b/><c/></a>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.append(Kind.ELEMENT, new QNm("b"), null);
        a.append(Kind.ELEMENT, new QNm("c"), null);
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void directElementExprWithComputedContent() throws Exception {
        Sequence result = new XQuery("<a>{(1 to 3)}</a>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.append(Kind.TEXT, null, (Atomic)new Una("1 2 3"));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void directElementExprWithComputedSequenceContent() throws Exception {
        Sequence result = new XQuery("<a>{1, 2, 3}</a>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        a.append(Kind.TEXT, null, (Atomic)new Una("1 2 3"));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void nesteddirectElementExprInSequence() throws Exception {
        Sequence result = new XQuery("<a>{<b>{2 + 4}</b>, 1}</a>").execute(this.ctx);
        Node a = this.ctx.getNodeFactory().element(new QNm("a"));
        Node b = a.append(Kind.ELEMENT, new QNm("b"), null);
        b.append(Kind.TEXT, null, (Atomic)new Una("6"));
        a.append(Kind.TEXT, null, (Atomic)new Una("1"));
        ResultChecker.dCheck((Sequence)a, result, false);
    }

    @Test
    public void boundarySpace1() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("declare boundary-space strip; <a> {\"abc\"} </a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a>abc</a>", (Object)buf.toString());
    }

    @Test
    public void boundarySpace2() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("declare boundary-space preserve; <a> {\"abc\"} </a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a> abc </a>", (Object)buf.toString());
    }

    @Test
    public void boundarySpace3() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("declare boundary-space preserve; <a> z {\"abc\"}</a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a> z abc</a>", (Object)buf.toString());
    }

    @Test
    public void boundarySpace4() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("declare boundary-space preserve; <a>&#x20;{\"abc\"}</a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a> abc</a>", (Object)buf.toString());
    }

    @Test
    public void boundarySpace5() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("declare boundary-space preserve; <a>  &#x20;  {\"abc\"}</a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a>     abc</a>", (Object)buf.toString());
    }

    @Ignore
    @Test
    public void boundarySpace6() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("declare boundary-space preserve; <a> &#8364; </a>").serialize(this.ctx, buf);
        Assert.assertEquals((String)"serialized result differs", (Object)"<a> \u20ac </a>", (Object)buf.toString());
    }

    @Test
    public void elementWithNamespace() throws Exception {
        PrintStream buf = this.createBuffer();
        Sequence res = new XQuery("<e xmlns:f=\"foo\" xmlns=\"bla\" f:att=\"\"><f/></e>").execute(this.ctx);
    }
}

