/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.io.PrintStream;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.ResultChecker;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.XQueryBaseTest;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.node.NodeCollection;
import org.junit.Assert;
import org.junit.Test;

public class PathExprTest
extends XQueryBaseTest {
    @Test
    public void oneChildStepPathExpr() throws Exception {
        NodeCollection<?> locator = this.storeDocument("test.xml", "<a><b/><b/></a>");
        Node documentNode = locator.getDocument();
        Node root = documentNode.getFirstChild();
        this.ctx.setContextItem((Item)root);
        Sequence result = new XQuery("b").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{root.getFirstChild(), root.getLastChild()}), result);
    }

    @Test
    public void singleSlashStepPathExpr() throws Exception {
        NodeCollection<?> locator = this.storeDocument("test.xml", "<a><b/><b/></a>");
        Node documentNode = locator.getDocument();
        Node aNode = documentNode.getFirstChild().getFirstChild();
        this.ctx.setContextItem((Item)aNode);
        Sequence result = new XQuery("/").execute(this.ctx);
        ResultChecker.dCheck((Sequence)documentNode, result);
    }

    @Test
    public void oneDoubleSlashStepPathExpr() throws Exception {
        NodeCollection<?> locator = this.storeDocument("test.xml", "<a><b/></a>");
        Node documentNode = locator.getDocument();
        this.ctx.setContextItem((Item)documentNode);
        Sequence result = new XQuery(".//b").execute(this.ctx);
        ResultChecker.dCheck((Sequence)documentNode.getFirstChild().getFirstChild(), result);
    }

    @Test
    public void positionAsStep() throws Exception {
        Sequence result = new XQuery("<a><b1/><b2/><b3/></a>/last()").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Int32(1), result);
    }

    @Test
    public void positionAndLastInPredicate() throws Exception {
        Sequence result = new XQuery("<a><b1/><b2/></a>/*[position() = last()]/name()").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Str("b2"), result);
    }

    @Test
    public void pathExprTest() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("(<a><b><c/><c/></b></a>)//node-name(.)").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"a b c c", (Object)buf.toString());
    }

    @Test
    public void pathExprTest2() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("(<a><b><c/><c/></b></a>)//position()").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"1 2 3 4", (Object)buf.toString());
    }

    @Test
    public void pathExprTest3() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("(<a><b><c/><c/></b></a>)//last()").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"4 4 4 4", (Object)buf.toString());
    }

    @Test
    public void pathExprTest4() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("(<a><b><c/><c/></b></a>)//position()[last()]").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"1 2 3 4", (Object)buf.toString());
    }

    @Test
    public void pathExprTest5() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("(<a><b><c/><c>aha</c></b></a>)/b/*/position()").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"1 2", (Object)buf.toString());
    }

    @Test
    public void pathExprTest6() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("(<a><b><c>c1</c><b><c>c2</c></b><c>c3</c></b></a>)//b/c/text()").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"c1c2c3", (Object)buf.toString());
    }

    @Test
    public void pathExprTest9() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := document{<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>}/* return (($doc/d, $doc/c))//position()").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"1 2 3 4 5 6 7 8", (Object)buf.toString());
    }

    @Test
    public void pathExprTest9b() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := (<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>) return (($doc/d, $doc/c))//position()[2]").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"", (Object)buf.toString());
    }

    @Test
    public void pathExprTest9c() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := (<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>) return (($doc/d, $doc/c))//*[last() - 1]").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"<b>b1</b>", (Object)buf.toString());
    }

    @Test
    public void pathExprTest9d() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := (<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>) return (($doc/d, $doc/c))/../*[last() - 1]").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"<c><b>b1</b><b>b2</b></c>", (Object)buf.toString());
    }

    @Test
    public void pathExprTest9e() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := (<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>) return (($doc/d, $doc/c))/..//*[last() - 1]").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"<c><b>b1</b><b>b2</b></c><b>b1</b>", (Object)buf.toString());
    }

    @Test
    public void pathExprTest7() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("(<a><b><c>c1</c><b><c>c2</c></b><c>c3</c></b><b><c>c4</c></b></a>)//c[2]").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"<c>c3</c>", (Object)buf.toString());
    }

    @Test
    public void pathExprTest10() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := document{<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>}/* return (($doc/d, $doc/c, $doc/d))/*").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"<b>b1</b><b>b2</b><b>b3</b>", (Object)buf.toString());
    }

    @Test
    public void pathExprTest11() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := document{<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>}/* return (($doc/d, $doc/c, $doc/d))//position()").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"1 2 3 4 5 6 7 8", (Object)buf.toString());
    }

    @Test
    public void pathExprTest12() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := document{<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>}/* return (($doc/d, $doc/c, $doc/d))/b/text()").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"b1b2b3", (Object)buf.toString());
    }

    @Test
    public void pathExprTestDebug() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("(<a><b><c>c1</c><b><c>c2</c></b><c>c3</c></b><b><c>c4</c></b></a>)/descendant-or-self::node()/c[2]").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"<c>c3</c>", (Object)buf.toString());
    }

    @Test
    public void pathExprTest8() throws Exception {
        PrintStream buf = this.createBuffer();
        new XQuery("let $doc := (<a><c><b>b1</b><b>b2</b></c><d><b>b3</b></d></a>) return (($doc/d, $doc/c))//b").serialize(this.ctx, buf);
        Assert.assertEquals((Object)"<b>b1</b><b>b2</b><b>b3</b>", (Object)buf.toString());
    }

    @Test
    public void elementTest1() throws Exception {
        Sequence res = new XQuery("(<a><b/><c/></a>)/element(b)").execute(this.ctx);
        Node exp = this.ctx.getNodeFactory().element(new QNm("b"));
        ResultChecker.check((Sequence)exp, res, false);
    }

    @Test
    public void elementTest2() throws Exception {
        Sequence res = new XQuery("(<a><b/><c/></a>)/element(b, xs:untyped)").execute(this.ctx);
        Node exp = this.ctx.getNodeFactory().element(new QNm("b"));
        ResultChecker.check((Sequence)exp, res, false);
    }

    @Test
    public void elementTest3() throws Exception {
        Sequence res = new XQuery("(<a><b/><c/></a>)/element(b, xs:double)").execute(this.ctx);
        ResultChecker.check(null, res, false);
    }

    @Test
    public void elementTest4() throws Exception {
        Sequence res = new XQuery("(<a><b/><c/></a>)/element(*, xs:untyped)").execute(this.ctx);
        ItemSequence exp = new ItemSequence(new Item[]{this.ctx.getNodeFactory().element(new QNm("b")), this.ctx.getNodeFactory().element(new QNm("c"))});
        ResultChecker.check((Sequence)exp, res, false);
    }

    @Test
    public void attributeTest1() throws Exception {
        Sequence res = new XQuery("(<a b='' c=''/>)/attribute(b)").execute(this.ctx);
        Node exp = this.ctx.getNodeFactory().attribute(new QNm("b"), (Atomic)new Una(""));
        ResultChecker.check((Sequence)exp, res, false);
    }

    @Test
    public void attributeTest2() throws Exception {
        Sequence res = new XQuery("(<a b='' c=''/>)/attribute(b, xs:untypedAtomic)").execute(this.ctx);
        Node exp = this.ctx.getNodeFactory().attribute(new QNm("b"), (Atomic)new Una(""));
        ResultChecker.check((Sequence)exp, res, false);
    }

    @Test
    public void attributeTest3() throws Exception {
        Sequence res = new XQuery("(<a b='' c=''/>)/attribute(b, xs:double)").execute(this.ctx);
        ResultChecker.check(null, res, false);
    }

    @Test
    public void attributeTest4() throws Exception {
        Sequence res = new XQuery("(<a b='' c=''/>)/attribute(*, xs:untypedAtomic)").execute(this.ctx);
        ItemSequence exp = new ItemSequence(new Item[]{this.ctx.getNodeFactory().attribute(new QNm("b"), (Atomic)new Una("")), this.ctx.getNodeFactory().attribute(new QNm("c"), (Atomic)new Una(""))});
        ResultChecker.check((Sequence)exp, res, false);
    }

    @Test
    public void schemaElementTest() throws Exception {
        try {
            new XQuery("(<a><b/></a>)/schema-element(b)");
            Assert.fail((String)"missing imported schema not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_UNDEFINED_REFERENCE, (Object)e.getCode());
        }
    }

    @Test
    public void schemaAttributeTest() throws Exception {
        try {
            new XQuery("(<a b=''/>)/schema-attribute(b)");
            Assert.fail((String)"missing imported schema not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_UNDEFINED_REFERENCE, (Object)e.getCode());
        }
    }

    @Test
    public void mixedOutputTest() throws Exception {
        try {
            Sequence s = new XQuery("(<a>1</a>,<b>2</b>)/(if(position() eq 1) then . else data(.))").execute(this.ctx);
            try (Iter it = s.iterate();){
                while (it.next() != null) {
                }
            }
            Assert.fail((String)"mixed output sequence not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_PATH_STEP_RETURNED_NODE_AND_NON_NODE_VALUES, (Object)e.getCode());
        }
    }

    @Test
    public void mixedOutputTest2() throws Exception {
        try {
            Sequence s = new XQuery("declare variable $myVar := <e>text</e>; $myVar/text()/(<e/>, (), 1, <e/>)").execute(this.ctx);
            try (Iter it = s.iterate();){
                while (it.next() != null) {
                }
            }
            Assert.fail((String)"mixed output sequence not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_PATH_STEP_RETURNED_NODE_AND_NON_NODE_VALUES, (Object)e.getCode());
        }
    }
}

