/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.ResultChecker;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.XQueryBaseTest;
import org.brackit.xquery.atomic.Dbl;
import org.brackit.xquery.atomic.Int;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.junit.Assert;
import org.junit.Test;

public class PrologDeclarationTest
extends XQueryBaseTest {
    @Test
    public void declareFunction() throws Exception {
        Sequence res = new XQuery("declare function local:addOne($a as item()) { $a + 1 }; local:addOne(1)").execute(this.ctx);
        ResultChecker.check((Sequence)new Int32(2), res);
    }

    @Test
    public void declareRecursiveFunction() throws Exception {
        Sequence res = new XQuery("declare function local:countdown($a as xs:integer) { if ($a > 0) then ($a, local:countdown($a - 1)) else $a }; local:countdown(3)").execute(this.ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Int32(3), new Int32(2), new Int32(1), new Int32(0)}), res);
    }

    @Test
    public void declareIndirectRecursiveFunctions() throws Exception {
        Sequence res = new XQuery("declare function local:a($a as xs:integer) { if ($a > 0) then ('a', $a, local:b($a - 1)) else ('a', $a) }; declare function local:b($b as xs:integer) { if ($b > 0) then ('b', $b, local:a($b - 1)) else ('b', $b) }; local:a(3)").execute(this.ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Str("a"), new Int32(3), new Str("b"), new Int32(2), new Str("a"), new Int32(1), new Str("b"), new Int32(0)}), res);
    }

    @Test
    public void declareFunctionInIllegalNS() throws Exception {
        try {
            new XQuery("declare function xs:addOne($a as item()) { $a + 1 }; 1");
            Assert.fail((String)"Illegal declaration not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_FUNCTION_DECL_IN_ILLEGAL_NAMESPACE, (Object)e.getCode());
        }
    }

    @Test
    public void variableDeclarationWithAccess() throws Exception {
        Sequence result = new XQuery("declare variable $x := 1; for $a in (1,2,3) return $a + $x").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(2), new Int32(3), new Int32(4)}), result);
    }

    @Test
    public void twoVariableDeclarationsWithAccess() throws Exception {
        Sequence result = new XQuery("declare variable $x := 1; declare variable $y := $x + 2; for $a in (1,2,3) return $a + $x + $y").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(5), new Int32(6), new Int32(7)}), result);
    }

    @Test
    public void externalVariableDeclarationWithAccess() throws Exception {
        this.ctx.bind(new QNm("x"), (Sequence)Int32.ZERO_TWO_TWENTY[2]);
        XQuery query = new XQuery("declare variable $x external := 1; for $a in (1,2,3) return $a + $x");
        Sequence result = query.execute(this.ctx);
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(3), new Int32(4), new Int32(5)}), result);
    }

    @Test
    public void declareVariableWithCylicInitializer() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        try {
            new XQuery("declare variable $a := $a + 1; $a");
            Assert.fail((String)"Illegal cycle in initializer not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_VARIABLE_DEPENDENCY, (Object)e.getCode());
        }
    }

    @Test
    public void declare2VariablesWithCylicInitializer() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        try {
            new XQuery("declare variable $a := $b + 1; declare variable $b := $a + 1; $a + $b");
            Assert.fail((String)"Illegal cycle in initializer not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_VARIABLE_DEPENDENCY, (Object)e.getCode());
        }
    }

    @Test
    public void declare2VariablesAndFunctionWithCylicInitializer() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        try {
            new XQuery("declare variable $a := local:foo(); declare variable $b := $a + 1; declare function local:foo() { $b + 1 }; $a + $b");
            Assert.fail((String)"Illegal cycle in initializer not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_VARIABLE_DEPENDENCY, (Object)e.getCode());
        }
    }

    @Test
    public void declareNS() throws Exception {
        Sequence result = new XQuery("declare namespace foo=\"http://brackit.org/foo\"; (<a/>)/foo:a").execute(this.ctx);
        ResultChecker.dCheck(null, result);
    }

    @Test
    public void declareDefaultElementNS() throws Exception {
        Sequence result = new XQuery("declare default element namespace \"http://brackit.org/foo\"; <a/>").execute(this.ctx);
        ResultChecker.dCheck((Sequence)this.ctx.getNodeFactory().element(new QNm("http://brackit.org/foo", "a")), result, false);
    }

    @Test
    public void declareDefaultFunctionNS() throws Exception {
        Sequence result = new XQuery("declare default function namespace \"http://brackit.org/foo\"; declare function inc($i as xs:integer) { $i + 1 }; inc(1)").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Int(2.0), result);
    }

    @Test
    public void declareOption() throws Exception {
        Sequence result = new XQuery("declare option foo \"bar\"; 1").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Int(1.0), result);
    }

    @Test
    public void declareContextItemExternal() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        Sequence result = new XQuery("declare context item as item() external; .").execute(ctx);
        ResultChecker.dCheck((Sequence)new Int(1.0), result);
    }

    @Test
    public void declareContextItemExternalWrongType() throws Exception {
        try {
            QueryContext ctx = this.createContext();
            ctx.setContextItem((Item)new Int(1.0));
            new XQuery("declare context item as node() external; .").execute(ctx);
            Assert.fail((String)"Illegal context item access accepted");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, (Object)e.getCode());
        }
    }

    @Test
    public void declareContextItemIgnoreExternal() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        Sequence result = new XQuery("declare context item as xs:double := xs:double(1); .").execute(ctx);
        ResultChecker.dCheck((Sequence)new Dbl(1.0), result);
    }

    @Test
    public void declareContextItemContextDependentDefaultValue() throws Exception {
        try {
            new XQuery("declare context item as item() := 1 + .; .");
            Assert.fail((String)"Illegal context item declaration accepted");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_CONTEXT_ITEM_INITIALIZER, (Object)e.getCode());
        }
    }

    @Test
    public void declareContextItemContextDependentDefaultValue2() throws Exception {
        try {
            new XQuery("declare context item as item() := 1 + a; .");
            Assert.fail((String)"Illegal context item declaration accepted");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_CONTEXT_ITEM_INITIALIZER, (Object)e.getCode());
        }
    }

    @Test
    public void declareContextItemContextDefaultValue() throws Exception {
        new XQuery("declare context item as item() := 1 + (<a/>)//a/(.); .");
    }
}

