/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.BrackitQueryContext;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.ResultChecker;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.expr.SequenceExpr;
import org.brackit.xquery.operator.TupleImpl;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.junit.Test;

public class SequenceExprTest {
    QueryContext ctx = new BrackitQueryContext(null, null);

    @Test
    public void simpleSequence() throws Exception {
        SequenceExpr expr = new SequenceExpr(new Expr[]{new Int32(1), new Int32(2), new Int32(3)});
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(1), new Int32(2), new Int32(3)}), expr.evaluate(this.ctx, (Tuple)new TupleImpl()));
    }

    @Test
    public void emptySequence() throws Exception {
        SequenceExpr expr = new SequenceExpr(new Expr[0]);
        ResultChecker.dCheck(null, expr.evaluate(this.ctx, (Tuple)new TupleImpl()));
    }

    @Test
    public void simpleAndEmptySequence() throws Exception {
        SequenceExpr expr = new SequenceExpr(new Expr[]{new Int32(1), new SequenceExpr(new Expr[0]), new Int32(2), new Int32(3)});
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(1), new Int32(2), new Int32(3)}), expr.evaluate(this.ctx, (Tuple)new TupleImpl()));
    }

    @Test
    public void nestedSequences() throws Exception {
        SequenceExpr expr = new SequenceExpr(new Expr[]{new Int32(1), new SequenceExpr(new Expr[]{new Int32(2), new Int32(3)}), new Int32(4), new SequenceExpr(new Expr[]{new Int32(5), new Int32(6), new Int32(7)})});
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(1), new Int32(2), new Int32(3), new Int32(4), new Int32(5), new Int32(6), new Int32(7)}), expr.evaluate(this.ctx, (Tuple)new TupleImpl()));
    }
}

