/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.operator;

import java.io.PrintStream;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.xdm.Sequence;

public class TuplePrintOp
implements Cursor {
    private final Cursor in;
    private final PrintStream out;
    private int maxSize = 20;
    private int count;

    public TuplePrintOp(Cursor in, PrintStream out) {
        this.in = in;
        this.out = out;
    }

    public void close(QueryContext ctx) {
        this.in.close(ctx);
        this.out.println("---");
        this.out.print(this.count);
        this.out.println(" results");
    }

    public Tuple next(QueryContext ctx) throws QueryException {
        Tuple next = this.in.next(ctx);
        if (next != null) {
            ++this.count;
            int size = next.getSize();
            this.out.print("|");
            for (int i = 0; i < size; ++i) {
                this.out.print(' ');
                Sequence sequence = next.get(i);
                String s = this.asString(ctx, sequence);
                s = this.shrinkOrPad(s);
                this.out.print(s);
                this.out.print(" |");
            }
            this.out.print('\n');
        }
        return next;
    }

    public String asString(QueryContext ctx, Sequence sequence) {
        return sequence.toString();
    }

    private String shrinkOrPad(String s) {
        int length = s.length();
        if (length == this.maxSize) {
            return s;
        }
        if (length > this.maxSize) {
            return s.substring(0, this.maxSize);
        }
        int toAdd = this.maxSize - length;
        char[] result = new char[this.maxSize];
        int i = 0;
        while (i < toAdd / 2) {
            result[i++] = 32;
        }
        System.arraycopy(s.toCharArray(), 0, result, i, length);
        int j = i + length;
        while (i++ < toAdd) {
            result[j++] = 32;
        }
        return new String(result);
    }

    public void open(QueryContext ctx) throws QueryException {
        this.in.open(ctx);
        this.count = 0;
    }
}

