/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.DTD;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.node.NodeCollection;
import io.brackit.query.jdm.node.NodeStore;
import io.brackit.query.node.SimpleNodeStore;
import io.brackit.query.node.parser.DocumentParser;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.util.serialize.SubtreePrinter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Random;
import org.junit.Before;
import org.junit.Ignore;

@Ignore
public class XQueryBaseTest {
    public static final Path RESOURCES = Paths.get("src", "test", "resources");
    protected QueryContext ctx;
    protected Random rand;
    protected NodeStore store;

    protected void print(Sequence s) throws QueryException {
        if (s == null) {
            return;
        }
        try (Iter it = s.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                System.out.print(item);
                System.out.print(" ");
                if (!(item instanceof Node) || ((Node)item).getKind() == Kind.ATTRIBUTE) continue;
                new SubtreePrinter(System.out, false, false).print((Node)item);
            }
        }
        System.out.println();
    }

    protected Query xquery(String query) throws QueryException {
        return new Query(query);
    }

    protected PrintStream createBuffer() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        return new PrintStream(out){
            final OutputStream baos;
            {
                this.baos = this.out;
            }

            public String toString() {
                return this.baos.toString();
            }
        };
    }

    protected String readFile(Path dirname, String filename) throws IOException {
        return Files.readString(dirname.resolve(filename));
    }

    protected NodeCollection<?> storeFile(String name, Path document) throws Exception {
        DocumentParser parser = new DocumentParser(document.toFile());
        parser.setRetainWhitespace(true);
        return this.storeDocument(name, (NodeSubtreeParser)parser);
    }

    protected NodeCollection<?> storeDocument(String name, String document) {
        return this.storeDocument(name, (NodeSubtreeParser)new DocumentParser(document));
    }

    protected NodeCollection<?> storeDocument(String name, NodeSubtreeParser parser) {
        NodeCollection collection = this.store.create(name, parser);
        return collection;
    }

    protected NodeStore createStore() throws Exception {
        return new SimpleNodeStore();
    }

    protected QueryContext createContext() throws Exception {
        return new BrackitQueryContext(this.store){

            public DTD getImplicitTimezone() {
                return new DTD(false, 0, 2, 0, 0);
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        this.store = this.createStore();
        this.ctx = this.createContext();
        this.rand = new Random(12345678L);
    }
}

