/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer;

import io.brackit.query.Query;
import io.brackit.query.ResultChecker;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.atomic.Int32;
import io.brackit.query.compiler.optimizer.DefaultOptimizer;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.sequence.ItemSequence;
import java.nio.file.Files;
import java.nio.file.Path;
import org.junit.Before;
import org.junit.Test;

public class JoinTest
extends XQueryBaseTest {
    private static final Path JOIN = RESOURCES.resolve("join");

    @Test
    public void simpleNestedFor() {
        Sequence res = new Query("for $a in (1,2,3) for $b in (2,3,4) where $a = $b return $a").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(2, 3), res);
    }

    @Test
    public void nestedForWithLetsInOuterFor() {
        Sequence res = new Query("for $w in (2,4) let $x := (2 to $w) for $a in (1,2,3) for $b in $x let $z := $a + $x[0] where $a = $b return $a").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(2, 2, 3), res);
    }

    @Test
    public void nestedForWithLets() {
        Sequence res = new Query("let $x := (2,3,4) for $a in (1,2,3) let $y := 'foo'for $b in $x let $z := $a + $x[0] where $a = $b return $a").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(2, 3), res);
    }

    @Test
    public void letNestedFor() {
        Sequence res = new Query("for $a in (1,2,3) let $c := for $b in (2,3,4)           where $a = $b           return $a return $c").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(2, 3), res);
    }

    @Test
    public void letNestedForWithLets() {
        Sequence res = new Query("for $w in (2,4) let $x := (2 to $w) for $a in (1,2,3) let $y := 'foo'let $c := for $b in $x           let $z := $a + $x[0]           where $a = $b           return $a return $c").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(2, 2, 3), res);
    }

    @Test
    public void fakeJoin() {
        Sequence res = new Query("for $a in (1,2,3) for $b in (2,3,4) let $x := for $c in 1 \t\t\twhere $a = $b \t\t\treturn $c return $x").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(1, 1), res);
    }

    @Test
    public void simpleForFor() throws Exception {
        String query = Files.readString(JOIN.resolve("simpleForFor.xq"));
        Query xq = new Query(query);
        Sequence res = xq.execute(this.createContext());
        ResultChecker.dCheck(this.intSequence(2, 3, 5), res);
    }

    @Test
    public void forNestedFor() throws Exception {
        String query = Files.readString(JOIN.resolve("forNestedFor.xq"));
        Query xq = new Query(query);
        Sequence res = xq.execute(this.createContext());
        ResultChecker.dCheck(this.intSequence(2, 3, 5), res);
    }

    @Test
    public void forNestedFor2JoinPredicates() throws Exception {
        String query = Files.readString(JOIN.resolve("forNestedFor2JoinPredicates.xq"));
        Query xq = new Query(query);
        Sequence res = xq.execute(this.createContext());
        ResultChecker.dCheck(this.intSequence(3, 4, 6), res);
    }

    @Test
    public void forNestedForWithOutsideRef() throws Exception {
        String query = Files.readString(JOIN.resolve("forNestedForWithOutsideRef.xq"));
        Query xq = new Query(query);
        Sequence res = xq.execute(this.createContext());
        ResultChecker.dCheck(this.intSequence(3, 3, 4, 4, 6, 6), res);
    }

    private Sequence intSequence(int ... v) {
        Int32[] s = new Int32[v.length];
        for (int i = 0; i < v.length; ++i) {
            s[i] = new Int32(v[i]);
        }
        return new ItemSequence((Item[])s);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        DefaultOptimizer.UNNEST = true;
        DefaultOptimizer.JOIN_DETECTION = true;
    }
}

