/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer;

import io.brackit.query.Query;
import io.brackit.query.ResultChecker;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.optimizer.DefaultOptimizer;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.sequence.ItemSequence;
import org.junit.Before;
import org.junit.Test;

public class LetBindLiftTest
extends XQueryBaseTest {
    @Test
    public void forLetWhereConditional() {
        Sequence res = new Query("for $a in (1,2,3) let $b := 5 let $c := \tfor $d in (2 to 1)\tlet $e := \t\tfor $f in (4,5,6) \t\treturn $f \twhere exactly-one($d) \treturn $d return 'no'").execute(this.ctx);
        Str no = new Str("no");
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{no, no, no}), res);
    }

    @Test
    public void orderByBatched() {
        Sequence res = new Query("for $a in (1,2,3) let $c := \tfor $d in (6,5,4) \tfor $e in (7,8,9) \torder by $d ascending, $e descending \treturn ($d,$e) return ($a, $c)").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(1, 4, 9, 4, 8, 4, 7, 5, 9, 5, 8, 5, 7, 6, 9, 6, 8, 6, 7, 2, 4, 9, 4, 8, 4, 7, 5, 9, 5, 8, 5, 7, 6, 9, 6, 8, 6, 7, 3, 4, 9, 4, 8, 4, 7, 5, 9, 5, 8, 5, 7, 6, 9, 6, 8, 6, 7), res);
    }

    @Test
    public void orderBy() {
        Sequence res = new Query("for $a in (7,8,9) let $c := \tfor $d in (3,2,1) \tfor $e in (4,5,6) \torder by $d ascending, $e descending \treturn ($d,$e) return ($a, $c)").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(7, 1, 6, 1, 5, 1, 4, 2, 6, 2, 5, 2, 4, 3, 6, 3, 5, 3, 4, 8, 1, 6, 1, 5, 1, 4, 2, 6, 2, 5, 2, 4, 3, 6, 3, 5, 3, 4, 9, 1, 6, 1, 5, 1, 4, 2, 6, 2, 5, 2, 4, 3, 6, 3, 5, 3, 4), res);
    }

    @Test
    public void orderBy2() {
        Sequence res = new Query("\tfor $d in (3,2,1) \tfor $e in (4,5,6) \torder by $d ascending, $e descending \treturn ($d,$e)").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(1, 6, 1, 5, 1, 4, 2, 6, 2, 5, 2, 4, 3, 6, 3, 5, 3, 4), res);
    }

    @Test
    public void doubledNestedWithOrderBy() {
        Sequence res = new Query("for $z in 1 let $x := for $a in (1 to 5) let $b := \tfor $c in (2,4) \tlet $f := if ($c) then (2,4) else () \torder by $c \tlet $d := \t\tfor $e in $f \t\tlet $g := 'ignore' \t\twhere $c = $a \t\treturn $e \treturn $d return ($a,$b) return $x").execute(this.ctx);
        ResultChecker.dCheck(this.intSequence(1, 2, 2, 4, 3, 4, 2, 4, 5), res);
    }

    private Sequence intSequence(int ... v) {
        Int32[] s = new Int32[v.length];
        for (int i = 0; i < v.length; ++i) {
            s[i] = new Int32(v[i]);
        }
        return new ItemSequence((Item[])s);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        DefaultOptimizer.UNNEST = true;
    }
}

