/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.ResultChecker;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Int;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.sequence.ItemSequence;
import org.junit.Assert;
import org.junit.Test;

public class PrologDeclarationTest
extends XQueryBaseTest {
    @Test
    public void declareFunction() {
        Sequence res = new Query("declare function local:addOne($a as item()) { $a + 1 }; local:addOne(1)").execute(this.ctx);
        ResultChecker.check((Sequence)new Int32(2), res);
    }

    @Test
    public void declareRecursiveFunction() {
        Sequence res = new Query("declare function local:countdown($a as xs:integer) { if ($a > 0) then ($a, local:countdown($a - 1)) else $a }; local:countdown(3)").execute(this.ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Int32(3), new Int32(2), new Int32(1), new Int32(0)}), res);
    }

    @Test
    public void declareIndirectRecursiveFunctions() {
        Sequence res = new Query("declare function local:a($a as xs:integer) { if ($a > 0) then ('a', $a, local:b($a - 1)) else ('a', $a) }; declare function local:b($b as xs:integer) { if ($b > 0) then ('b', $b, local:a($b - 1)) else ('b', $b) }; local:a(3)").execute(this.ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Str("a"), new Int32(3), new Str("b"), new Int32(2), new Str("a"), new Int32(1), new Str("b"), new Int32(0)}), res);
    }

    @Test
    public void declareFunctionInIllegalNS() {
        try {
            new Query("declare function xs:addOne($a as item()) { $a + 1 }; 1");
            Assert.fail((String)"Illegal declaration not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_FUNCTION_DECL_IN_ILLEGAL_NAMESPACE, (Object)e.getCode());
        }
    }

    @Test
    public void variableDeclarationWithAccess() {
        Sequence result = new Query("declare variable $x := 1; for $a in (1,2,3) return $a + $x").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(2), new Int32(3), new Int32(4)}), result);
    }

    @Test
    public void twoVariableDeclarationsWithAccess() {
        Sequence result = new Query("declare variable $x := 1; declare variable $y := $x + 2; for $a in (1,2,3) return $a + $x + $y").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(5), new Int32(6), new Int32(7)}), result);
    }

    @Test
    public void externalVariableDeclarationWithAccess() {
        this.ctx.bind(new QNm("x"), (Sequence)Int32.ZERO_TO_TWENTY[2]);
        Query query = new Query("declare variable $x external := 1; for $a in (1,2,3) return $a + $x");
        Sequence result = query.execute(this.ctx);
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(3), new Int32(4), new Int32(5)}), result);
    }

    @Test
    public void declareVariableWithCylicInitializer() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        try {
            new Query("declare variable $a := $a + 1; $a");
            Assert.fail((String)"Illegal cycle in initializer not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_VARIABLE_DEPENDENCY, (Object)e.getCode());
        }
    }

    @Test
    public void declare2VariablesWithCylicInitializer() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        try {
            new Query("declare variable $a := $b + 1; declare variable $b := $a + 1; $a + $b");
            Assert.fail((String)"Illegal cycle in initializer not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_VARIABLE_DEPENDENCY, (Object)e.getCode());
        }
    }

    @Test
    public void declare2VariablesAndFunctionWithCylicInitializer() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        try {
            new Query("declare variable $a := local:foo(); declare variable $b := $a + 1; declare function local:foo() { $b + 1 }; $a + $b");
            Assert.fail((String)"Illegal cycle in initializer not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_VARIABLE_DEPENDENCY, (Object)e.getCode());
        }
    }

    @Test
    public void declareNS() {
        Sequence result = new Query("declare namespace foo=\"http://brackit.org/foo\"; (<a/>)/foo:a").execute(this.ctx);
        ResultChecker.dCheck(null, result);
    }

    @Test
    public void declareDefaultElementNS() {
        Sequence result = new Query("declare default element namespace \"http://brackit.org/foo\"; <a/>").execute(this.ctx);
        ResultChecker.dCheck((Sequence)this.ctx.getNodeFactory().element(new QNm("http://brackit.org/foo", "a")), result, false);
    }

    @Test
    public void declareDefaultFunctionNS() {
        Sequence result = new Query("declare default function namespace \"http://brackit.org/foo\"; declare function inc($i as xs:integer) { $i + 1 }; inc(1)").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Int(2.0), result);
    }

    @Test
    public void declareOption() {
        Sequence result = new Query("declare option foo \"bar\"; 1").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Int(1.0), result);
    }

    @Test
    public void declareContextItemExternal() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        Sequence result = new Query("declare context item as item() external; $$").execute(ctx);
        ResultChecker.dCheck((Sequence)new Int(1.0), result);
    }

    @Test
    public void declareContextItemExternalWrongType() throws Exception {
        try {
            QueryContext ctx = this.createContext();
            ctx.setContextItem((Item)new Int(1.0));
            new Query("declare context item as node() external; $$").execute(ctx);
            Assert.fail((String)"Illegal context item access accepted");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, (Object)e.getCode());
        }
    }

    @Test
    public void declareContextItemIgnoreExternal() throws Exception {
        QueryContext ctx = this.createContext();
        ctx.setContextItem((Item)new Int(1.0));
        Sequence result = new Query("declare context item as xs:double := xs:double(1); $$").execute(ctx);
        ResultChecker.dCheck((Sequence)new Dbl(1.0), result);
    }

    @Test
    public void declareContextItemContextDependentDefaultValue() {
        try {
            new Query("declare context item as item() := 1 + $$; $$");
            Assert.fail((String)"Illegal context item declaration accepted");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_CONTEXT_ITEM_INITIALIZER, (Object)e.getCode());
        }
    }

    @Test
    public void declareContextItemContextDependentDefaultValue2() {
        try {
            new Query("declare context item as item() := 1 + a; $$");
            Assert.fail((String)"Illegal context item declaration accepted");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_CIRCULAR_CONTEXT_ITEM_INITIALIZER, (Object)e.getCode());
        }
    }

    @Test
    public void declareContextItemContextDefaultValue() {
        new Query("declare context item as item() := 1 + (<a/>)//a/($$); $$");
    }
}

