/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.QueryContext;
import io.brackit.query.ResultChecker;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Int32;
import io.brackit.query.expr.SequenceExpr;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.operator.TupleImpl;
import io.brackit.query.sequence.ItemSequence;
import org.junit.Test;

public class SequenceExprTest {
    QueryContext ctx = new BrackitQueryContext(null, null);

    @Test
    public void simpleSequence() {
        SequenceExpr expr = new SequenceExpr(new Expr[]{new Int32(1), new Int32(2), new Int32(3)});
        Sequence evaluatedSequence = expr.evaluate(this.ctx, (Tuple)new TupleImpl());
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(1), new Int32(2), new Int32(3)}), evaluatedSequence);
    }

    @Test
    public void emptySequence() {
        SequenceExpr expr = new SequenceExpr(new Expr[0]);
        ResultChecker.dCheck(null, expr.evaluate(this.ctx, (Tuple)new TupleImpl()));
    }

    @Test
    public void simpleAndEmptySequence() throws Exception {
        SequenceExpr expr = new SequenceExpr(new Expr[]{new Int32(1), new SequenceExpr(new Expr[0]), new Int32(2), new Int32(3)});
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(1), new Int32(2), new Int32(3)}), expr.evaluate(this.ctx, (Tuple)new TupleImpl()));
    }

    @Test
    public void nestedSequences() {
        SequenceExpr expr = new SequenceExpr(new Expr[]{new Int32(1), new SequenceExpr(new Expr[]{new Int32(2), new Int32(3)}), new Int32(4), new SequenceExpr(new Expr[]{new Int32(5), new Int32(6), new Int32(7)})});
        ResultChecker.dCheck((Sequence)new ItemSequence(new Item[]{new Int32(1), new Int32(2), new Int32(3), new Int32(4), new Int32(5), new Int32(6), new Int32(7)}), expr.evaluate(this.ctx, (Tuple)new TupleImpl()));
    }
}

