/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node;

import io.brackit.query.QueryException;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.expr.Accessor;
import io.brackit.query.jdm.Axis;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.node.NodeCollection;
import io.brackit.query.jdm.node.NodeStore;
import io.brackit.query.node.stream.StreamUtil;
import io.brackit.query.node.stream.filter.Filter;
import io.brackit.query.node.stream.filter.FilteredStream;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Assert;
import org.junit.Test;

public abstract class AxisTest
extends XQueryBaseTest {
    private static final Comparator<Node<?>> COMPARATOR = Node::cmp;
    private NodeCollection<?> collection;

    @Test
    public void testCmp() {
        Stream subtree = this.collection.getDocument().getSubtree();
        List nodes = StreamUtil.asList((Stream)subtree);
        for (int i = 0; i < nodes.size(); ++i) {
            Node a = (Node)nodes.get(i);
            for (int j = 0; j < nodes.size(); ++j) {
                Node b = (Node)nodes.get(j);
                try {
                    if (i < j) {
                        Assert.assertTrue((String)"a < b", (a.cmp(b) < 0 ? 1 : 0) != 0);
                        continue;
                    }
                    if (i == j) {
                        Assert.assertEquals((String)"a == b", (int)0, (int)a.cmp(b));
                        continue;
                    }
                    Assert.assertTrue((String)"a > b", (a.cmp(b) > 0 ? 1 : 0) != 0);
                    continue;
                }
                catch (AssertionError e) {
                    System.err.println(a);
                    System.err.println(b);
                    System.err.println(a.cmp(b));
                    throw e;
                }
            }
        }
    }

    @Test
    public void testRootElementChildren() {
        Node node = this.collection.getDocument().getFirstChild();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.CHILD));
        this.checkOutput(Accessor.CHILD.performStep(node), expected);
    }

    @Test
    public void testNonRootElementChildren() {
        Node node = this.collection.getDocument().getFirstChild().getFirstChild();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.CHILD));
        this.checkOutput(Accessor.CHILD.performStep(node), expected);
    }

    @Test
    public void testRootFollowing() {
        Node node = this.collection.getDocument().getFirstChild();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.FOLLOWING));
        this.checkOutput(Accessor.FOLLOWING.performStep(node), expected);
    }

    @Test
    public void testNonRootFollowing() {
        Node node = this.collection.getDocument().getFirstChild().getFirstChild().getFirstChild().getNextSibling();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.FOLLOWING));
        this.checkOutput(Accessor.FOLLOWING.performStep(node), expected);
    }

    @Test
    public void testRootPreceding() {
        Node node = this.collection.getDocument().getFirstChild();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.PRECEDING));
        this.checkOutput(Accessor.PRECEDING.performStep(node), expected);
    }

    @Test
    public void testNonRootPreceding() {
        Node node = this.collection.getDocument().getFirstChild().getFirstChild().getFirstChild().getNextSibling();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.PRECEDING));
        this.checkOutput(Accessor.PRECEDING.performStep(node), expected);
    }

    @Test
    public void testRootPrecedingSibling() {
        Node node = this.collection.getDocument().getFirstChild();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.PRECEDING_SIBLING));
        this.checkOutput(Accessor.PRECEDING_SIBLING.performStep(node), expected);
    }

    @Test
    public void testNonRootPrecedingSibling() {
        Node node = this.collection.getDocument().getFirstChild().getFirstChild().getFirstChild().getNextSibling();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.PRECEDING_SIBLING));
        this.checkOutput(Accessor.PRECEDING_SIBLING.performStep(node), expected);
    }

    @Test
    public void testRootFollowingSibling() {
        Node node = this.collection.getDocument().getFirstChild();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.FOLLOWING_SIBLING));
        this.checkOutput(Accessor.FOLLOWING_SIBLING.performStep(node), expected);
    }

    @Test
    public void testNonRootFollowingSibling() {
        Node node = this.collection.getDocument().getFirstChild().getFirstChild().getFirstChild().getNextSibling();
        Set<Node<?>> expected = this.buildExpectedSet(this.collection.getDocument().getSubtree(), new AxisFilter(node, Axis.FOLLOWING_SIBLING));
        this.checkOutput(Accessor.FOLLOWING_SIBLING.performStep(node), expected);
    }

    protected Set<Node<?>> buildExpectedSet(Stream<? extends Node<?>> original, Filter<Node<?>> filter) throws DocumentException {
        Node next;
        TreeSet expected = new TreeSet(COMPARATOR);
        FilteredStream stream = original;
        if (filter != null) {
            stream = new FilteredStream(original, filter);
        }
        while ((next = (Node)stream.next()) != null) {
            expected.add(next);
        }
        stream.close();
        return expected;
    }

    protected void checkOutput(Stream<? extends Node<?>> nodes, Set<Node<?>> expected) {
        Node node;
        TreeSet delivered = new TreeSet(COMPARATOR);
        while ((node = (Node)nodes.next()) != null) {
            Assert.assertTrue((String)"Node not delivered yet.", (boolean)delivered.add(node));
        }
        nodes.close();
        Assert.assertEquals((String)"Expected number of nodes delivered", (int)expected.size(), (int)delivered.size());
        for (Node node2 : delivered) {
            if (expected.contains(node2)) continue;
            return;
        }
        Assert.assertTrue((String)"Expected nodes delivered", (boolean)expected.containsAll(delivered));
    }

    @Override
    protected abstract NodeStore createStore() throws Exception;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.collection = this.storeFile("text.xml", RESOURCES.resolve("docs").resolve("orga.xml"));
    }

    private static class AxisFilter
    implements Filter<Node<?>> {
        private final Node<?> node;
        private final Axis axis;

        public AxisFilter(Node<?> node, Axis axis) {
            this.node = node;
            this.axis = axis;
        }

        public boolean filter(Node<?> element) throws DocumentException {
            try {
                boolean check = !this.axis.check(element, this.node);
                return check;
            }
            catch (QueryException e) {
                throw new DocumentException((Throwable)e);
            }
        }
    }
}

