/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.examples;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.jdm.node.NodeStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Random;

public class LoadAndQuery {
    public static void main(String[] args) {
        try {
            LoadAndQuery.loadDocumentAndQuery();
            System.out.println();
            LoadAndQuery.loadCollectionAndQuery();
        }
        catch (IOException e) {
            System.err.print("I/O error: ");
            System.err.println(e.getMessage());
        }
        catch (QueryException e) {
            System.err.print("XQuery error ");
            System.err.print(e.getCode());
            System.err.print(": ");
            System.err.println(e.getMessage());
        }
    }

    private static void loadDocumentAndQuery() throws QueryException, IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File doc = LoadAndQuery.generateSampleDoc(tmpDir);
        doc.deleteOnExit();
        BrackitQueryContext ctx = new BrackitQueryContext();
        NodeStore store = ctx.getNodeStore();
        System.out.println("Loading document:");
        String xq1 = String.format("bit:load('mydoc.xml', '%s')", doc);
        System.out.println(xq1);
        new Query(xq1).evaluate(ctx);
        BrackitQueryContext ctx2 = new BrackitQueryContext(store);
        System.out.println();
        System.out.println("Query loaded document:");
        String xq2 = "doc('mydoc.xml')/log/@severity/string()";
        System.out.println(xq2);
        new Query(xq2).serialize((QueryContext)ctx2, System.out);
        System.out.println();
    }

    private static void loadCollectionAndQuery() throws QueryException, IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(String.valueOf(tmpDir) + File.separator + "docs" + System.currentTimeMillis());
        if (!dir.mkdir()) {
            throw new IOException("Directory " + String.valueOf(dir) + " already exists");
        }
        dir.deleteOnExit();
        for (int i = 0; i < 10; ++i) {
            LoadAndQuery.generateSampleDoc(dir);
        }
        BrackitQueryContext ctx = new BrackitQueryContext();
        NodeStore store = ctx.getNodeStore();
        System.out.println("Load collection from files:");
        String xq1 = String.format("bit:load('mydocs.col', io:ls('%s', '\\.xml$'))", dir);
        System.out.println(xq1);
        new Query(xq1).evaluate(ctx);
        BrackitQueryContext ctx2 = new BrackitQueryContext(store);
        System.out.println();
        System.out.println("Query loaded collection:");
        String xq2 = "for $log in collection('mydocs.col')/log\nwhere $log/@severity='critical'\nreturn\n<message>\n  <from>{$log/src/text()}</from>\n  <body>{$log/msg/text()}</body>\n</message>";
        System.out.println(xq2);
        new Query(xq2).prettyPrint().serialize((QueryContext)ctx2, System.out);
        System.out.println();
    }

    private static File generateSampleDoc(File dir) throws IOException {
        File file = File.createTempFile("sample", ".xml", dir);
        file.deleteOnExit();
        PrintStream out = new PrintStream(new FileOutputStream(file));
        Random rnd = new Random();
        long now = System.currentTimeMillis();
        int diff = rnd.nextInt(60480000);
        Date tst = new Date(now - (long)diff);
        Severity sev = Severity.values()[rnd.nextInt(3)];
        String src = "192.168." + (1 + rnd.nextInt(254)) + "." + (1 + rnd.nextInt(254));
        int mlen = 10 + rnd.nextInt(70);
        byte[] bytes = new byte[mlen];
        int i = 0;
        while (i < mlen) {
            int wlen = 1 + rnd.nextInt(8);
            int j = i;
            while (j < Math.min(i + wlen, mlen)) {
                bytes[j++] = (byte)(97 + rnd.nextInt(26));
            }
            i = j;
            if (i >= mlen - 1) continue;
            bytes[i++] = 32;
        }
        String msg = new String(bytes);
        out.print("<?xml version='1.0'?>");
        out.printf("<log tstamp='%s' severity='%s'>", new Object[]{tst, sev});
        out.printf("<src>%s</src>", src);
        out.printf("<msg>%s</msg>", msg);
        out.print("</log>");
        out.close();
        return file;
    }

    static enum Severity {
        low,
        high,
        critical;

    }
}

