/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.examples;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.jdm.node.NodeStore;

public class StoreAndQuery {
    public static void main(String[] args) {
        try {
            StoreAndQuery.storeDocumentAndQuery();
            System.out.println();
            StoreAndQuery.storeCollectionAndQuery();
        }
        catch (QueryException e) {
            System.err.print("XQuery error ");
            System.err.print(e.getCode());
            System.err.print(": ");
            System.err.println(e.getMessage());
        }
    }

    private static void storeDocumentAndQuery() throws QueryException {
        BrackitQueryContext ctx = new BrackitQueryContext();
        NodeStore store = ctx.getNodeStore();
        System.out.println("Store document:");
        String query = "let $doc :=\n<log tstamp='{current-date()}' severity='critical'>\n    <src>192.168.12.31</src>\n    <msg>foo bar</msg>\n</log>\nreturn bit:store('mydoc.xml', $doc)";
        System.out.println(query);
        new Query(query).evaluate(ctx);
        System.out.println();
        System.out.println("Query stored document:");
        query = "doc('mydoc.xml')/log/@severity/string()";
        System.out.println(query);
        BrackitQueryContext ctx2 = new BrackitQueryContext(store);
        new Query(query).prettyPrint().serialize((QueryContext)ctx2, System.out);
        System.out.println();
    }

    private static void storeCollectionAndQuery() throws QueryException {
        BrackitQueryContext ctx = new BrackitQueryContext();
        NodeStore store = ctx.getNodeStore();
        System.out.println("Store collection:");
        String query = "let $docs :=\n   for $i in (1 to 10)\n   let $sev := if ($i mod 3 = 0) then\n                  'low'\n               else if ($i mod 3 = 1) then\n                   'high'\n               else 'critical'\n   return\n      <log tstamp='{current-date()}' severity='{$sev}'>\n        <src>192.168.12.{$i}</src>\n        <msg>foo bar</msg>\n      </log>\nreturn bit:store('mydocs.col', $docs)";
        System.out.println(query);
        new Query(query).evaluate(ctx);
        BrackitQueryContext ctx2 = new BrackitQueryContext(store);
        System.out.println();
        System.out.println("Query loaded collection:");
        String xq2 = "for $log in collection('mydocs.col')/log\nwhere $log/@severity='critical'\nreturn\n<message>\n  <from>{$log/src/text()}</from>\n  <body>{$log/msg/text()}</body>\n</message>";
        System.out.println(xq2);
        new Query(query).prettyPrint().serialize((QueryContext)ctx2, System.out);
        System.out.println();
    }
}

