/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractAtomic;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DTD;
import io.brackit.query.atomic.DateTime;
import io.brackit.query.atomic.Duration;
import io.brackit.query.atomic.TimeInstant;
import io.brackit.query.jdm.Type;
import java.util.TimeZone;

public abstract class AbstractTimeInstant
extends AbstractAtomic
implements TimeInstant {
    public static final DTD UTC_TIMEZONE = new DTD(false, 0, 0, 0, 0);
    public static final DTD MIN_TIMEZONE = new DTD(true, 14, 0, 0, 0);
    public static final DTD MAX_TIMEZONE = new DTD(false, 14, 0, 0, 0);
    public static DTD LOCAL_TIMEZONE;

    @Override
    public int hashCode() {
        throw new RuntimeException("Not implemented yet");
    }

    protected DTD parseTimezone(String str, char[] charArray, int pos, int length) throws QueryException {
        boolean negative = false;
        byte hour = 0;
        byte minute = 0;
        if (charArray[pos] == 'Z') {
            ++pos;
        } else if (charArray[pos] == '+' || charArray[pos] == '-') {
            int v;
            negative = charArray[pos++] == '-';
            int start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            int end = pos;
            int n = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
            if (v < 0 || v > 24) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: illegal hour", str);
            }
            hour = (byte)v;
            if (pos >= length || charArray[pos++] != ':') {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Illegal hour in timezone: %s", str);
            }
            start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            int n2 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
            if (v < 0 || v > 59) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Illegal minute in timezone: %s", str);
            }
            minute = (byte)v;
        } else {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Illegal timezone: %s", str);
        }
        if (pos != length) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Illegal timezone: %s", str);
        }
        if (hour == 0 && minute == 0) {
            return UTC_TIMEZONE;
        }
        return new DTD(negative, 0, hour, minute, 0);
    }

    protected int cmp(AbstractTimeInstant other) {
        boolean aHasTZ = false;
        boolean bHasTZ = false;
        AbstractTimeInstant a = this;
        AbstractTimeInstant b = other;
        if (a.getTimezone() != null && (a.getTimezone().getHours() != 0 || a.getTimezone().getMinutes() != 0)) {
            a = new DateTime(a.getYear(), a.getMonth(), a.getDay(), a.getHours(), a.getMinutes(), a.getMicros(), a.getTimezone()).canonicalize();
            aHasTZ = true;
        }
        if (b.getTimezone() != null && (b.getTimezone().getHours() != 0 || b.getTimezone().getMinutes() != 0)) {
            b = new DateTime(b.getYear(), b.getMonth(), b.getDay(), b.getHours(), b.getMinutes(), b.getMicros(), b.getTimezone()).canonicalize();
            bHasTZ = true;
        }
        if (!(aHasTZ ^ bHasTZ)) {
            return this.compareFields(a, b);
        }
        if (aHasTZ) {
            AbstractTimeInstant b2 = b.add(false, MAX_TIMEZONE, UTC_TIMEZONE);
            int res = this.compareFields(a, b2);
            if (res < 0) {
                return res;
            }
            AbstractTimeInstant b3 = b.add(true, MIN_TIMEZONE, UTC_TIMEZONE);
            res = this.compareFields(a, b3);
            if (res > 0) {
                return res;
            }
            return 0;
        }
        AbstractTimeInstant a2 = a.add(true, MIN_TIMEZONE, UTC_TIMEZONE);
        int res = this.compareFields(a2, b);
        if (res < 0) {
            return res;
        }
        AbstractTimeInstant a3 = a.add(false, MAX_TIMEZONE, UTC_TIMEZONE);
        res = this.compareFields(a3, b);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    private int compareFields(TimeInstant a, TimeInstant b) {
        int res = a.getYear() - b.getYear();
        if (res != 0) {
            return res;
        }
        res = a.getMonth() - b.getMonth();
        if (res != 0) {
            return res;
        }
        res = a.getDay() - b.getDay();
        if (res != 0) {
            return res;
        }
        res = a.getHours() - b.getHours();
        if (res != 0) {
            return res;
        }
        res = a.getMinutes() - b.getMinutes();
        if (res != 0) {
            return res;
        }
        res = a.getMicros() - b.getMicros();
        return res;
    }

    protected AbstractTimeInstant add(boolean negate, Duration duration, DTD newTimezone) {
        short durationYears = duration.getYears();
        byte durationMonths = duration.getMonths();
        short durationDays = duration.getDays();
        byte durationHours = duration.getHours();
        byte durationMinutes = duration.getMinutes();
        int durationMicros = duration.getMicros();
        if (negate) {
            durationYears = (short)(durationYears * -1);
            durationMonths = (byte)(durationMonths * -1);
            durationDays = (short)(durationDays * -1);
            durationHours = (byte)(durationHours * -1);
            durationMinutes = (byte)(durationMinutes * -1);
            durationMicros *= -1;
        }
        int temp = this.getMonth() + durationMonths;
        int newMonth = AbstractTimeInstant.modulo(temp, 1, 13);
        int carry = AbstractTimeInstant.fQuotient(temp, 1, 13);
        int newYear = this.getYear() + durationYears + carry;
        temp = this.getMicros() + durationMicros;
        int newMicros = AbstractTimeInstant.modulo(temp, 60000000);
        carry = AbstractTimeInstant.fQuotient(temp, 60000000);
        temp = this.getMinutes() + durationMinutes + carry;
        int newMinutes = AbstractTimeInstant.modulo(temp, 60);
        carry = AbstractTimeInstant.fQuotient(temp, 60);
        temp = this.getHours() + durationHours + carry;
        int newHours = AbstractTimeInstant.modulo(temp, 24);
        carry = AbstractTimeInstant.fQuotient(temp, 24);
        byte maxDayInMonth = this.maxDayInMonth(newYear, newMonth);
        int newDays = (this.getDay() > maxDayInMonth ? maxDayInMonth : (this.getDay() < 1 ? (byte)1 : this.getDay())) + durationDays + carry;
        while (true) {
            if (newDays < 0) {
                newDays += this.maxDayInMonth(newYear, newMonth - 1);
                carry = -1;
            } else {
                if (newDays <= this.maxDayInMonth(newYear, newMonth)) break;
                newDays -= this.maxDayInMonth(newYear, newMonth);
                carry = 1;
            }
            temp = newMonth + carry;
            newMonth = AbstractTimeInstant.modulo(temp, 1, 13);
            newYear += AbstractTimeInstant.fQuotient(temp, 1, 13);
        }
        return this.create((short)newYear, (byte)newMonth, (byte)newDays, (byte)newHours, (byte)newMinutes, newMicros, newTimezone);
    }

    protected DTD subtract(AbstractTimeInstant b) {
        byte maxDayInMonth2;
        byte maxDayInMonth;
        int hours;
        int minutes;
        boolean negative = false;
        AbstractTimeInstant a = this;
        if (a.getTimezone() != null) {
            a = a.canonicalize();
        }
        if (b.getTimezone() != null) {
            b = b.canonicalize();
        }
        if (a.cmp(b) <= 0) {
            a = b;
            b = this;
            negative = true;
        }
        int carry = 0;
        int micros = a.getMicros() - b.getMicros();
        if (micros < 0) {
            micros *= -1;
            carry = 1;
        }
        if ((minutes = a.getMinutes() - b.getMinutes() + carry) < 0) {
            minutes *= -1;
            carry = 1;
        } else {
            carry = 0;
        }
        short days = 0;
        int ehour = b.getHours() + carry;
        int eyear = b.getYear();
        int emonth = b.getMonth();
        int eday = b.getDay();
        if (ehour < a.getHours()) {
            hours = a.getHours() - ehour;
        } else {
            hours = 24 - ehour + a.getHours();
            if (eday == this.maxDayInMonth(eyear, emonth)) {
                if (emonth == 12) {
                    ++eyear;
                    emonth = 1;
                } else {
                    ++emonth;
                }
                eday = 1;
            } else {
                ++eday;
            }
        }
        if (eyear < a.getYear()) {
            maxDayInMonth = this.maxDayInMonth(eyear, emonth);
            days = (short)(days + (maxDayInMonth - eday + 1));
            eday = 1;
            while (++emonth <= 12) {
                maxDayInMonth2 = this.maxDayInMonth(eyear, emonth);
                days = (short)(days + maxDayInMonth2);
            }
            emonth = 1;
            while (++eyear < a.getYear()) {
                boolean isLeap = eyear % 400 == 0 || eyear % 100 != 0 && eyear % 4 == 0;
                days = (short)(days + (isLeap ? 366 : 365));
            }
        }
        if (emonth < a.getMonth()) {
            maxDayInMonth = this.maxDayInMonth(eyear, emonth);
            days = (short)(days + (maxDayInMonth - eday + 1));
            eday = 1;
            while (++emonth < a.getMonth()) {
                maxDayInMonth2 = this.maxDayInMonth(eyear, emonth);
                days = (short)(days + maxDayInMonth2);
            }
        }
        if (eday < a.getDay()) {
            days = (short)(days + (a.getDay() - eday));
        }
        return new DTD(negative, days, (byte)hours, (byte)minutes, micros);
    }

    private static int fQuotient(int a, int low, int high) {
        return AbstractTimeInstant.fQuotient(a - low, high - low);
    }

    private static int modulo(int a, int b) {
        return a - AbstractTimeInstant.fQuotient(a, b) * b;
    }

    private static int fQuotient(int a, int b) {
        return a >= 0 ? a / b : (a / b * b == a ? a / b : a / b - 1);
    }

    private static int modulo(int a, int low, int high) {
        return AbstractTimeInstant.modulo(a - low, high - low) + low;
    }

    @Override
    public final int atomicCmpInternal(Atomic atomic) {
        AbstractTimeInstant other = (AbstractTimeInstant)atomic;
        int res = this.cmp(other);
        if (res != 0) {
            return res;
        }
        if (this.getYear() != other.getYear()) {
            return this.getYear() - other.getYear();
        }
        if (this.getMonth() != other.getMonth()) {
            return this.getMonth() - other.getMonth();
        }
        if (this.getDay() != other.getDay()) {
            return this.getDay() - other.getDay();
        }
        if (this.getHours() != other.getHours()) {
            return this.getHours() - other.getHours();
        }
        if (this.getMinutes() != other.getMinutes()) {
            return this.getMinutes() - other.getMinutes();
        }
        if (this.getMicros() != other.getMicros()) {
            return this.getMicros() - other.getMicros();
        }
        DTD tz = this.getTimezone();
        DTD otz = other.getTimezone();
        return tz == null ? (otz == null ? 0 : -1) : (otz == null ? 1 : tz.atomicCmpInternal(otz));
    }

    protected abstract AbstractTimeInstant create(short var1, byte var2, byte var3, byte var4, byte var5, int var6, DTD var7);

    protected byte maxDayInMonth(int year, int month) {
        int m = month % 13;
        int y = year + month / 13;
        if (m == 2) {
            return (byte)(y % 400 == 0 || y % 100 != 0 && y % 4 == 0 ? 29 : 28);
        }
        if (m == 4 || m == 6 || m == 9 || m == 11) {
            return 30;
        }
        return 31;
    }

    protected String timezoneString() {
        DTD timezone = this.getTimezone();
        String tzTmp = "";
        if (timezone != null) {
            byte tzHours = timezone.getHours();
            String tzHTmp = (tzHours < 10 ? "0" : "") + tzHours;
            byte tzMinutes = timezone.getMinutes();
            String tzMinTmp = (tzMinutes < 10 ? "0" : "") + tzMinutes;
            tzTmp = tzHours == 0 && tzMinutes == 0 ? "Z" : (timezone.isNegative() ? "-" : "+") + tzHTmp + ":" + tzMinTmp;
        }
        return tzTmp;
    }

    @Override
    public AbstractTimeInstant canonicalize() {
        DTD timezone = this.getTimezone();
        if (timezone == null || timezone.getDays() == 0 && timezone.getHours() == 0) {
            return this;
        }
        return this.add(!timezone.isNegative(), timezone, UTC_TIMEZONE);
    }

    @Override
    public final Atomic asType(Type type) throws QueryException {
        throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR);
    }

    @Override
    public final boolean booleanValue() throws QueryException {
        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value of '%s' is undefined.", this.type());
    }

    static {
        int offset = TimeZone.getDefault().getOffset(System.currentTimeMillis());
        int hours = AbstractTimeInstant.fQuotient(offset, 3600000);
        int remainder = AbstractTimeInstant.modulo(offset, 3600000);
        int minutes = AbstractTimeInstant.fQuotient(remainder, 60000);
        remainder = AbstractTimeInstant.modulo(remainder, 60000);
        int micros = remainder * 1000;
        LOCAL_TIMEZONE = new DTD(offset < 0, 0, (byte)hours, (byte)minutes, micros);
    }
}

