/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractAtomic;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;
import java.util.Arrays;

public class B64
extends AbstractAtomic {
    private final byte[] bytes;

    public B64(byte[] bytes) {
        this.bytes = bytes;
    }

    public B64(String str) throws QueryException {
        str = Whitespace.fullcollapse(str);
        if ((str.length() & 3) != 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:base64Binary", str);
        }
        int size = 0;
        int length = str.length();
        byte[] bytes = new byte[this.noOfOctets(str)];
        int charPos = 0;
        while (charPos < length) {
            char c1 = str.charAt(charPos++);
            char c2 = str.charAt(charPos++);
            char c3 = str.charAt(charPos++);
            char c4 = str.charAt(charPos++);
            bytes[size++] = (byte)this.b64(str, c1);
            bytes[size++] = (byte)(c3 != '=' ? this.b64(str, c2) : this.b04(str, c2));
            if (c4 != '=') {
                bytes[size++] = (byte)this.b64(str, c3);
                bytes[size++] = (byte)this.b64(str, c4);
                continue;
            }
            if (c3 != '=') {
                bytes[size] = (byte)this.b16(str, c3);
            }
            if (charPos == length) break;
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:base64Binary", str);
        }
        this.bytes = bytes;
    }

    private int b04(String str, char c) throws QueryException {
        int v;
        if (c == 'A') {
            v = 0;
        } else if (c == 'Q') {
            v = 16;
        } else if (c == 'g') {
            v = 32;
        } else if (c == 'w') {
            v = 48;
        } else {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:base64Binary", str);
        }
        return v;
    }

    private int b16(String str, char c) throws QueryException {
        int v;
        if (c == 'A') {
            v = 0;
        } else if (c == 'E') {
            v = 4;
        } else if (c == 'I') {
            v = 8;
        } else if (c == 'M') {
            v = 12;
        } else if (c == 'Q') {
            v = 16;
        } else if (c == 'U') {
            v = 20;
        } else if (c == 'Y') {
            v = 24;
        } else if (c == 'c') {
            v = 28;
        } else if (c == 'g') {
            v = 32;
        } else if (c == 'k') {
            v = 36;
        } else if (c == 'o') {
            v = 40;
        } else if (c == 's') {
            v = 44;
        } else if (c == 'w') {
            v = 48;
        } else if (c == '0') {
            v = 52;
        } else if (c == '4') {
            v = 56;
        } else if (c == '8') {
            v = 60;
        } else {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:base64Binary", str);
        }
        return v;
    }

    private int noOfOctets(String str) {
        int dataLength = str.length();
        if (dataLength > 0 && str.charAt(dataLength - 1) == '=') {
            --dataLength;
        }
        if (dataLength > 0 && str.charAt(dataLength - 1) == '=') {
            --dataLength;
        }
        return dataLength;
    }

    private int b64(String str, char c) throws QueryException {
        int v;
        if (c >= '0' && c <= '9') {
            v = 52 + c - 48;
        } else if (c >= 'A' && c <= 'Z') {
            v = c - 65;
        } else if (c >= 'a' && c <= 'z') {
            v = 26 + c - 87;
        } else if (c == '+') {
            v = 62;
        } else if (c == '/') {
            v = 63;
        } else {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:base64Binary", str);
        }
        return v;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
    }

    @Override
    public boolean eq(Atomic atomic) throws QueryException {
        if (!(atomic instanceof B64)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return Arrays.equals(this.bytes, ((B64)atomic).bytes);
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        byte[] bytes2 = ((B64)atomic).bytes;
        for (int i = 0; i < Math.min(this.bytes.length, bytes2.length); ++i) {
            if (this.bytes[i] == bytes2[i]) continue;
            return (this.bytes[i] & 0xFF) - (bytes2[i] & 0xFF);
        }
        return this.bytes.length - bytes2.length;
    }

    @Override
    public int atomicCode() {
        return 14;
    }

    @Override
    public String stringValue() {
        StringBuilder out = new StringBuilder();
        for (byte aByte : this.bytes) {
            int v = aByte & 0xFF;
            char c = (char)(v < 26 ? v + 65 : (v < 52 ? v - 26 + 87 : (v < 62 ? v - 52 + 48 : (v == 62 ? 43 : 47))));
            out.append(c);
        }
        return out.toString();
    }

    @Override
    public Type type() {
        return Type.B64;
    }

    @Override
    public boolean booleanValue() throws QueryException {
        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value of '%s' is undefined.", this.type());
    }
}

