/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractAtomic;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.Type;

public class Bool
extends AbstractAtomic {
    public final boolean bool;
    public static final Bool FALSE = new Bool(false);
    public static final Bool TRUE = new Bool(true);

    public Bool(Boolean bool) {
        this.bool = bool;
    }

    public Bool(boolean bool) {
        this.bool = bool;
    }

    public Bool(Bool v) {
        this.bool = v.bool;
    }

    @Override
    public Type type() {
        return Type.BOOL;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return new DBool(this.bool, type);
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return this.bool;
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof Bool) {
            return this.bool == ((Bool)other).bool ? 0 : (((Bool)other).bool ? 1 : -1);
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic other) {
        return this.bool == ((Bool)other).bool ? 0 : (((Bool)other).bool ? 1 : -1);
    }

    @Override
    public int atomicCode() {
        return 13;
    }

    @Override
    public String stringValue() {
        return Boolean.toString(this.bool);
    }

    @Override
    public int hashCode() {
        return this.bool ? 1231 : 1237;
    }

    private static class DBool
    extends Bool {
        private final Type type;

        public DBool(boolean bool, Type type) {
            super(bool);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

