/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractNumeric;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DblNumeric;
import io.brackit.query.atomic.DecNumeric;
import io.brackit.query.atomic.FltNumeric;
import io.brackit.query.atomic.Int;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Dec
extends AbstractNumeric
implements DecNumeric {
    private final BigDecimal v;

    public Dec(String str) throws QueryException {
        try {
            this.v = new BigDecimal(Whitespace.collapseTrimOnly(str));
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:decimal", str);
        }
    }

    public Dec(BigDecimal v) {
        this.v = v;
    }

    public Dec(Dec v) {
        this.v = v.v;
    }

    @Override
    public Type type() {
        return Type.DEC;
    }

    @Override
    public IntNumeric asIntNumeric() {
        try {
            return new Int(this.v);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return new DDec(this.v, type);
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return this.v.intValue() != 0;
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.v.compareTo(((Numeric)other).decimalValue());
        }
        if (other instanceof DblNumeric) {
            return Double.compare(this.v.doubleValue(), ((Numeric)other).doubleValue());
        }
        if (other instanceof FltNumeric) {
            return Float.compare(this.v.floatValue(), ((Numeric)other).floatValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic other) {
        if (other instanceof DecNumeric) {
            return this.v.compareTo(((Numeric)other).decimalValue());
        }
        if (other instanceof DblNumeric) {
            return Double.compare(this.v.doubleValue(), ((Numeric)other).doubleValue());
        }
        return Float.compare(this.v.floatValue(), ((Numeric)other).floatValue());
    }

    @Override
    public String stringValue() {
        String s = this.v.toPlainString();
        return this.v.scale() <= 0 ? s : this.killTrailingZeros(s);
    }

    public static void main(String[] args) {
        System.out.println(new Dec("0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001").toString());
        System.out.println(new Dec(BigDecimal.valueOf(-0.0)).toString());
        System.out.println(new Dec("-2300.44004000"));
        System.out.println(new Dec("40"));
        System.out.println(new Dec("40.0"));
    }

    @Override
    public BigDecimal decimalValue() {
        return this.v;
    }

    @Override
    public BigDecimal integerValue() {
        return this.v.setScale(0, RoundingMode.FLOOR);
    }

    @Override
    public double doubleValue() {
        return this.v.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.v.floatValue();
    }

    @Override
    public long longValue() {
        return this.v.longValue();
    }

    @Override
    public int intValue() {
        return this.v.intValue();
    }

    @Override
    public Numeric add(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.addBigDecimal(this.v, other.decimalValue(), true);
        }
        if (other instanceof DblNumeric) {
            return this.addDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.addFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric subtract(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.subtractBigDecimal(this.v, other.decimalValue(), true);
        }
        if (other instanceof DblNumeric) {
            return this.subtractDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.subtractFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric multiply(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.multiplyBigDecimal(this.v, other.decimalValue(), true);
        }
        if (other instanceof DblNumeric) {
            return this.multiplyDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.multiplyFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric div(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.divideBigDecimal(this.v, other.decimalValue(), true);
        }
        if (other instanceof DblNumeric) {
            return this.divideDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.divideFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric idiv(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.idivideBigDecimal(this.v, other.decimalValue());
        }
        if (other instanceof DblNumeric) {
            return this.idivideDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.idivideFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric mod(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.modBigDecimal(this.v, other.decimalValue());
        }
        if (other instanceof DblNumeric) {
            return this.modDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.modFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric negate() throws QueryException {
        return new Dec(this.v.negate());
    }

    @Override
    public Numeric round() throws QueryException {
        return this.v.signum() >= 0 ? new Dec(this.v.setScale(0, RoundingMode.HALF_UP)) : new Dec(this.v.setScale(0, RoundingMode.DOWN));
    }

    @Override
    public Numeric abs() throws QueryException {
        return this.v.signum() >= 0 ? this : new Int(this.v.negate());
    }

    @Override
    public Numeric ceiling() throws QueryException {
        return new Dec(this.v.setScale(0, RoundingMode.CEILING));
    }

    @Override
    public Numeric floor() throws QueryException {
        return new Dec(this.v.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public Numeric roundHalfToEven(int precision) throws QueryException {
        BigDecimal bd = this.v.scaleByPowerOfTen(precision);
        bd = bd.setScale(0, RoundingMode.HALF_EVEN);
        return new Dec(bd.scaleByPowerOfTen(-precision));
    }

    private static class DDec
    extends Dec {
        private final Type type;

        public DDec(BigDecimal v, Type type) {
            super(v);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

