/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractTimeInstant;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DTD;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;

public class GYM
extends AbstractTimeInstant {
    private final short year;
    private final byte month;
    private final DTD timezone;

    public GYM(short year, byte month, DTD timezone) {
        this.year = year;
        this.month = month;
        this.timezone = timezone;
    }

    public GYM(String str) throws QueryException {
        short year;
        int v;
        DTD timezone = null;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int pos = 0;
        int length = charArray.length;
        boolean negative = false;
        if (pos == length || charArray[pos] == '-') {
            negative = true;
            ++pos;
        }
        int start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        int end = pos;
        if (end - start < 4) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gYearMonth", str);
        }
        if (end - start > 4 && negative) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gYearMonth", str);
        }
        int n = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v > Short.MAX_VALUE || v == 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gYearMonth", str);
        }
        short s = year = negative ? (short)(-v) : (short)v;
        if (pos >= length || charArray[pos++] != '-') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gYearMonth", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n2 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 1 || v > 12) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gYearMonth: illegal month", str);
        }
        byte month = (byte)v;
        if (pos < length) {
            timezone = this.parseTimezone(str, charArray, pos, length);
        }
        this.year = year;
        this.month = month;
        this.timezone = timezone;
    }

    @Override
    public int atomicCode() {
        return 8;
    }

    @Override
    protected AbstractTimeInstant create(short year, byte month, byte day, byte hours, byte minutes, int micros, DTD timezone) {
        return new GYM(year, month, timezone);
    }

    @Override
    public byte getDay() {
        return 0;
    }

    @Override
    public byte getHours() {
        return 0;
    }

    @Override
    public byte getMinutes() {
        return 0;
    }

    @Override
    public byte getMonth() {
        return this.month;
    }

    @Override
    public int getMicros() {
        return 0;
    }

    @Override
    public DTD getTimezone() {
        return this.timezone;
    }

    @Override
    public short getYear() {
        return this.year;
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
    }

    @Override
    public boolean eq(Atomic atomic) throws QueryException {
        if (!(atomic instanceof GYM)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return this.cmp((GYM)atomic) == 0;
    }

    @Override
    public String stringValue() {
        String yTmp = this.year < 0 ? "-" : (this.year < 10 ? "000" : (this.year < 100 ? "00" : (this.year < 1000 ? "0" : ""))) + this.year;
        String mTmp = (this.month < 10 ? "0" : "") + this.month;
        String tzTmp = this.timezoneString();
        return String.format("%s-%s%s", yTmp, mTmp, tzTmp);
    }

    @Override
    public Type type() {
        return Type.GYM;
    }
}

