/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.block.Sink;
import io.brackit.query.util.forkjoin.Deque;
import io.brackit.query.util.forkjoin.Task;
import io.brackit.query.util.forkjoin.Worker;
import java.util.concurrent.locks.LockSupport;

public abstract class ChainedSink
implements Sink {
    private static final boolean SUSPEND = true;
    private static final int NO_TOKEN = 0;
    private static final int WAIT_TOKEN = 1;
    private static final int HAS_TOKEN = 2;
    private static final int HAS_START_TOKEN = 3;
    private static final int FAILED = 4;
    private ChainedSink next;
    private volatile int state = 3;
    private volatile Deque<Task> deposit;
    private volatile Thread blocked;

    @Override
    public final ChainedSink fork() {
        ChainedSink fork = this.doFork();
        fork.next = this.next;
        fork.state = 0;
        this.next = fork;
        return this.next;
    }

    protected abstract ChainedSink doFork();

    @Override
    public final ChainedSink partition(Sink stopAt) {
        ChainedSink partition = this.doPartition(stopAt);
        if (this.chainPartitions()) {
            partition.next = this.next;
            partition.state = 0;
            this.next = partition;
        }
        return partition;
    }

    protected boolean chainPartitions() {
        return false;
    }

    protected abstract ChainedSink doPartition(Sink var1);

    protected void processPending() throws QueryException {
    }

    protected boolean hasPending() {
        return false;
    }

    protected void clearPending() {
    }

    protected boolean yield() {
        return false;
    }

    protected void unyield() {
    }

    protected void setPending(Tuple[] buf, int len) throws QueryException {
    }

    protected void doOutput(Tuple[] buf, int len) throws QueryException {
    }

    protected void doBegin() throws QueryException {
    }

    protected void doEnd() throws QueryException {
    }

    protected void doFirstBegin() throws QueryException {
    }

    protected void doFinalEnd() throws QueryException {
    }

    protected void doFail() throws QueryException {
    }

    @Override
    public final void output(Tuple[] buf, int len) throws QueryException {
        int s = this.state;
        if (s == 2) {
            if (this.hasPending()) {
                this.processPending();
            }
            this.doOutput(buf, len);
        } else {
            if (s == 4) {
                if (this.hasPending()) {
                    this.clearPending();
                }
                this.promoteFailure();
                throw new QueryException(ErrorCode.BIT_DYN_ABORTED_ERROR);
            }
            this.setPending(buf, len);
        }
    }

    @Override
    public final void begin() throws QueryException {
        if (this.state == 3) {
            this.doFirstBegin();
            this.state = 2;
        }
        this.doBegin();
    }

    @Override
    public final void fail() throws QueryException {
        this.state = 4;
        this.promoteFailure();
        this.doFail();
    }

    @Override
    public final void end() throws QueryException {
        int s = this.state;
        if (s == 0) {
            boolean hasPending = this.hasPending();
            Worker worker = null;
            Deque<Task> queue = null;
            if (hasPending) {
                worker = (Worker)Thread.currentThread();
                this.blocked = worker;
            }
            if (this.compareAndSet(0, 1)) {
                if (hasPending && (this.yield() || !this.compareAndSet(queue, null))) {
                    LockSupport.park(this);
                }
                return;
            }
            s = this.state;
        }
        if (s == 2) {
            this.endWithToken();
        } else if (s == 4) {
            this.endWithFailure();
        }
    }

    private void endWithFailure() throws QueryException {
        if (this.hasPending()) {
            this.clearPending();
        }
        this.promoteFailure();
    }

    private void endWithToken() throws QueryException {
        if (this.hasPending()) {
            this.processPending();
        }
        this.promoteToken();
        this.doEnd();
    }

    private void promoteToken() throws QueryException {
        ChainedSink n = this.next;
        this.next = null;
        while (n != null && !n.compareAndSet(0, 2)) {
            if (n.state == 1) {
                n.state = 2;
                this.takeover(n);
                n = n.next;
                continue;
            }
            n.promoteFailure();
            return;
        }
        if (n == null) {
            this.doFinalEnd();
        }
    }

    private void promoteFailure() throws QueryException {
        ChainedSink n = this.next;
        while (n != null && !n.compareAndSet(0, 4) && n.state != 4) {
            n.clearPending();
            if (n.deposit != null) {
                // empty if block
            }
            this.doFail();
            n = n.next;
        }
    }

    private void takeover(ChainedSink n) throws QueryException {
        Deque<Task> queue;
        LockSupport.unpark(n.blocked);
        if (n.hasPending()) {
            n.processPending();
        }
        if ((queue = n.deposit) != null && n.compareAndSet(queue, null)) {
            n.unyield();
            ((Worker)Thread.currentThread()).adopt(queue);
        }
        n.doEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareAndSet(int expected, int set) {
        ChainedSink chainedSink = this;
        synchronized (chainedSink) {
            if (this.state == expected) {
                this.state = set;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareAndSet(Deque<Task> expected, Deque<Task> set) {
        ChainedSink chainedSink = this;
        synchronized (chainedSink) {
            if (this.deposit == expected) {
                this.deposit = set;
                return true;
            }
            return false;
        }
    }
}

