/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Counter;
import io.brackit.query.block.Block;
import io.brackit.query.block.ChainedSink;
import io.brackit.query.block.FJControl;
import io.brackit.query.block.SerialSink;
import io.brackit.query.block.Sink;
import java.util.concurrent.Semaphore;

public class Count
implements Block {
    @Override
    public Sink create(QueryContext ctx, Sink sink) throws QueryException {
        return new CountSink(sink);
    }

    @Override
    public int outputWidth(int initSize) {
        return initSize + 1;
    }

    static class CountSink
    extends SerialSink {
        final Sink sink;
        final Counter pos;

        CountSink(Sink sink) {
            super(FJControl.PERMITS);
            this.sink = sink;
            this.pos = new Counter();
        }

        CountSink(Semaphore sem, Sink sink, Counter pos) {
            super(sem);
            this.sink = sink;
            this.pos = pos;
        }

        @Override
        protected ChainedSink doPartition(Sink stopAt) {
            return new CountSink(this.sem, this.sink.partition(stopAt), new Counter());
        }

        @Override
        protected SerialSink doFork() {
            return new CountSink(this.sem, this.sink, this.pos);
        }

        @Override
        protected void doOutput(Tuple[] buf, int len) throws QueryException {
            Tuple[] out = new Tuple[len];
            for (int i = 0; i < len; ++i) {
                this.pos.inc();
                out[i] = buf[i].concat(this.pos.asIntNumeric());
            }
            this.sink.output(out, len);
        }

        @Override
        protected void doFirstBegin() throws QueryException {
            this.sink.begin();
        }

        @Override
        protected void doFinalEnd() throws QueryException {
            this.sink.end();
        }
    }
}

