/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.block.Block;
import io.brackit.query.block.FJControl;
import io.brackit.query.block.Sink;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.util.forkjoin.Task;
import java.util.ArrayDeque;

public class ForBind
implements Block {
    public static int MIN = 1;
    public static int MAX = 1;
    public static int MAX_QUEUE = 6;
    public static int SPLIT_INPUT = 50;
    final Expr expr;
    final boolean allowingEmpty;
    final int min;
    final int max;
    final int maxQueue;
    final int splitIn;
    boolean bindVar = true;
    boolean bindPos = false;

    public ForBind(Expr expr, boolean allowingEmpty) {
        this(expr, allowingEmpty, MIN, MAX, MAX_QUEUE, SPLIT_INPUT);
    }

    public ForBind(Expr expr, boolean allowingEmpty, int min, int max, int maxQueue, int splitIn) {
        this.expr = expr;
        this.allowingEmpty = allowingEmpty;
        this.min = min;
        this.max = max;
        if (maxQueue < 1) {
            throw new IllegalStateException("maxQueue must be >= 1");
        }
        this.maxQueue = maxQueue;
        this.splitIn = splitIn;
    }

    @Override
    public int outputWidth(int initSize) {
        return initSize + (this.bindVar ? 1 : 0) + (this.bindPos ? 1 : 0);
    }

    @Override
    public Sink create(QueryContext ctx, Sink sink) throws QueryException {
        return new ForBindSink(ctx, sink);
    }

    public void bindVariable(boolean bindVariable) {
        this.bindVar = bindVariable;
    }

    public void bindPosition(boolean bindPos) {
        this.bindPos = bindPos;
    }

    private class ForBindSink
    extends FJControl
    implements Sink {
        Sink s;
        final QueryContext ctx;

        private ForBindSink(QueryContext ctx, Sink s) {
            this.ctx = ctx;
            this.s = s;
        }

        @Override
        public void output(Tuple[] t, int len) throws QueryException {
            Sink ss = this.s;
            this.s = this.s.fork();
            OutputTask task = new OutputTask(this.ctx, ss, t, 0, len);
            task.compute();
        }

        @Override
        public Sink fork() {
            return new ForBindSink(this.ctx, this.s.fork());
        }

        @Override
        public Sink partition(Sink stopAt) {
            return new ForBindSink(this.ctx, this.s.partition(stopAt));
        }

        @Override
        public void fail() throws QueryException {
            this.s.begin();
            this.s.fail();
        }

        @Override
        public void begin() throws QueryException {
        }

        @Override
        public void end() throws QueryException {
            this.s.begin();
            this.s.end();
        }
    }

    private class OutputTask
    extends Task {
        private final QueryContext ctx;
        private final Tuple[] buf;
        private final int start;
        private final int end;
        private Sink sink;

        public OutputTask(QueryContext ctx, Sink sink, Tuple[] buf, int start, int end) {
            this.ctx = ctx;
            this.sink = sink;
            this.buf = buf;
            this.start = start;
            this.end = end;
        }

        @Override
        public void compute() throws QueryException {
            if (this.end - this.start > ForBind.this.splitIn) {
                int mid = this.start + (this.end - this.start) / 2;
                OutputTask a = new OutputTask(this.ctx, this.sink.fork(), this.buf, mid, this.end);
                OutputTask b = new OutputTask(this.ctx, this.sink, this.buf, this.start, mid);
                a.fork();
                b.compute();
                a.join();
            } else {
                for (int i = this.start; i < this.end; ++i) {
                    Sequence s = ForBind.this.expr.evaluate(this.ctx, this.buf[i]);
                    if (s == null) continue;
                    Sink ss = this.sink;
                    this.sink = this.sink.fork();
                    ForBindTask t = new ForBindTask(ss, this.buf[i], s.iterate());
                    t.compute();
                }
                this.sink.begin();
                this.sink.end();
            }
        }
    }

    private class ForBindTask
    extends Task {
        final Tuple t;
        Iter it;
        Sink sink;
        IntNumeric pos;

        public ForBindTask(Sink sink, Tuple t, Iter it) {
            this.pos = ForBind.this.bindPos ? Int32.ZERO : null;
            this.sink = sink;
            this.t = t;
            this.it = it;
        }

        @Override
        public void compute() throws QueryException {
            Iter.Split split = this.it.split(ForBind.this.min, ForBind.this.max);
            if (split.tail == null) {
                this.process(split.head);
            } else if (!split.serial) {
                ForBindTask task1 = new ForBindTask(this.sink, this.t, split.head);
                ForBindTask task2 = new ForBindTask(this.sink.fork(), this.t, split.tail);
                task2.fork();
                task1.compute();
                task2.join();
            } else {
                ArrayDeque<ForBindTask> queue = new ArrayDeque<ForBindTask>();
                while (true) {
                    ForBindTask task = new ForBindTask(this.sink, this.t, split.head);
                    if (split.tail != null) {
                        this.sink = this.sink.fork();
                    }
                    FJControl.POOL.dispatch(task);
                    queue.add(task);
                    if (split.tail == null) break;
                    if (queue.size() == ForBind.this.maxQueue) {
                        ((Task)queue.poll()).joinSerial();
                    }
                    split = split.tail.split(ForBind.this.min, ForBind.this.max);
                }
                Task t = (Task)queue.poll();
                while (t != null) {
                    t.joinSerial();
                    t = (Task)queue.poll();
                }
            }
        }

        private void process(Iter it) throws QueryException {
            this.sink.begin();
            try (Iter iter = it;){
                Item i;
                Tuple[] buf = new Tuple[ForBind.this.max];
                int len = 0;
                while ((i = it.next()) != null) {
                    buf[len++] = this.emit(this.t, i);
                    if (len != ForBind.this.max) continue;
                    this.sink.output(buf, len);
                    buf = new Tuple[ForBind.this.max];
                    len = 0;
                }
                if (len > 0) {
                    this.sink.output(buf, len);
                }
            }
            catch (QueryException e) {
                this.sink.fail();
                throw e;
            }
            this.sink.end();
        }

        private Tuple emit(Tuple t, Sequence item) throws QueryException {
            if (ForBind.this.bindVar) {
                if (ForBind.this.bindPos) {
                    return t.concat(new Sequence[]{item, item != null ? (this.pos = this.pos.inc()) : this.pos});
                }
                return t.concat(item);
            }
            if (ForBind.this.bindPos) {
                return t.concat(item != null ? (this.pos = this.pos.inc()) : this.pos);
            }
            return t;
        }
    }
}

