/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.block.Block;
import io.brackit.query.block.Sink;
import io.brackit.query.jdm.Expr;

public class LetBind
implements Block {
    final Expr expr;

    public LetBind(Expr expr) {
        this.expr = expr;
    }

    @Override
    public Sink create(QueryContext ctx, Sink sink) throws QueryException {
        return new LetBindSink(ctx, sink);
    }

    @Override
    public int outputWidth(int inputWidth) {
        return inputWidth + 1;
    }

    private class LetBindSink
    implements Sink {
        final QueryContext ctx;
        final Sink sink;

        public LetBindSink(QueryContext ctx, Sink sink) {
            this.ctx = ctx;
            this.sink = sink;
        }

        @Override
        public void output(Tuple[] buf, int len) throws QueryException {
            for (int i = 0; i < len; ++i) {
                Tuple t = buf[i];
                buf[i] = t.concat(LetBind.this.expr.evaluate(this.ctx, t));
            }
            this.sink.output(buf, len);
        }

        @Override
        public Sink fork() {
            return new LetBindSink(this.ctx, this.sink.fork());
        }

        @Override
        public Sink partition(Sink stopAt) {
            return new LetBindSink(this.ctx, this.sink.partition(stopAt));
        }

        @Override
        public void end() throws QueryException {
            this.sink.end();
        }

        @Override
        public void begin() throws QueryException {
            this.sink.begin();
        }

        @Override
        public void fail() throws QueryException {
            this.sink.fail();
        }
    }
}

