/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.block.Block;
import io.brackit.query.block.Sink;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Sequence;

public class Select
implements Block {
    final Expr pred;

    public Select(Expr pred) {
        this.pred = pred;
    }

    @Override
    public Sink create(QueryContext ctx, Sink sink) throws QueryException {
        return new SelectSink(ctx, sink);
    }

    @Override
    public int outputWidth(int inputWidth) {
        return inputWidth;
    }

    private class SelectSink
    implements Sink {
        final QueryContext ctx;
        final Sink sink;

        public SelectSink(QueryContext ctx, Sink sink) {
            this.ctx = ctx;
            this.sink = sink;
        }

        @Override
        public void output(Tuple[] buf, int len) throws QueryException {
            int nlen = 0;
            for (int i = 0; i < len; ++i) {
                Tuple t = buf[i];
                buf[i] = null;
                Sequence p = Select.this.pred.evaluate(this.ctx, t);
                if (p == null || !p.booleanValue()) continue;
                buf[nlen++] = t;
            }
            if (nlen > 0) {
                this.sink.output(buf, nlen);
            }
        }

        @Override
        public Sink fork() {
            return new SelectSink(this.ctx, this.sink.fork());
        }

        @Override
        public Sink partition(Sink stopAt) {
            return new SelectSink(this.ctx, this.sink.partition(stopAt));
        }

        @Override
        public void end() throws QueryException {
            this.sink.end();
        }

        @Override
        public void begin() throws QueryException {
            this.sink.begin();
        }

        @Override
        public void fail() throws QueryException {
            this.sink.fail();
        }
    }
}

