/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.block.ChainedSink;
import java.util.Arrays;
import java.util.concurrent.Semaphore;

public abstract class SerialSink
extends ChainedSink {
    final Semaphore sem;
    Tuple[] pending;
    int pLen;
    int held;

    public SerialSink(int permits) {
        this.sem = permits >= 0 ? new Semaphore(permits) : null;
    }

    protected SerialSink(Semaphore sem) {
        this.sem = sem;
    }

    @Override
    protected abstract void doOutput(Tuple[] var1, int var2) throws QueryException;

    @Override
    protected void processPending() throws QueryException {
        this.doOutput(this.pending, this.pLen);
        this.pending = null;
    }

    @Override
    protected boolean hasPending() {
        return this.pending != null;
    }

    @Override
    protected void clearPending() {
        this.pending = null;
    }

    @Override
    protected boolean yield() {
        if (this.sem != null) {
            if (!this.sem.tryAcquire(this.pLen)) {
                this.held = this.pLen;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected void unyield() {
        if (this.sem != null) {
            int h = this.held;
            this.held = 0;
            this.sem.release(h);
        }
    }

    @Override
    protected void setPending(Tuple[] buf, int len) throws QueryException {
        if (this.pending == null) {
            this.pending = buf;
            this.pLen = len;
        } else {
            int newPLen = this.pLen + len;
            if (newPLen > this.pending.length) {
                this.pending = Arrays.copyOfRange(this.pending, 0, newPLen);
            }
            System.arraycopy(buf, 0, this.pending, this.pLen, len);
            this.pLen = newPLen;
        }
    }
}

