/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler;

import io.brackit.query.compiler.XQ;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.dot.DotContext;
import io.brackit.query.util.dot.DotNode;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AST {
    protected AST parent;
    protected int type;
    protected Object value;
    protected Map<String, Object> properties;
    protected StaticContext sctx;
    protected AST[] children;

    public AST(int type) {
        this(type, XQ.NAMES[type]);
    }

    protected AST(int type, Object value, StaticContext sctx, Map<String, Object> properties) {
        this.type = type;
        this.value = value;
        this.sctx = sctx;
        this.properties = properties;
    }

    public AST(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value != null ? this.value.toString() : "";
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    public boolean checkProperty(String name) {
        Object p;
        Object object = p = this.properties != null ? this.properties.get(name) : null;
        if (p == null) {
            return false;
        }
        return (Boolean)p;
    }

    public void delProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    public AST getParent() {
        return this.parent;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.length;
    }

    public int getChildIndex() {
        if (this.parent == null) {
            return -1;
        }
        int i = 0;
        for (AST ast : this.parent.children) {
            if (ast == this) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    public void addChildren(AST[] children) {
        for (AST child : children) {
            this.addChild(child);
        }
    }

    public void addChild(AST child) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (child == this) {
            throw new IllegalArgumentException();
        }
        if (this.children == null) {
            this.children = new AST[]{child};
        } else {
            this.children = Arrays.copyOf(this.children, this.children.length + 1);
            this.children[this.children.length - 1] = child;
        }
        child.parent = this;
    }

    public void insertChild(int position, AST child) {
        if (position < 0 || this.children == null || position > this.children.length) {
            throw new IllegalArgumentException(String.format("Illegal child position: %s", position));
        }
        if (child == null) {
            throw new NullPointerException();
        }
        if (child == this) {
            throw new IllegalArgumentException();
        }
        if (this.children == null) {
            this.children = new AST[]{child};
        } else if (position == this.children.length) {
            this.children = Arrays.copyOf(this.children, this.children.length + 1);
            this.children[this.children.length - 1] = child;
        } else {
            AST[] tmp = new AST[this.children.length + 1];
            if (position > 0) {
                System.arraycopy(this.children, 0, tmp, 0, position);
            }
            System.arraycopy(this.children, position, tmp, position + 1, this.children.length - position);
            tmp[position] = child;
            this.children = tmp;
        }
        child.parent = this;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public AST getChild(int position) {
        if (position < 0 || this.children == null || position >= this.children.length) {
            throw new IllegalArgumentException(String.format("Illegal child position: %s", position));
        }
        return this.children[position];
    }

    public AST getLastChild() {
        return this.children != null ? this.children[this.children.length - 1] : null;
    }

    public void replaceChild(int position, AST child) {
        if (position < 0 || this.children == null || position >= this.children.length) {
            throw new IllegalArgumentException(String.format("Illegal child position: %s", position));
        }
        if (child == null) {
            throw new NullPointerException();
        }
        this.children[position] = child;
        child.parent = this;
    }

    public void deleteChild(int position) {
        if (position < 0 || this.children == null || position >= this.children.length) {
            throw new IllegalArgumentException(String.format("Illegal child position: %s", position));
        }
        if (this.children.length == 1) {
            this.children = null;
        } else {
            AST[] tmp = new AST[this.children.length - 1];
            if (position > 0) {
                System.arraycopy(this.children, 0, tmp, 0, position);
            }
            int length = this.children.length - (position + 1);
            System.arraycopy(this.children, position + 1, tmp, position, length);
            this.children = tmp;
        }
    }

    public AST copy() {
        return new AST(this.type, this.value, this.sctx, (Map<String, Object>)(this.properties == null ? null : new HashMap<String, Object>(this.properties)));
    }

    public AST copyTree() {
        AST copy = this.copy();
        if (this.children != null) {
            copy.children = new AST[this.children.length];
            for (int i = 0; i < this.children.length; ++i) {
                copy.children[i] = this.children[i].copyTree();
                copy.children[i].parent = copy;
            }
        }
        return copy;
    }

    public String dot() {
        DotContext dt = new DotContext();
        this.toDot(0, dt);
        return dt.toDotString();
    }

    public void dot(File file) {
        DotContext dt = new DotContext();
        this.toDot(0, dt);
        dt.write(file);
    }

    private int toDot(int no, DotContext dt) {
        int myNo = no++;
        String label = this.getLabel(this.getStringValue());
        DotNode node = dt.addNode(String.valueOf(myNo));
        node.addRow(label, null);
        if (this.properties != null) {
            for (Map.Entry entry : this.properties.entrySet()) {
                Object value = entry.getValue();
                node.addRow((String)entry.getKey(), value != null ? value.toString() : "");
            }
        }
        if (this.children != null) {
            for (AST child : this.children) {
                dt.addEdge(String.valueOf(myNo), String.valueOf(no));
                no = child.toDot(no, dt);
            }
        }
        return no;
    }

    protected String getLabel(String value) {
        return this.type > 0 && this.type < XQ.NAMES.length ? (XQ.NAMES[this.type].equals(value) ? value : XQ.NAMES[this.type] + "[" + value + "]") : value;
    }

    public AST getFirstChildWithType(int type) {
        if (this.children == null) {
            return null;
        }
        for (AST child : this.children) {
            if (child.type != type) continue;
            return child;
        }
        return null;
    }

    public void setStaticContext(StaticContext sctx) {
        this.sctx = sctx;
    }

    public StaticContext getStaticContext() {
        AST n = this;
        while (n != null) {
            if (n.sctx != null) {
                return n.sctx;
            }
            n = n.parent;
        }
        return null;
    }

    public void display() {
        try {
            File file = File.createTempFile("ast", ".dot");
            file.deleteOnExit();
            this.dot(file);
            Runtime.getRuntime().exec(new String[]{"/usr/bin/dotty", file.getAbsolutePath()}).waitFor();
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        String value = this.getStringValue();
        return this.getLabel(value);
    }
}

