/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.analyzer;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.ModuleResolver;
import io.brackit.query.compiler.Target;
import io.brackit.query.compiler.Unit;
import io.brackit.query.compiler.analyzer.BodyDecl;
import io.brackit.query.compiler.analyzer.CtxItemDecl;
import io.brackit.query.compiler.analyzer.ForwardDeclaration;
import io.brackit.query.compiler.analyzer.PrologAnalyzer;
import io.brackit.query.compiler.analyzer.VariableDecl;
import io.brackit.query.compiler.parser.XQParser;
import io.brackit.query.expr.Variable;
import io.brackit.query.jdm.Function;
import io.brackit.query.module.Functions;
import io.brackit.query.module.LibraryModule;
import io.brackit.query.module.MainModule;
import io.brackit.query.module.Module;
import io.brackit.query.module.StaticContext;
import io.brackit.query.module.Variables;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Analyzer {
    private final ModuleResolver resolver;
    private final AnyURI baseURI;
    private final List<Target> targets;
    private final List<ForwardDeclaration> decls;
    private final List<Module> modules;
    private final AST ast;

    public Analyzer(ModuleResolver resolver, AnyURI baseURI, AST ast) throws QueryException {
        this.resolver = resolver;
        this.baseURI = baseURI;
        this.decls = new ArrayList<ForwardDeclaration>();
        this.modules = new ArrayList<Module>();
        this.targets = new ArrayList<Target>();
        this.ast = ast;
        this.analyze();
    }

    public AST getAST() {
        return this.ast;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    protected void analyze() throws QueryException {
        this.module(this.ast.getChild(0));
        for (ForwardDeclaration decl : this.decls) {
            this.targets.add(decl.process());
        }
        for (ForwardDeclaration decl : this.decls) {
            if (decl instanceof CtxItemDecl && this.checkCycle(decl, this.decls)) {
                throw new QueryException(ErrorCode.ERR_CIRCULAR_CONTEXT_ITEM_INITIALIZER, "Context item declaration depends on context item");
            }
            if (!(decl instanceof VariableDecl) || !this.checkCycle(decl, this.decls)) continue;
            throw new QueryException(ErrorCode.ERR_CIRCULAR_VARIABLE_DEPENDENCY, "Cyclic variable declaration: %s", decl.getUnit());
        }
    }

    private boolean checkCycle(ForwardDeclaration decl, List<ForwardDeclaration> decls) {
        Unit unit;
        HashSet<Unit> expanded = new HashSet<Unit>();
        ArrayDeque<Unit> pending = new ArrayDeque<Unit>();
        for (Unit dep : decl.dependsOn()) {
            if (dep == decl.getUnit()) {
                return true;
            }
            expanded.add(dep);
            pending.add(dep);
        }
        block1: while ((unit = (Unit)pending.poll()) != null) {
            for (ForwardDeclaration d : decls) {
                if (d.getUnit() != unit) continue;
                for (Unit dep : d.dependsOn()) {
                    if (dep == decl.getUnit()) {
                        return true;
                    }
                    if (!expanded.add(dep)) continue;
                    pending.add(dep);
                }
                continue block1;
            }
        }
        return false;
    }

    protected Module module(AST module) throws QueryException {
        if (module.getType() == 1) {
            return this.libraryModule(module);
        }
        return this.mainModule(module);
    }

    protected Module libraryModule(AST module) throws QueryException {
        LibraryModule lm = new LibraryModule();
        StaticContext sctx = lm.getStaticContext();
        sctx.setBaseURI(this.baseURI);
        module.setStaticContext(sctx);
        AST ns = module.getChild(0);
        String prefix = ns.getChild(0).getStringValue();
        String uri = ns.getChild(1).getStringValue();
        lm.setTargetNS(uri);
        sctx.getNamespaces().declare(prefix, uri);
        this.modules.add(lm);
        if (module.getChildCount() == 2) {
            PrologAnalyzer pa = new PrologAnalyzer(lm, module.getChild(1));
            this.decls.addAll(pa.getDeclarations());
            this.handleImports(lm, pa.getImports());
        }
        return lm;
    }

    protected Module mainModule(AST module) throws QueryException {
        MainModule mm = new MainModule();
        StaticContext sctx = mm.getStaticContext();
        sctx.setBaseURI(this.baseURI);
        module.setStaticContext(sctx);
        AST prologOrBody = module.getChild(0);
        this.modules.add(mm);
        if (prologOrBody.getType() == 3) {
            PrologAnalyzer pa = new PrologAnalyzer(mm, prologOrBody);
            this.decls.addAll(pa.getDeclarations());
            this.handleImports(mm, pa.getImports());
            prologOrBody = module.getChild(1);
        }
        this.decls.add(new BodyDecl(mm, prologOrBody.getChild(0)));
        return mm;
    }

    private void handleImports(Module module, List<PrologAnalyzer.Import> imports) throws QueryException {
        for (PrologAnalyzer.Import i : imports) {
            List<Module> toImport = this.findModules(i);
            Variables lvars = module.getVariables();
            Functions lfuns = module.getStaticContext().getFunctions();
            for (Module m : toImport) {
                Variables ivars = m.getVariables();
                Functions ifuns = m.getStaticContext().getFunctions();
                this.checkImports(lvars, ivars, lfuns, ifuns);
                lvars.importVariables(ivars);
                lfuns.importFunctions(ifuns);
                module.importModule(m);
            }
        }
    }

    private List<Module> findModules(PrologAnalyzer.Import i) throws QueryException {
        ArrayList<Module> toImport = new ArrayList<Module>(this.resolver.resolve(i.getURI(), i.getLocations()));
        for (Module inFlight : this.modules) {
            String targetNS = inFlight.getTargetNS();
            if (targetNS == null || !targetNS.equals(i.getURI())) continue;
            toImport.add(inFlight);
        }
        if (toImport.isEmpty()) {
            List<String> loaded;
            try {
                loaded = this.resolver.load(i.getURI(), i.getLocations());
                if (loaded.isEmpty()) {
                    throw new QueryException(ErrorCode.ERR_SCHEMA_OR_MODULE_NOT_FOUND, "Module '%s' not found", i.getURI());
                }
            }
            catch (IOException e) {
                throw new QueryException(e, ErrorCode.ERR_SCHEMA_OR_MODULE_NOT_FOUND, "Error loading module '%s'", i.getURI());
            }
            for (String query : loaded) {
                AST ast = new XQParser(query).parse();
                toImport.add(this.module(ast.getChild(0)));
            }
        }
        return toImport;
    }

    private void checkImports(Variables lvars, Variables ivars, Functions lfuns, Functions ifuns) throws QueryException {
        for (Variable ivar : ivars.getDeclaredVariables()) {
            if (!lvars.isDeclared(ivar.getName())) continue;
            throw new QueryException(ErrorCode.ERR_DUPLICATE_VARIABLE_DECL, "Import variable $%s has already been declared", ivar.getName());
        }
        Map<QNm, Function[]> ifunMap = ifuns.getDeclaredFunctions();
        for (Map.Entry<QNm, Function[]> ifun : ifunMap.entrySet()) {
            Function[] ifu;
            QNm name = ifun.getKey();
            for (Function function : ifu = ifun.getValue()) {
                int argc = function.getSignature().getParams().length;
                if (lfuns.resolve(name, argc) == null) continue;
                throw new QueryException(ErrorCode.ERR_MULTIPLE_FUNCTION_DECLARATIONS, "Found multiple declarations of function %s", function.getName());
            }
        }
    }
}

