/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer;

import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.optimizer.Optimizer;
import io.brackit.query.compiler.optimizer.Stage;
import io.brackit.query.compiler.optimizer.walker.DoSNStepMerger;
import io.brackit.query.compiler.optimizer.walker.OrderForGroupBy;
import io.brackit.query.compiler.optimizer.walker.PathDDOElimination;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.Cfg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultOptimizer
implements Optimizer {
    public static final QNm SEQUENTIAL_GROUPBY = new QNm("http://brackit.org/ns/bit", "bit", "sequential-groupby");
    public static final String JOIN_DETECTION_CFG = "org.brackit.xquery.joinDetection";
    public static final String UNNEST_CFG = "org.brackit.xquery.unnest";
    public static boolean UNNEST = Cfg.asBool("org.brackit.xquery.unnest", true);
    public static boolean JOIN_DETECTION = Cfg.asBool("org.brackit.xquery.joinDetection", true);
    protected final List<Stage> stages;
    protected final Map<QNm, Str> options;

    public DefaultOptimizer(Map<QNm, Str> options) {
        this.stages = new ArrayList<Stage>();
        this.stages.add(new Simplification());
        this.stages.add(new Finalize());
        this.options = options;
    }

    protected DefaultOptimizer(Map<QNm, Str> options, List<Stage> stages) {
        this.stages = stages;
        this.options = options;
    }

    @Override
    public List<Stage> getStages() {
        return this.stages;
    }

    @Override
    public AST optimize(StaticContext sctx, AST ast) {
        for (Stage stage : this.stages) {
            ast = stage.rewrite(sctx, ast);
        }
        return ast;
    }

    protected boolean enabled(QNm option) {
        Str opt = this.options.get(option);
        return opt != null && Boolean.parseBoolean(opt.stringValue());
    }

    protected class Simplification
    implements Stage {
        protected Simplification() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) {
            ast = new DoSNStepMerger().walk(ast);
            if (DefaultOptimizer.this.enabled(SEQUENTIAL_GROUPBY)) {
                ast = new OrderForGroupBy().walk(ast);
            }
            return ast;
        }
    }

    protected static class Finalize
    implements Stage {
        protected Finalize() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) {
            ast = new PathDDOElimination(sctx).walk(ast);
            return ast;
        }
    }
}

