/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.optimizer.DefaultOptimizer;
import io.brackit.query.compiler.optimizer.Stage;
import io.brackit.query.compiler.optimizer.walker.topdown.GroupByAggregates;
import io.brackit.query.compiler.optimizer.walker.topdown.JoinGroupDemarcation;
import io.brackit.query.compiler.optimizer.walker.topdown.JoinRewriter;
import io.brackit.query.compiler.optimizer.walker.topdown.JoinToSelectConversion;
import io.brackit.query.compiler.optimizer.walker.topdown.LeftJoinLifting;
import io.brackit.query.compiler.optimizer.walker.topdown.LeftJoinRemoval;
import io.brackit.query.compiler.optimizer.walker.topdown.LeftJoinUnnesting;
import io.brackit.query.compiler.optimizer.walker.topdown.LetBindToLeftJoin;
import io.brackit.query.compiler.optimizer.walker.topdown.PredicateMerge;
import io.brackit.query.compiler.optimizer.walker.topdown.PredicateSplit;
import io.brackit.query.compiler.optimizer.walker.topdown.PullEvaluation;
import io.brackit.query.compiler.optimizer.walker.topdown.SelectPullup;
import io.brackit.query.compiler.optimizer.walker.topdown.TopDownPipeline;
import io.brackit.query.compiler.optimizer.walker.topdown.TrivialLeftJoinRemoval;
import io.brackit.query.module.StaticContext;
import java.util.ArrayList;
import java.util.Map;

public class TopDownOptimizer
extends DefaultOptimizer {
    public TopDownOptimizer(Map<QNm, Str> options) {
        super(options, new ArrayList<Stage>());
        this.stages.add(new DefaultOptimizer.Simplification());
        this.stages.add(new Pipelining());
        this.stages.add(new Reordering());
        if (JOIN_DETECTION) {
            this.stages.add(new JoinRecognition());
        }
        if (UNNEST) {
            this.stages.add(new Unnest());
        }
        this.stages.add(new FinalizePipeline());
        this.stages.add(new DefaultOptimizer.Finalize());
    }

    private static class Pipelining
    implements Stage {
        private Pipelining() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new TopDownPipeline().walk(ast);
            return ast;
        }
    }

    private static class Reordering
    implements Stage {
        private Reordering() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new PredicateSplit().walk(ast);
            ast = new SelectPullup().walk(ast);
            return ast;
        }
    }

    private static class JoinRecognition
    implements Stage {
        private JoinRecognition() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new JoinRewriter(sctx).walk(ast);
            return ast;
        }
    }

    private static class Unnest
    implements Stage {
        private Unnest() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new LetBindToLeftJoin().walk(ast);
            ast = new LeftJoinLifting().walk(ast);
            ast = new LeftJoinRemoval().walk(ast);
            ast = new LeftJoinUnnesting().walk(ast);
            ast = new JoinToSelectConversion().walk(ast);
            return ast;
        }
    }

    private static class FinalizePipeline
    implements Stage {
        private FinalizePipeline() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new PredicateMerge().walk(ast);
            ast = new TrivialLeftJoinRemoval().walk(ast);
            ast = new GroupByAggregates().walk(ast);
            ast = new JoinGroupDemarcation().walk(ast);
            ast = new PullEvaluation().walk(ast);
            return ast;
        }
    }
}

