/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer.walker.topdown;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.CompileChain;
import io.brackit.query.compiler.optimizer.DefaultOptimizer;
import io.brackit.query.compiler.optimizer.Optimizer;
import io.brackit.query.compiler.optimizer.TopDownOptimizer;
import io.brackit.query.compiler.optimizer.walker.topdown.AggFunChecker;
import io.brackit.query.compiler.optimizer.walker.topdown.ScopeWalker;
import java.util.Map;

public final class GroupByAggregates
extends AggFunChecker {
    @Override
    protected AST visit(AST node) {
        if (node.getType() != 233) {
            return node;
        }
        AST dftAgg = node.getChild(node.getChildCount() - 2);
        AST dftAggType = dftAgg.getChild(0);
        if (dftAggType.getType() != 19) {
            return node;
        }
        dftAgg.replaceChild(0, new AST(25));
        for (ScopeWalker.Var var : this.findScope(node).localBindings()) {
            ScopeWalker.VarRef refs;
            AST aggSpec = this.findAggSpec(node, var);
            if (aggSpec == null) {
                aggSpec = this.addAggSpec(node, var);
            }
            if ((refs = this.findVarRefs(var, node.getLastChild())) == null) continue;
            this.introduceAggBindings(aggSpec, var, refs);
        }
        this.snapshot();
        return node;
    }

    private AST addAggSpec(AST node, ScopeWalker.Var var) {
        AST aggSpec = new AST(16);
        aggSpec.addChild(new AST(26, var.var));
        node.insertChild(node.getChildCount() - 2, aggSpec);
        return aggSpec;
    }

    private AST findAggSpec(AST node, ScopeWalker.Var var) {
        for (int i = 0; i < node.getChildCount() - 2; ++i) {
            AST aggSpec = node.getChild(i);
            QNm aggVar = (QNm)aggSpec.getChild(0).getValue();
            if (aggVar.atomicCmp(var.var) != 0) continue;
            return aggSpec;
        }
        return null;
    }

    private void introduceAggBindings(AST aggSpec, ScopeWalker.Var var, ScopeWalker.VarRef refs) {
        QNm seqAggVar = null;
        QNm[] aggFunVars = new QNm[aggFuns.length];
        for (int i = 1; i < aggSpec.getChildCount(); ++i) {
            AST binding = aggSpec.getChild(i);
            QNm name = (QNm)binding.getChild(0).getChild(0).getValue();
            int type = binding.getChild(1).getType();
            if (type == 19) {
                seqAggVar = name;
                continue;
            }
            int aggFunType = this.aggFunType(type);
            aggFunVars[aggFunType] = name;
        }
        ScopeWalker.VarRef ref = refs;
        while (ref != null) {
            AST p = ref.ref.getParent();
            boolean isAggFun = false;
            if (p.getType() == 80) {
                QNm fun = (QNm)p.getValue();
                for (int i = 0; i < aggFuns.length; ++i) {
                    QNm aggFun = aggFuns[i];
                    if (fun.atomicCmp(aggFun) != 0) continue;
                    if (aggFunVars[i] == null) {
                        QNm subsitute;
                        aggFunVars[i] = subsitute = new QNm("http://brackit.org/ns/bit", null, aggFun.getLocalName() + ";" + var.var.getLocalName());
                        AST agg = this.createBinding(subsitute, aggFunMap[i]);
                        aggSpec.addChild(agg);
                    }
                    this.replaceRef(p, aggFunVars[i]);
                    isAggFun = true;
                    break;
                }
            }
            if (!isAggFun) {
                if (seqAggVar == null) {
                    seqAggVar = var.var;
                    AST agg = this.createBinding(var.var, 19);
                    aggSpec.addChild(agg);
                }
                this.replaceRef(ref.ref, seqAggVar);
            }
            ref = ref.next;
        }
    }

    private AST createBinding(QNm subsitute, int type) {
        AST agg = new AST(18);
        AST binding = new AST(10);
        binding.addChild(new AST(11, subsitute));
        agg.addChild(binding);
        agg.addChild(new AST(type));
        return agg;
    }

    public static void main(String[] args) throws QueryException {
        DefaultOptimizer.UNNEST = false;
        CompileChain cc = new CompileChain(){

            @Override
            protected Optimizer getOptimizer(Map<QNm, Str> options) {
                return new TopDownOptimizer(options){
                    {
                        super(options);
                        this.stages.add(this.stages.size() - 2, (sctx, ast) -> new GroupByAggregates().walk(ast));
                    }
                };
            }
        };
        Query xq = new Query(cc, "let $x:= 1 let $y:= (for $a in (1 to 10) for $b in ($a to $a + 2) group by $b let $c := if ($x eq 1) then $b else () return <r b='{$c}' cnt='{count($a)}' vals='{$a}'/>) return $y");
        xq.prettyPrint();
        xq.serialize((QueryContext)new BrackitQueryContext(), System.out);
    }
}

