/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer.walker.topdown;

import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.optimizer.walker.topdown.AggFunChecker;
import io.brackit.query.compiler.optimizer.walker.topdown.ScopeWalker;
import io.brackit.query.util.Cmp;

public class LetBindToLeftJoin
extends AggFunChecker {
    @Override
    protected AST visit(AST node) {
        if (node.getType() != 239) {
            return node;
        }
        AST bindingExpr = node.getChild(1);
        if (bindingExpr.getType() != 231) {
            return node;
        }
        return this.convertToLeftJoin(node);
    }

    private AST convertToLeftJoin(AST let) {
        boolean skipSort;
        AST rightIn;
        AST insertJoinAfter = let.getParent();
        AST leftIn = new AST(237);
        AST lend = new AST(241);
        lend.addChild(new AST(123, Bool.TRUE));
        leftIn.addChild(lend);
        AST righInEnd = rightIn = let.getChild(1).getChild(0).copyTree();
        while (righInEnd.getType() != 241) {
            righInEnd = righInEnd.getLastChild();
        }
        AST letReturn = righInEnd.getChild(0).copyTree();
        righInEnd.replaceChild(0, new AST(123, Bool.TRUE));
        AST post = new AST(237);
        AST letVarBinding = let.getChild(0).copyTree();
        AST rlet = new AST(239);
        rlet.addChild(letVarBinding);
        rlet.addChild(letReturn);
        QNm letVar = (QNm)letVarBinding.getChild(0).getValue();
        AST groupBy = this.createGroupBy(letVar, let);
        rlet.addChild(groupBy);
        post.addChild(rlet);
        AST ljoin = this.createJoin(leftIn, rightIn, post, let.getLastChild().copyTree());
        boolean bl = skipSort = groupBy.getChild(1).getChild(0).getType() != 19;
        if (skipSort) {
            ljoin.setProperty("skipSort", Boolean.TRUE);
        }
        int replaceAt = insertJoinAfter.getChildCount() - 1;
        insertJoinAfter.replaceChild(replaceAt, ljoin);
        this.snapshot();
        this.refreshScopes(insertJoinAfter, true);
        return insertJoinAfter;
    }

    private AST createJoin(AST leftIn, AST rightIn, AST post, AST out) {
        AST ljoin = new AST(235);
        ljoin.setProperty("leftJoin", Boolean.TRUE);
        ljoin.setProperty("cmp", (Object)Cmp.eq);
        ljoin.setProperty("GCmp", false);
        ljoin.addChild(leftIn);
        ljoin.addChild(rightIn);
        ljoin.addChild(post);
        ljoin.addChild(out);
        return ljoin;
    }

    private AST createGroupBy(QNm letVar, AST letBind) {
        AST p;
        int aggType = 19;
        ScopeWalker.Var var = this.findScope(letBind).localBindings().get(0);
        ScopeWalker.VarRef refs = this.findVarRefs(var, letBind.getLastChild());
        if (refs != null && refs.next == null && (p = refs.ref.getParent()).getType() == 80) {
            QNm fun = (QNm)p.getValue();
            for (int i = 0; i < aggFuns.length; ++i) {
                QNm aggFun = aggFuns[i];
                if (fun.atomicCmp(aggFun) != 0) continue;
                this.replaceRef(p, letVar);
                aggType = aggFunMap[i];
                break;
            }
        }
        AST groupBy = new AST(233);
        groupBy.setProperty("sequential", Boolean.TRUE);
        AST aggSpec = new AST(16);
        aggSpec.addChild(new AST(26, letVar));
        aggSpec.addChild(this.createBinding(letVar, aggType));
        groupBy.addChild(aggSpec);
        AST dftAgg = new AST(17);
        dftAgg.addChild(new AST(25));
        groupBy.addChild(dftAgg);
        groupBy.addChild(new AST(241));
        return groupBy;
    }

    private AST createBinding(QNm name, int type) {
        AST agg = new AST(18);
        AST binding = new AST(10);
        binding.addChild(new AST(11, name));
        agg.addChild(binding);
        agg.addChild(new AST(type));
        return agg;
    }
}

