/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer.walker.topdown;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.Bits;
import io.brackit.query.compiler.optimizer.walker.Walker;
import io.brackit.query.jdm.type.AnyItemType;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.DocumentType;
import io.brackit.query.jdm.type.ElementType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.dot.DotContext;
import io.brackit.query.util.dot.DotNode;
import io.brackit.query.util.dot.DotUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ScopeWalker
extends Walker {
    protected static SequenceType ONE_INTEGER = new SequenceType(AtomicType.INR, Cardinality.One);
    protected static SequenceType ONE_ITEM = new SequenceType(AnyItemType.ANY, Cardinality.One);
    protected static SequenceType ITEMS = new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany);
    private BindingTable table;
    private int dotCount;

    public ScopeWalker() {
    }

    public ScopeWalker(StaticContext sctx) {
        super(sctx);
    }

    @Override
    protected AST prepare(AST root) {
        this.table = new BindingTable(root);
        this.walkInspect(root, true, false);
        if (Query.DEBUG) {
            DotUtil.drawDotToFile(this.table.rootScope.dot(), Query.DEBUG_DIR, this.getClass().getSimpleName() + "_scopes_" + this.dotCount++);
        }
        return super.prepare(root);
    }

    protected final void refreshScopes(AST node, boolean pipeline) {
        Scope s = this.findScope(node);
        if (s.node.getType() == 237 && s.node.getParent().getType() == 235) {
            s = s.parent;
        }
        this.table.reset(s);
        if (Query.DEBUG) {
            DotUtil.drawDotToFile(this.table.rootScope.dot(), Query.DEBUG_DIR, this.getClass().getSimpleName() + "_scopes_" + this.dotCount + "reset");
        }
        this.walkInspect(s.node, false, false);
        if (Query.DEBUG) {
            DotUtil.drawDotToFile(this.table.rootScope.dot(), Query.DEBUG_DIR, this.getClass().getSimpleName() + "_scopes_" + this.dotCount++);
        }
    }

    protected Set<AST> getScopes() {
        return this.table.getScopes();
    }

    private void walkInspect(AST node, boolean newScope, boolean bindOnly) {
        if (this.inspect(node, newScope, bindOnly)) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                AST child = node.getChild(i);
                this.walkInspect(child, newScope, bindOnly);
            }
        }
    }

    private boolean inspect(AST node, boolean newScope, boolean bindOnly) {
        switch (node.getType()) {
            case 134: {
                this.typeswitchExpr(node);
                return false;
            }
            case 130: {
                this.quantifiedExpr(node);
                return false;
            }
            case 229: {
                this.transformExpr(node);
                return false;
            }
            case 137: {
                this.tryCatchExpr(node);
                return false;
            }
            case 206: {
                this.filterExpr(node);
                return false;
            }
            case 81: {
                this.pathExpr(node);
                return false;
            }
            case 83: {
                this.stepExpr(node);
                return false;
            }
            case 158: {
                this.documentExpr(node);
                return false;
            }
            case 149: 
            case 154: {
                this.elementExpr(node);
                return false;
            }
            case 231: {
                this.pipeExpr(node);
                return false;
            }
            case 237: {
                this.start(node, newScope, bindOnly);
                return false;
            }
            case 238: {
                this.forBind(node, newScope, bindOnly);
                return false;
            }
            case 239: {
                this.letBind(node, newScope, bindOnly);
                return false;
            }
            case 232: {
                this.select(node, newScope, bindOnly);
                return false;
            }
            case 234: {
                this.orderBy(node, newScope, bindOnly);
                return false;
            }
            case 235: {
                this.join(node, newScope, bindOnly);
                return false;
            }
            case 233: {
                this.groupBy(node, newScope, bindOnly);
                return false;
            }
            case 240: {
                this.count(node, newScope, bindOnly);
                return false;
            }
            case 241: {
                this.end(node, newScope, bindOnly);
                return false;
            }
        }
        return true;
    }

    private void pipeExpr(AST node) {
        this.table.openScope(node, false);
        this.walkInspect(node.getChild(0), true, false);
        this.table.closeScope();
    }

    protected final Scope findScope(AST node) {
        AST tmp = node;
        do {
            Scope s;
            if ((s = this.table.scopemap.get(tmp)) == null) continue;
            return s;
        } while ((tmp = tmp.getParent()) != null);
        return this.table.rootScope;
    }

    protected final VarRef findVarRefs(AST node) {
        return this.findVarRefs(null, node);
    }

    protected final VarRef findVarRefs(Var toVar, AST node) {
        if (node.getType() == 26) {
            QNm name = (QNm)node.getValue();
            if (toVar != null && name.atomicCmp(toVar.var) != 0) {
                return null;
            }
            Scope s = this.findScope(node);
            Var var = s.resolve(name);
            if (var == null) {
                return null;
            }
            if (toVar != null && toVar != var) {
                return null;
            }
            return new VarRef(var, node, s);
        }
        VarRef varRefs = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            AST child = node.getChild(i);
            VarRef tmp = this.findVarRefs(toVar, child);
            if (tmp == null) continue;
            if (varRefs == null) {
                varRefs = tmp;
                continue;
            }
            VarRef p = varRefs;
            while (p.next != null) {
                p = p.next;
            }
            p.next = tmp;
        }
        return varRefs;
    }

    private void forBind(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        QNm forVar = (QNm)node.getChild(0).getChild(0).getValue();
        QNm posVar = null;
        AST posBindingOrSourceExpr = node.getChild(1);
        if (posBindingOrSourceExpr.getType() == 10) {
            posVar = (QNm)posBindingOrSourceExpr.getChild(0).getValue();
            posBindingOrSourceExpr = node.getChild(2);
        }
        if (!bindOnly) {
            this.walkInspect(posBindingOrSourceExpr, true, false);
        }
        this.table.bind(forVar, ONE_ITEM);
        if (posVar != null) {
            this.table.bind(posVar, ONE_INTEGER);
        }
        if (!bindOnly) {
            this.walkInspect(node.getLastChild(), true, bindOnly);
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private void letBind(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        QNm letVar = (QNm)node.getChild(0).getChild(0).getValue();
        if (!bindOnly) {
            this.walkInspect(node.getChild(1), true, false);
        }
        this.table.bind(letVar, ITEMS);
        if (!bindOnly) {
            this.walkInspect(node.getLastChild(), true, bindOnly);
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private void select(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        if (!bindOnly) {
            this.walkInspect(node.getChild(0), true, false);
        }
        if (!bindOnly) {
            this.walkInspect(node.getLastChild(), true, bindOnly);
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private void groupBy(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        int pos = 0;
        HashSet<QNm> groupVars = new HashSet<QNm>();
        while (node.getChild(pos).getType() == 15) {
            AST varRef = node.getChild(pos).getChild(0);
            if (!bindOnly) {
                this.walkInspect(varRef, true, bindOnly);
            }
            groupVars.add((QNm)varRef.getValue());
            ++pos;
        }
        AST dftAgg = node.getChild(node.getChildCount() - 2);
        AST dftAggType = dftAgg.getChild(0);
        if (dftAggType.getType() != 25) {
            for (Var var : this.table.inPipelineBindings()) {
                if (groupVars.contains(var.var)) continue;
                this.table.bind(var.var, new SequenceType(var.type.getItemType(), Cardinality.ZeroOrMany));
            }
        }
        while (node.getChild(pos).getType() == 16) {
            AST aggSpec = node.getChild(pos);
            for (int i = 1; i < aggSpec.getChildCount(); ++i) {
                AST aggBnd = aggSpec.getChild(i);
                AST typedVar = aggBnd.getChild(0);
                QNm aggVar = (QNm)typedVar.getChild(0).getValue();
                SequenceType aggVarType = ONE_ITEM;
                this.table.bind(aggVar, aggVarType);
            }
            ++pos;
        }
        if (!bindOnly) {
            this.walkInspect(node.getLastChild(), true, bindOnly);
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private void orderBy(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        int orderBySpecCount = node.getChildCount() - 1;
        for (int i = 0; i < orderBySpecCount; ++i) {
            AST orderBy = node.getChild(i);
            this.walkInspect(orderBy.getChild(0), true, false);
        }
        if (!bindOnly) {
            this.walkInspect(node.getLastChild(), true, bindOnly);
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private void count(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        QNm countVar = (QNm)node.getChild(0).getChild(0).getValue();
        this.table.bind(countVar, ONE_INTEGER);
        if (!bindOnly) {
            this.walkInspect(node.getLastChild(), true, bindOnly);
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private void start(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        if (!bindOnly) {
            this.walkInspect(node.getLastChild(), true, bindOnly);
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private void end(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        if (!bindOnly && node.getChildCount() != 0) {
            this.walkInspect(node.getLastChild(), true, bindOnly);
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private void join(AST node, boolean newScope, boolean bindOnly) {
        if (newScope) {
            this.table.openScope(node, true);
        }
        List<Var> leftInBinding = this.getPipelineBindings(node.getChild(0));
        List<Var> rightInBinding = this.getPipelineBindings(node.getChild(1));
        List<Var> postBinding = this.getPipelineBindings(node.getChild(2));
        if (!bindOnly) {
            this.walkInspect(node.getChild(0), true, false);
            this.walkInspect(node.getChild(1), true, false);
        }
        if (!bindOnly) {
            AST postStart = node.getChild(2);
            this.table.openScope(postStart, true);
            for (Var var : leftInBinding) {
                this.table.bind(var.var, var.type);
            }
            for (Var var : rightInBinding) {
                this.table.bind(var.var, var.type);
            }
            this.walkInspect(postStart.getChild(0), true, bindOnly);
            this.table.closeScope();
            for (Var var : leftInBinding) {
                this.table.bind(var.var, var.type);
            }
            for (Var var : rightInBinding) {
                this.table.bind(var.var, var.type);
            }
            for (Var var : postBinding) {
                this.table.bind(var.var, var.type);
            }
            this.walkInspect(node.getChild(3), true, bindOnly);
        } else {
            for (Var var : leftInBinding) {
                this.table.bind(var.var, var.type);
            }
            for (Var var : rightInBinding) {
                this.table.bind(var.var, var.type);
            }
            for (Var var : postBinding) {
                this.table.bind(var.var, var.type);
            }
        }
        if (newScope) {
            this.table.closeScope();
        }
    }

    private List<Var> getPipelineBindings(AST input) {
        this.table.openScope(input, true);
        AST node = input;
        while (node.getType() != 241) {
            switch (node.getType()) {
                case 237: {
                    break;
                }
                case 238: {
                    this.forBind(node, false, true);
                    break;
                }
                case 239: {
                    this.letBind(node, false, true);
                    break;
                }
                case 232: {
                    this.select(node, false, true);
                    break;
                }
                case 234: {
                    this.orderBy(node, false, true);
                    break;
                }
                case 235: {
                    this.join(node, false, true);
                    break;
                }
                case 233: {
                    this.groupBy(node, false, true);
                    break;
                }
                case 240: {
                    this.count(node, false, true);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            node = node.getLastChild();
        }
        List<Var> bindings = this.table.inScopeBindings();
        this.table.dropScope();
        return bindings;
    }

    private void typeswitchExpr(AST expr) {
        this.walkInspect(expr.getChild(0), true, false);
        this.table.openScope(expr, false);
        for (int i = 1; i < expr.getChildCount(); ++i) {
            this.caseClause(expr.getChild(i));
        }
        this.table.closeScope();
    }

    private void caseClause(AST clause) {
        this.table.openScope(clause, false);
        AST varOrType = clause.getChild(0);
        if (varOrType.getType() == 11) {
            QNm name = (QNm)varOrType.getValue();
            this.table.bind(name, ITEMS);
        }
        this.walkInspect(clause.getChild(clause.getChildCount() - 1), true, false);
        this.table.closeScope();
    }

    private void quantifiedExpr(AST expr) {
        this.table.openScope(expr, false);
        for (int i = 1; i < expr.getChildCount() - 1; ++i) {
            this.table.openScope(expr.getChild(i), false);
            this.walkInspect(expr.getChild(i).getChild(1), true, false);
            QNm name = (QNm)expr.getChild(i).getChild(0).getChild(0).getValue();
            this.table.bind(name, ONE_ITEM);
            this.table.promoteBindings();
            this.table.closeScope();
        }
        this.table.closeScope();
    }

    private void transformExpr(AST expr) {
        this.table.openScope(expr, false);
        int pos = 0;
        while (pos < expr.getChildCount() - 2) {
            AST binding = expr.getChild(pos++);
            this.table.openScope(binding, false);
            QNm name = (QNm)binding.getChild(0).getValue();
            this.table.bind(name, ITEMS);
            this.walkInspect(binding.getChild(1), true, false);
            this.table.promoteBindings();
            this.table.closeScope();
        }
        AST modify = expr.getChild(pos++);
        this.walkInspect(modify, true, false);
        this.walkInspect(expr.getChild(pos), true, false);
        this.table.closeScope();
    }

    private void tryCatchExpr(AST expr) {
        int i;
        this.walkInspect(expr.getChild(0), true, false);
        this.table.openScope(expr, false);
        for (i = 1; i < 7; ++i) {
            this.table.bind((QNm)expr.getChild(i).getChild(0).getValue(), ONE_ITEM);
        }
        for (i = 7; i < expr.getChildCount(); ++i) {
            this.walkInspect(expr.getChild(i).getChild(0), true, false);
        }
        this.table.closeScope();
    }

    private void filterExpr(AST expr) {
        this.walkInspect(expr.getChild(0), true, false);
        for (int i = 1; i < expr.getChildCount(); ++i) {
            this.table.openScope(expr.getChild(i), false);
            this.table.bind(Bits.FS_DOT, ONE_ITEM);
            this.table.bind(Bits.FS_POSITION, ONE_INTEGER);
            this.table.bind(Bits.FS_LAST, ONE_INTEGER);
            this.walkInspect(expr.getChild(i), true, false);
            this.table.closeScope();
        }
    }

    private void stepExpr(AST expr) {
        this.walkInspect(expr.getChild(0), true, false);
        this.walkInspect(expr.getChild(1), true, false);
        for (int i = 2; i < expr.getChildCount(); ++i) {
            this.table.openScope(expr.getChild(i), false);
            this.table.bind(Bits.FS_DOT, ONE_ITEM);
            this.table.bind(Bits.FS_POSITION, ONE_INTEGER);
            this.table.bind(Bits.FS_LAST, ONE_INTEGER);
            this.walkInspect(expr.getChild(i), true, false);
            this.table.closeScope();
        }
    }

    private void pathExpr(AST expr) {
        this.table.openScope(expr, false);
        for (int i = 0; i < expr.getChildCount(); ++i) {
            this.table.openScope(expr.getChild(i), false);
            if (i > 0) {
                this.table.bind(Bits.FS_DOT, ONE_ITEM);
                this.table.bind(Bits.FS_POSITION, ONE_INTEGER);
                this.table.bind(Bits.FS_LAST, ONE_INTEGER);
            }
            this.walkInspect(expr.getChild(i), true, false);
            this.table.closeScope();
        }
        this.table.closeScope();
    }

    private void documentExpr(AST node) {
        this.table.openScope(node, false);
        this.table.bind(Bits.FS_PARENT, new SequenceType(DocumentType.DOC, Cardinality.One));
        if (node.getChildCount() > 0) {
            this.walkInspect(node.getChild(0), true, false);
        }
        this.table.closeScope();
    }

    private void elementExpr(AST node) {
        int pos = 0;
        while (node.getChild(pos).getType() == 4) {
            ++pos;
        }
        this.walkInspect(node.getChild(pos++), true, false);
        this.table.openScope(node, false);
        this.table.bind(Bits.FS_PARENT, new SequenceType(ElementType.ELEMENT, Cardinality.One));
        this.walkInspect(node.getChild(pos++), true, false);
        this.table.closeScope();
    }

    protected Scope[] sortScopes(VarRef varRefs) {
        if (varRefs == null) {
            return new Scope[0];
        }
        int cnt = 0;
        VarRef ref = varRefs;
        while (ref != null) {
            ++cnt;
            ref = ref.next;
        }
        int pos = 0;
        Object[] tmp = new Scope[cnt];
        VarRef ref2 = varRefs;
        while (ref2 != null) {
            tmp[pos++] = ref2.var.scope;
            ref2 = ref2.next;
        }
        Arrays.sort(tmp);
        pos = 0;
        Object p = tmp[pos++];
        for (int i = 1; i < cnt; ++i) {
            Object s = tmp[i];
            if (((Scope)p).compareTo((Scope)s) == 0) continue;
            tmp[pos++] = s;
        }
        return (Scope[])Arrays.copyOfRange(tmp, 0, pos);
    }

    protected VarRef[] sortVarRefs(VarRef varRefs) {
        if (varRefs == null) {
            return new VarRef[0];
        }
        int cnt = 0;
        VarRef ref = varRefs;
        while (ref != null) {
            ++cnt;
            ref = ref.next;
        }
        int pos = 0;
        VarRef[] tmp = new VarRef[cnt];
        VarRef ref2 = varRefs;
        while (ref2 != null) {
            tmp[pos++] = ref2;
            ref2 = ref2.next;
        }
        Arrays.sort(tmp, Comparator.comparing(o -> o.var.scope));
        return tmp;
    }

    public static void main(String[] args) throws Exception {
        String query = "for $X in 'foo' for $a in (1,2,3) let $b := $a let $c := $a let $d := $b let $e := if ($c) then (for $x in position() return $x[position()]) else () let $f := ($b,$c,$d,$e) return $f";
        new Query(query).serialize((QueryContext)new BrackitQueryContext(), System.out);
    }

    protected static class BindingTable {
        final Map<AST, Scope> scopemap = new HashMap<AST, Scope>();
        final Scope rootScope;
        Scope scope;

        BindingTable(AST root) {
            this.scope = this.rootScope = new Scope(root, null, false, 1);
        }

        void reset(Scope s) {
            Scope cs = s.firstChild;
            while (cs != null) {
                this.remove(cs);
                cs = cs.next;
            }
            this.scope = s;
            s.lvars = null;
        }

        protected void remove(Scope s) {
            this.scopemap.remove(s.node);
            Scope cs = s.firstChild;
            while (cs != null) {
                this.remove(cs);
                cs = cs.next;
            }
            s.lvars = null;
            s.firstChild = null;
            Scope ps = s.parent.firstChild;
            if (ps == s) {
                s.parent.firstChild = s.next;
            } else {
                while (ps.next != s) {
                    ps = ps.next;
                }
                ps.next = s.next;
            }
        }

        void bind(QNm var, SequenceType type) {
            this.scope.bind(var, type);
        }

        void openScope(AST node, boolean inPipeline) {
            this.scope = this.scope.open(node, inPipeline);
            this.scopemap.put(node, this.scope);
        }

        void closeScope() {
            this.scope = this.scope.parent;
        }

        void dropScope() {
            Scope cs = this.scope.firstChild;
            while (cs != null) {
                this.remove(cs);
                cs = cs.next;
            }
            this.scopemap.remove(this.scope.node);
            this.scope.parent.dropLastChild();
            this.scope = this.scope.parent;
        }

        void resolve(QNm var) {
            this.scope.resolve(var);
        }

        List<Var> inScopeBindings() {
            return this.scope.localBindings();
        }

        List<Var> inPipelineBindings() {
            ArrayList<Var> bindings = new ArrayList<Var>();
            Scope s = this.scope;
            while (s.inPipeline) {
                bindings.addAll(s.localBindings());
                s = s.parent;
            }
            return bindings;
        }

        Set<AST> getScopes() {
            return this.scopemap.keySet();
        }

        void promoteBindings() {
            this.scope.promoteToParent();
        }
    }

    protected static class Scope
    implements Comparable<Scope> {
        final boolean inPipeline;
        final AST node;
        final Scope parent;
        final int division;
        Scope firstChild;
        Scope next;
        Node lvars;

        private Scope(AST node, Scope parent, boolean inPipeline, int division) {
            this.node = node;
            this.parent = parent;
            this.inPipeline = inPipeline;
            this.division = division;
        }

        public AST getNode() {
            return this.node;
        }

        public boolean isInPipeline() {
            return this.inPipeline;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.numberString());
            s.append(":");
            s.append(this.node != null ? this.node.toString() : "");
            s.append("[");
            Node n = this.lvars;
            while (n != null) {
                s.append(n);
                if (n.next != null) {
                    s.append(" ; ");
                }
                n = n.next;
            }
            s.append("]");
            return s.toString();
        }

        private void bind(QNm var, SequenceType type) {
            Node p = null;
            Node n = this.lvars;
            while (n != null) {
                if (n.var.atomicCmp(var) == 0) {
                    return;
                }
                p = n;
                n = n.next;
            }
            if (p == null) {
                this.lvars = new Node(this, var, type, null);
            } else {
                p.next = new Node(this, var, type, null);
            }
        }

        public boolean resolveLocal(QNm var) {
            Node n = this.lvars;
            while (n != null) {
                if (n.var.atomicCmp(var) == 0) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }

        public Var resolve(QNm var) {
            Node n = this.lvars;
            while (n != null) {
                if (n.var.atomicCmp(var) == 0) {
                    return n;
                }
                n = n.next;
            }
            return this.parent != null ? this.parent.resolve(var) : null;
        }

        public Var get(QNm var) {
            Node n = this.lvars;
            while (n != null) {
                if (n.var.atomicCmp(var) == 0) {
                    return n;
                }
                n = n.next;
            }
            return null;
        }

        private Scope open(AST node, boolean inPipeline) {
            Scope s;
            if (this.firstChild == null) {
                this.firstChild = s = new Scope(node, this, inPipeline, 1);
            } else {
                Scope p = this.firstChild;
                while (p.next != null) {
                    p = p.next;
                }
                p.next = s = new Scope(node, this, inPipeline, p.division + 1);
            }
            return s;
        }

        public List<Var> localBindings() {
            if (this.lvars == null) {
                return Collections.emptyList();
            }
            ArrayList<Var> bindings = new ArrayList<Var>();
            Node n = this.lvars;
            while (n != null) {
                bindings.add(n);
                n = n.next;
            }
            return bindings;
        }

        public void promoteToParent() {
            Node n = this.lvars;
            while (n != null) {
                this.parent.bind(n.var, n.type);
                n = n.next;
            }
        }

        @Override
        public int compareTo(Scope other) {
            if (other == this) {
                return 0;
            }
            Scope cp = this;
            while (cp != null) {
                Scope lca = other;
                while (lca != null) {
                    if (lca == cp) {
                        if (lca == this) {
                            return -1;
                        }
                        if (lca == other) {
                            return 1;
                        }
                        if (this.division != other.division) {
                            return this.division < other.division ? -1 : 1;
                        }
                    }
                    lca = lca.parent;
                }
                cp = cp.parent;
            }
            return -1;
        }

        public String numberString() {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.division));
            Scope scope = this;
            while (scope.parent != null) {
                scope = scope.parent;
                stringBuilder.insert(0, scope.division + ".");
            }
            return stringBuilder.toString();
        }

        public String dot() {
            DotContext dt = new DotContext();
            this.toDot(0, dt);
            return dt.toDotString();
        }

        public void dot(File file) {
            DotContext dt = new DotContext();
            this.toDot(0, dt);
            dt.write(file);
        }

        private int toDot(int no, DotContext dt) {
            int myNo = no++;
            String label = this.node != null ? this.node.toString() : "";
            DotNode node = dt.addNode(String.valueOf(myNo));
            node.addRow(label, null);
            node.addRow(this.numberString(), null);
            int i = 0;
            Node var = this.lvars;
            while (var != null) {
                node.addRow(String.valueOf(i++), var.var.toString());
                var = var.next;
            }
            Scope child = this.firstChild;
            while (child != null) {
                dt.addEdge(String.valueOf(myNo), String.valueOf(no));
                no = child.toDot(no, dt);
                child = child.next;
            }
            return no;
        }

        public void display() {
            try {
                File file = File.createTempFile("scope", ".dot");
                file.deleteOnExit();
                this.dot(file);
                Runtime.getRuntime().exec(new String[]{"/usr/bin/dotty", file.getAbsolutePath()}).waitFor();
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void dropLastChild() {
            if (this.firstChild == null) {
                return;
            }
            Scope p = null;
            Scope n = this.firstChild;
            while (n.next != null) {
                p = n;
                n = n.next;
            }
            if (p == null) {
                this.firstChild = null;
            } else {
                p.next = null;
            }
        }

        private static class Node
        extends Var {
            Node next;

            Node(Scope scope, QNm var, SequenceType type, Node next) {
                super(scope, var, type);
                this.next = next;
            }
        }
    }

    protected static class Var {
        public final Scope scope;
        public final QNm var;
        public final SequenceType type;

        Var(Scope scope, QNm var, SequenceType type) {
            this.scope = scope;
            this.var = var;
            this.type = type;
        }

        public String toString() {
            return this.var.toString();
        }
    }

    protected static class VarRef {
        public final Var var;
        public final AST ref;
        public final Scope refScope;
        public VarRef next;

        public VarRef(Var var, AST ref, Scope refScope) {
            this.var = var;
            this.ref = ref;
            this.refScope = refScope;
        }

        public String toString() {
            return this.var.toString();
        }
    }
}

