/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.parser;

import io.brackit.query.Query;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.XMLChar;
import io.brackit.query.util.log.Logger;
import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.namespace.QName;

public class Tokenizer {
    private static final Logger log = Logger.getLogger(Tokenizer.class);
    private int pos;
    private int lastScanEnd;
    private final int end;
    private final char[] input;

    public Tokenizer(String s) {
        this.input = s.toCharArray();
        this.end = this.input.length;
    }

    protected int position() {
        return this.pos;
    }

    protected void resetTo(int pos) throws TokenizerException {
        if (pos < 0 || pos > this.end) {
            throw new TokenizerException("Illegal position: %s", pos);
        }
        this.pos = pos;
    }

    protected Token la(String token) {
        return this.la(this.pos, token);
    }

    protected Token la(Token prev, String token) {
        return this.la(prev.end, token);
    }

    protected Token laSkipS(String token) {
        return this.laSkipS(this.pos, token);
    }

    protected Token laSkipS(Token prev, String token) {
        return this.laSkipWS(prev.end, token);
    }

    private Token laSkipS(int from, String token) {
        int len;
        int s = from + this.s(from);
        int e = s;
        if (this.end - e < (len = token.length())) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (token.charAt(i) == this.input[e++]) continue;
            return null;
        }
        return new Token(s, e);
    }

    protected Token laSkipWS(String token) {
        return this.laSkipWS(this.pos, token);
    }

    protected Token laSkipWS(Token prev, String token) {
        return this.laSkipWS(prev.end, token);
    }

    private Token laSkipWS(int from, String token) {
        int len;
        int s = from + this.ws(from);
        int e = s;
        if (this.end - e < (len = token.length())) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (token.charAt(i) == this.input[e++]) continue;
            return null;
        }
        return new Token(s, e);
    }

    protected Token laSymSkipWS(String token) {
        return this.laSymSkipWS(this.pos, token);
    }

    protected Token laSymSkipS(Token prev, String token) {
        return this.laSymSkipS(prev.end, token);
    }

    private Token laSymSkipS(int from, String token) {
        return this.laSym(from + this.s(from), token);
    }

    protected Token laSymSkipS(String token) {
        return this.laSymSkipWS(this.pos + this.s(this.pos), token);
    }

    protected Token laSymSkipWS(Token prev, String token) {
        return this.laSymSkipWS(prev.end, token);
    }

    private Token laSymSkipWS(int from, String token) {
        return this.laSym(from + this.ws(from), token);
    }

    private Token laSym(int pos, String token) {
        int s = pos;
        int e = s;
        int len = token.length();
        if (this.end - e < len) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (token.charAt(i) == this.input[e++]) continue;
            return null;
        }
        boolean isSym = e == this.end || this.isSymDel(this.input[e]);
        return isSym ? new Token(s, e) : null;
    }

    private boolean isSymDel(char c) {
        return XMLChar.isWS(c) || c == '(' || this.isDelChar(c);
    }

    private boolean isDelChar(char c) {
        return XMLChar.isWS(c) || c == '!' || c == '\'' || c == '\"' || c == '#' || c == '$' || c == '%' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == '-' || c == '.' || c == '/' || c == ':' || c == ';' || c == '<' || c == '=' || c == '>' || c == '?' || c == '@' || c == '[' || c == ']' || c == '{' || c == '|' || c == '}';
    }

    protected Token la(int from, String token) {
        int s = from;
        int e = s;
        int len = token.length();
        if (this.end - e < len) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (token.charAt(i) == this.input[e++]) continue;
            return null;
        }
        return new Token(s, e);
    }

    protected boolean attemptWS() {
        Token la = this.laWS();
        if (la == null) {
            return false;
        }
        this.consume(la);
        return true;
    }

    protected boolean attemptS() {
        Token la = this.laS();
        if (la == null) {
            return false;
        }
        this.consume(la);
        return true;
    }

    protected boolean attemptSkipWS(String token) {
        Token la = this.laSkipWS(this.pos, token);
        if (la == null) {
            return false;
        }
        this.consume(la);
        return true;
    }

    protected boolean attemptSkipS(String token) {
        Token la = this.laSkipS(this.pos, token);
        if (la == null) {
            return false;
        }
        this.consume(la);
        return true;
    }

    protected boolean attemptSymSkipWS(String token) {
        Token la = this.laSymSkipWS(this.pos, token);
        if (la == null) {
            return false;
        }
        this.consume(la);
        return true;
    }

    protected boolean attemptSymSkipS(String token) {
        Token la = this.laSymSkipS(this.pos, token);
        if (la == null) {
            return false;
        }
        this.consume(la);
        return true;
    }

    protected boolean attempt(String token) {
        Token la = this.la(this.pos, token);
        if (la == null) {
            return false;
        }
        this.consume(la);
        return true;
    }

    protected void consumeEOF() throws TokenizerException {
        int p;
        int ws = this.ws(this.pos);
        for (p = this.pos + ws; p < this.end && this.input[p] == '\u0000'; ++p) {
        }
        if (p != this.end) {
            throw new TokenizerException("Expected end of query: %s", this.paraphrase());
        }
    }

    protected void consumeSymSkipWS(String token) throws TokenizerException {
        Token la = this.laSymSkipWS(this.pos, token);
        if (la == null) {
            throw new TokenizerException("Expected '%s': '%s'", token, this.paraphrase());
        }
        this.consume(la);
    }

    protected void consumeSkipWS(String token) throws TokenizerException {
        Token la = this.laSkipWS(this.pos, token);
        if (la == null) {
            throw new TokenizerException("Expected '%s': '%s'", token, this.paraphrase());
        }
        this.consume(la);
    }

    protected void consume(Token token) {
        if (Query.DEBUG && log.isDebugEnabled()) {
            log.debug("Consuming " + String.valueOf(token) + " (to [" + token.start + ":" + token.end + "]/" + this.end + ")");
        }
        this.pos = token.end;
    }

    protected void consume(String token) throws TokenizerException {
        Token la = this.la(this.pos, token);
        if (la == null) {
            throw new TokenizerException("Expected '%s' after: '%s'", token, this.paraphrase());
        }
        this.consumeSkipWS(token);
    }

    protected String paraphrase() {
        int start;
        int line = 0;
        int linePos = 0;
        int p = 0;
        while (p < this.pos) {
            ++linePos;
            if (this.input[p++] != '\n') continue;
            ++line;
            ++linePos;
        }
        char[] preBuf = new char[60];
        int preLen = 59;
        int n = p = this.pos == this.end ? this.pos - 1 : this.pos;
        for (start = 59; p >= 0 && start > 0; --p, --start) {
            if (XMLChar.isWS(this.input[p]) && (start >= 59 || XMLChar.isWS(preBuf[start + 1]))) continue;
            preBuf[start] = this.input[p];
        }
        String paraphrase = new String(preBuf, start + 1, 59 - start);
        return String.format("[%s:%s|%s:%s] %s", line, linePos, this.pos, this.end, paraphrase);
    }

    protected Token laWS() {
        int ws = this.ws(this.pos);
        return ws > 0 ? new Token(this.pos, this.pos + ws) : null;
    }

    protected Token laS(Token token) {
        return this.laS(token.end);
    }

    protected Token laS() {
        return this.laS(this.pos);
    }

    private Token laS(int pos) {
        int s = this.s(pos);
        return s > 0 ? new Token(pos, pos + s) : null;
    }

    protected boolean skipS() {
        int s = this.s(this.pos);
        if (s <= 0) {
            return false;
        }
        if (Query.DEBUG && log.isDebugEnabled()) {
            log.debug("Skipping whitespace from " + this.pos + " to " + (this.pos + s));
        }
        this.pos += s;
        return true;
    }

    private int s(int from) {
        char c;
        int p;
        for (p = from; p < this.end && ((c = this.input[p]) == ' ' || c == '\r' || c == '\t' || c == '\n'); ++p) {
        }
        return p - from;
    }

    private int ws(int from) {
        int p = from;
        while (p < this.end) {
            char c = this.input[p];
            if (c == ' ' || c == '\r' || c == '\t' || c == '\n') {
                ++p;
                continue;
            }
            if (c != '(' || p >= this.end || this.input[p + 1] != ':') break;
            int len = this.comment(p);
            if (len == 0) {
                ++p;
                break;
            }
            p += len;
        }
        return p - from;
    }

    private int comment(int from) {
        char c;
        int e = from;
        if ((c = this.input[e++]) != '(' || e >= this.end || (c = this.input[e++]) != ':') {
            return 0;
        }
        int len = 2;
        int depth = 0;
        while (e < this.end) {
            char p = c;
            c = this.input[e++];
            ++len;
            if (c == ':') {
                if (p != '(') continue;
                ++depth;
                continue;
            }
            if (c != ')' || p != ':') continue;
            if (depth == 0) {
                return len;
            }
            --depth;
        }
        return 0;
    }

    protected EQNameToken laQName() {
        return this.laQName(this.pos);
    }

    protected EQNameToken laQNameSkipWS(Token token) {
        return this.laQName(token.end + this.ws(token.end));
    }

    protected EQNameToken laQNameSkipWS() {
        return this.laQName(this.pos + this.ws(this.pos));
    }

    protected EQNameToken laQName(Token token) {
        return this.laQName(token.end);
    }

    private EQNameToken laQName(int pos) {
        char c;
        Token la = this.laNCName(pos);
        if (la == null) {
            return null;
        }
        int e = la.end;
        if (e >= this.end) {
            return new EQNameToken(la.start, la.end, null, null, la.string());
        }
        if ((c = this.input[e++]) != ':') {
            return new EQNameToken(la.start, la.end, null, null, la.string());
        }
        Token la2 = this.laNCName(e);
        if (la2 == null) {
            return new EQNameToken(la.start, la.end, null, null, la.string());
        }
        e = la2.end;
        return new EQNameToken(pos, e, null, la.string(), la2.string());
    }

    protected EQNameToken laEQName(boolean cond) throws TokenizerException {
        return this.laEQName(this.pos, cond);
    }

    protected EQNameToken laEQNameSkipWS(Token token, boolean cond) throws TokenizerException {
        return this.laEQName(token.end + this.ws(token.end), cond);
    }

    protected EQNameToken laEQNameSkipWS(boolean cond) throws TokenizerException {
        return this.laEQName(this.pos + this.ws(this.pos), cond);
    }

    protected EQNameToken laEQName(Token token, boolean cond) throws TokenizerException {
        return this.laEQName(token.end, cond);
    }

    private EQNameToken laEQName(int pos, boolean cond) throws TokenizerException {
        EQNameToken la = this.laQName(pos);
        if (la != null) {
            return la;
        }
        Token uri = this.laString(pos, cond);
        if (uri == null) {
            return null;
        }
        Token colon = this.la(uri, ":");
        if (colon == null) {
            return null;
        }
        Token ncname = this.laNCName(colon);
        if (ncname == null) {
            return la;
        }
        return new EQNameToken(pos, ncname.end, uri.string(), null, ncname.string());
    }

    protected Token laNCName() {
        return this.laNCName(this.pos);
    }

    protected Token laNCNameSkipWS() {
        return this.laNCName(this.pos + this.ws(this.pos));
    }

    protected Token laNCNameSkipS() {
        return this.laNCName(this.pos + this.s(this.pos));
    }

    protected Token laNCName(Token token) {
        return this.laNCName(token.end);
    }

    protected Token laNCNameSkipWS(Token token) {
        return this.laNCName(token.end + this.ws(token.end));
    }

    private Token laNCName(int pos) {
        char c;
        int e = pos;
        if (e >= this.end) {
            return null;
        }
        int len = 0;
        if ((c = this.input[e++]) == ':' || c == '.' || !XMLChar.isNameStartChar(c)) {
            return null;
        }
        ++len;
        while (e < this.end && (c = this.input[e++]) != ':' && c != '.' && XMLChar.isNameChar(c)) {
            ++len;
        }
        if (len == 0 || e != this.end && !this.isDelChar(this.input[e - 1])) {
            return null;
        }
        return new Token(pos, pos + len);
    }

    protected Token laDouble(boolean cond) throws TokenizerException {
        return this.laDouble(this.pos, cond);
    }

    protected Token laDoubleSkipWS(boolean cond) throws TokenizerException {
        return this.laDouble(this.pos + this.ws(this.pos), cond);
    }

    protected Token laDouble(Token token, boolean cond) throws TokenizerException {
        return this.laDouble(token.end, cond);
    }

    private Token laDouble(int pos, boolean cond) throws TokenizerException {
        int e = pos;
        int len = 0;
        int c = 0;
        if (e >= this.end) {
            return null;
        }
        while (e < this.end && (c = this.input[e++]) >= 48 && c <= 57) {
            ++len;
        }
        if (c == 46) {
            if (++len == 1) {
                if (e >= this.end || (c = this.input[e++]) < 48 || c > 57) {
                    if (cond) {
                        return null;
                    }
                    throw new TokenizerException("Invalid numerical literal '%s': %s", new String(this.input, pos, e - pos), this.paraphrase());
                }
                ++len;
            }
            while (e < this.end && (c = this.input[e++]) >= 48 && c <= 57) {
                ++len;
            }
        }
        if (len > 0 && (c == 101 || c == 69)) {
            ++len;
            if (e >= this.end) {
                if (cond) {
                    return null;
                }
                throw new TokenizerException("Invalid numerical literal '%s': %s", new String(this.input, pos, e - pos), this.paraphrase());
            }
            if ((c = this.input[e++]) == 45 || c == 43) {
                ++len;
                if (e >= this.end) {
                    if (cond) {
                        return null;
                    }
                    throw new TokenizerException("Invalid numerical literal '%s': %s", new String(this.input, pos, e - pos), this.paraphrase());
                }
                c = this.input[e++];
            }
            if (c < 48 || c > 57) {
                if (cond) {
                    return null;
                }
                throw new TokenizerException("Invalid numerical literal '%s': %s", new String(this.input, pos, e - pos), this.paraphrase());
            }
            ++len;
            while (e < this.end && (c = this.input[e++]) >= 48 && c <= 57) {
                ++len;
            }
        }
        if (len == 0 || e != this.end && !this.isDelChar(this.input[e - 1])) {
            return null;
        }
        return new Token(pos, pos + len);
    }

    protected Token laDecimal(boolean cond) throws TokenizerException {
        return this.laDecimal(this.pos, cond);
    }

    protected Token laDecimalSkipWS(boolean cond) throws TokenizerException {
        return this.laDecimal(this.pos + this.ws(this.pos), cond);
    }

    protected Token laDecimal(Token token, boolean cond) throws TokenizerException {
        return this.laDecimal(token.end, cond);
    }

    private Token laDecimal(int pos, boolean cond) throws TokenizerException {
        int e = pos;
        int len = 0;
        int c = 0;
        if (e >= this.end) {
            return null;
        }
        while (e < this.end) {
            if ((c = this.input[e++]) >= 48 && c <= 57) {
                ++len;
                continue;
            }
            if (c != 69) break;
            return null;
        }
        if (c == 46) {
            if (++len == 1) {
                if (e >= this.end || (c = this.input[e++]) < 48 || c > 57) {
                    if (cond) {
                        return null;
                    }
                    throw new TokenizerException("Invalid numerical literal '%s': %s", new String(this.input, pos, e - pos), this.paraphrase());
                }
                ++len;
            }
            while (e < this.end && (c = this.input[e++]) >= 48 && c <= 57) {
                ++len;
            }
        }
        if (len == 0 || e != this.end && !this.isDelChar(this.input[e - 1])) {
            return null;
        }
        return new Token(pos, pos + len);
    }

    protected Token laInteger(boolean cond) {
        return this.laInteger(this.pos, cond);
    }

    protected Token laIntegerSkipWS(boolean cond) {
        return this.laInteger(this.pos + this.ws(this.pos), cond);
    }

    protected Token laInteger(Token token, boolean cond) {
        return this.laInteger(token.end, cond);
    }

    private Token laInteger(int pos, boolean cond) {
        int e = pos;
        int len = 0;
        char c = '\u0000';
        if (e >= this.end) {
            return null;
        }
        while (e < this.end) {
            if ((c = this.input[e++]) >= '0' && c <= '9') {
                ++len;
                continue;
            }
            if (c != '.') break;
            return null;
        }
        if (len == 0 || e != this.end && !this.isDelChar(this.input[e - 1])) {
            return null;
        }
        return new Token(pos, pos + len);
    }

    protected Token laString(boolean cond) throws TokenizerException {
        return this.laString(this.pos, cond);
    }

    protected Token laStringSkipWS(boolean cond) throws TokenizerException {
        return this.laString(this.pos + this.ws(this.pos), cond);
    }

    protected Token laString(Token token, boolean cond) throws TokenizerException {
        return this.laString(token.end, cond);
    }

    protected Token laString(int pos, boolean cond) throws TokenizerException {
        Token begin = this.la(pos, "'");
        if (begin != null) {
            String s = this.scanAposStringLiteral(begin.end, cond);
            Token end = this.la(this.lastScanEnd, "'");
            if (end != null) {
                return new StringToken(pos, end.end, s);
            }
            throw new TokenizerException("Unclosed string literal: %s", this.paraphrase());
        }
        begin = this.la(pos, "\"");
        if (begin != null) {
            String s = this.scanQuotStringLiteral(begin.end, cond);
            Token end = this.la(this.lastScanEnd, "\"");
            if (end != null) {
                return new StringToken(pos, end.end, s);
            }
            throw new TokenizerException("Unclosed string literal: %s", this.paraphrase());
        }
        return null;
    }

    protected Token laPragma(boolean cond) throws TokenizerException {
        return this.laPragma(this.pos, cond);
    }

    private Token laPragma(int pos, boolean cond) throws TokenizerException {
        int s = pos;
        int e = pos;
        if (e >= this.end) {
            return null;
        }
        int len = 0;
        while (e < this.end) {
            char c;
            if ((c = this.input[e++]) == '#' && e < this.end && this.input[e] == ')') {
                return new Token(s, s + len);
            }
            if (!XMLChar.isChar(c)) {
                if (cond) {
                    return null;
                }
                throw new TokenizerException("Invalid pragma content '%s': %s", new String(this.input, pos, e - pos), this.paraphrase());
            }
            ++len;
        }
        if (cond) {
            return null;
        }
        throw new TokenizerException("Unclosed pragma content at position %s: '%s'", pos, this.paraphrase());
    }

    protected Token laQuotAttrContentChar() {
        int s = this.pos;
        String content = this.scanAttrContentChar(s, '\"', "\"\"", "\"");
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laAposAttrContentChar() {
        int s = this.pos;
        String content = this.scanAttrContentChar(s, '\'', "''", "'");
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laPredefEntityRef(boolean cond) throws TokenizerException {
        int s = this.pos;
        String content = this.scanPredefEntityRef(s, cond);
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laCharRef(boolean cond) throws TokenizerException {
        int s = this.pos;
        String content = this.scanCharRef(s, cond);
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laEscapeQuot() {
        int s = this.pos;
        String content = this.scanEscape(s, '\"', "\"");
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laEscapeApos() {
        int s = this.pos;
        String content = this.scanEscape(s, '\'', "'");
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laEscapeCurly() {
        int s = this.pos;
        String content = this.scanEscape(s, '{', "{");
        if (content == null && (content = this.scanEscape(s, '}', "}")) == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laCommentContents(boolean cond) throws TokenizerException {
        int s = this.pos;
        String content = this.scanCommentContents(s, cond);
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laPITarget(boolean cond) throws TokenizerException {
        int s = this.pos;
        String content = this.scanPITarget(s, cond);
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laPIContents() {
        int s = this.pos;
        String content = this.scanPIContents(s);
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laCDataSectionContents() throws TokenizerException {
        int s = this.pos;
        String content = this.scanCDataSectionContents(s);
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    protected Token laElemContentChar() {
        int s = this.pos;
        String content = this.scanElemContentChar(s);
        if (content == null) {
            return null;
        }
        return new StringToken(s, this.lastScanEnd, content);
    }

    private String scanAttrContentChar(int pos, char escapeChar, String escapeStr, String replace) {
        int s = pos;
        int e = pos;
        if (e >= this.end) {
            return null;
        }
        boolean hasEscapes = false;
        int len = 0;
        while (e < this.end) {
            char c;
            if ((c = this.input[e++]) == escapeChar && e < this.end && this.input[e] == escapeChar) {
                hasEscapes = true;
                ++e;
                len += 2;
                continue;
            }
            if (c == escapeChar || c == '{' || c == '}' || c == '<' || c == '&' || !XMLChar.isChar(c)) break;
            ++len;
        }
        if (len == 0) {
            return null;
        }
        this.lastScanEnd = pos + len;
        String content = new String(this.input, s, len);
        if (hasEscapes) {
            content = content.replace(escapeStr, replace);
        }
        return content;
    }

    private String scanElemContentChar(int pos) {
        char c;
        int s = pos;
        int e = s;
        if (e >= this.end) {
            return null;
        }
        int len = 0;
        while (e < this.end && (c = this.input[e++]) != '{' && c != '}' && c != '<' && c != '&' && XMLChar.isChar(c)) {
            ++len;
        }
        if (len == 0) {
            return null;
        }
        this.lastScanEnd = pos + len;
        return new String(this.input, s, len);
    }

    private String scanCDataSectionContents(int pos) throws TokenizerException {
        int s = pos;
        int e = s;
        if (e >= this.end) {
            return null;
        }
        int len = 0;
        while (e < this.end) {
            char c;
            if ((c = this.input[e++]) == ']') {
                if (this.end - e <= 1) {
                    return null;
                }
                if (this.input[e] == ']' && this.input[e + 1] == '>') break;
            }
            if (!XMLChar.isChar(c)) {
                throw new TokenizerException("Illegal character in CDATA section: '%s': %s", Character.valueOf(c), this.paraphrase());
            }
            ++len;
        }
        this.lastScanEnd = pos + len;
        return new String(this.input, s, len);
    }

    private String scanJsonPredefCharRef(int pos, boolean cond) throws TokenizerException {
        int e = pos;
        if (e + 1 >= this.end) {
            return null;
        }
        if (this.input[e++] != '\\') {
            return null;
        }
        if (this.input[e] == '\\') {
            this.lastScanEnd = pos + 2;
            return "\\\\";
        }
        if (this.input[e] == '/') {
            this.lastScanEnd = pos + 2;
            return "\\/";
        }
        if (this.input[e] == '\"') {
            this.lastScanEnd = pos + 2;
            return "\\\"";
        }
        if (this.input[e] == '\'') {
            this.lastScanEnd = pos + 2;
            return "\\'";
        }
        if (this.input[e] == 'b') {
            this.lastScanEnd = pos + 2;
            return "\\b";
        }
        if (this.input[e] == 'f') {
            this.lastScanEnd = pos + 2;
            return "\\f";
        }
        if (this.input[e] == 'n') {
            this.lastScanEnd = pos + 2;
            return "\\n";
        }
        if (this.input[e] == 'r') {
            this.lastScanEnd = pos + 2;
            return "\\r";
        }
        if (this.input[e] == 't') {
            this.lastScanEnd = pos + 2;
            return "\\t";
        }
        throw new TokenizerException("Illegal JSONPredefinedCharRef '%s': %s", new String(this.input, pos, 2), this.paraphrase());
    }

    protected String scanPredefEntityRef(int pos, boolean cond) throws TokenizerException {
        int e = pos;
        if (e + 1 >= this.end) {
            return null;
        }
        if (this.input[e++] != '&' || this.input[e] == '#') {
            return null;
        }
        if (this.end - e <= 3) {
            throw new TokenizerException("Illegal PredefinedEntityRef '%s': %s", new String(this.input, pos, Math.min(4, this.end - pos)), this.paraphrase());
        }
        if (this.input[e] == 'l' && this.input[e + 1] == 't' && this.input[e + 2] == ';') {
            this.lastScanEnd = pos + 4;
            return "<";
        }
        if (this.input[e] == 'g' && this.input[e + 1] == 't' && this.input[e + 2] == ';') {
            this.lastScanEnd = pos + 4;
            return ">";
        }
        if (this.end - e >= 4 && this.input[e] == 'a' && this.input[e + 1] == 'm' && this.input[e + 2] == 'p' && this.input[e + 3] == ';') {
            this.lastScanEnd = pos + 5;
            return "&";
        }
        if (this.end - e >= 5) {
            if (this.input[e] == 'a' && this.input[e + 1] == 'p' && this.input[e + 2] == 'o' && this.input[e + 3] == 's' && this.input[e + 4] == ';') {
                this.lastScanEnd = pos + 6;
                return "'";
            }
            if (this.input[e] == 'q' && this.input[e + 1] == 'u' && this.input[e + 2] == 'o' && this.input[e + 3] == 't' && this.input[e + 4] == ';') {
                this.lastScanEnd = pos + 6;
                return "\"";
            }
        }
        throw new TokenizerException("Illegal PredefinedEntityRef '%s': %s", new String(this.input, pos, 6), this.paraphrase());
    }

    private String scanJsonCharRef(int pos, boolean cond) throws TokenizerException {
        BigInteger charRef;
        int len;
        int e = pos;
        if (e + 1 >= this.end) {
            return null;
        }
        if (this.input[e++] != '\\' || this.input[e++] != 'u') {
            return null;
        }
        if (this.end - e <= 3) {
            String charRef2 = new String(this.input, pos, Math.min(4, this.end - pos));
            throw new TokenizerException("Illegal Unicode character reference '%s' %s: '%s'", charRef2, this.paraphrase());
        }
        int s = e;
        int radix = 10;
        for (len = 0; e < this.end && len < 4; ++len) {
            char c;
            if ('0' <= (c = this.input[e++]) && c <= '9') continue;
            if (c == ';' && len != 0) break;
            return null;
        }
        String tmp = new String(this.input, s, len);
        try {
            charRef = new BigInteger(tmp, radix);
        }
        catch (NumberFormatException e1) {
            throw new TokenizerException("Illegal Unicode character reference '%s' %s: '%s'", tmp, this.paraphrase());
        }
        if (charRef.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || !XMLChar.isChar(charRef.intValue())) {
            throw new IllegalCharRefException(tmp);
        }
        this.lastScanEnd = s + len + 1;
        return String.valueOf(charRef.intValue());
    }

    protected String scanCharRef(int pos, boolean cond) throws TokenizerException {
        BigInteger charRef;
        int e = pos;
        if (e + 1 >= this.end) {
            return null;
        }
        if (this.input[e++] != '&' || this.input[e++] != '#') {
            return null;
        }
        if (this.end - e <= 3) {
            String charRef2 = new String(this.input, pos, Math.min(4, this.end - pos));
            throw new TokenizerException("Illegal Unicode character reference '%s' %s: '%s'", charRef2, this.paraphrase());
        }
        int len = 0;
        int s = e;
        int radix = 10;
        if (this.input[e] == 'x') {
            radix = 16;
            ++s;
            ++e;
            while (e < this.end) {
                char c;
                if (!('0' <= (c = this.input[e++]) && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z')) {
                    if (c != ';' || len == 0) {
                        return null;
                    }
                    break;
                }
                ++len;
            }
        } else {
            while (e < this.end) {
                char c;
                if ('0' > (c = this.input[e++]) || c > '9') {
                    if (c != ';' || len == 0) {
                        return null;
                    }
                    break;
                }
                ++len;
            }
        }
        String tmp = new String(this.input, s, len);
        try {
            charRef = new BigInteger(tmp, radix);
        }
        catch (NumberFormatException e1) {
            throw new TokenizerException("Illegal Unicode character reference '%s' %s: '%s'", tmp, this.paraphrase());
        }
        if (charRef.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || !XMLChar.isChar(charRef.intValue())) {
            throw new IllegalCharRefException(tmp);
        }
        this.lastScanEnd = s + len + 1;
        return XMLChar.toString(charRef.intValue());
    }

    protected int getEnd() {
        return this.end;
    }

    protected char[] getInput() {
        return this.input;
    }

    protected String scanString(int pos, char escapeChar, boolean isXml) {
        char c;
        int e;
        int s = e = pos;
        int len = 0;
        while (!(e >= this.end || (c = this.input[e++]) == escapeChar || isXml && c == '&' || !isXml && c == '\\')) {
            ++len;
        }
        if (len == 0) {
            return null;
        }
        this.lastScanEnd = pos + len;
        return new String(this.input, s, len);
    }

    private String scanAposStringLiteral(int pos, boolean cond) throws TokenizerException {
        this.lastScanEnd = pos;
        StringBuilder buf = new StringBuilder();
        int spos = pos;
        while (true) {
            String s;
            s = (s = this.scanPredefEntityRef(spos, cond)) != null ? s : this.scanCharRef(spos, cond);
            s = s != null ? s : this.scanEscape(spos, '\'', "'");
            String string = s = s != null ? s : this.scanString(spos, '\'', true);
            if (s == null) break;
            buf.append(s);
            spos = this.lastScanEnd;
        }
        return buf.toString();
    }

    private String scanQuotStringLiteral(int pos, boolean cond) throws TokenizerException {
        this.lastScanEnd = pos;
        StringBuilder buf = new StringBuilder();
        int spos = pos;
        while (true) {
            String s;
            s = (s = this.scanJsonPredefCharRef(spos, cond)) != null ? s : this.scanJsonCharRef(spos, cond);
            s = s != null ? s : this.scanEscape(spos, '\"', "\"");
            String string = s = s != null ? s : this.scanString(spos, '\"', false);
            if (s == null) break;
            buf.append(s);
            spos = this.lastScanEnd;
        }
        return buf.toString();
    }

    protected String scanEscape(int pos, char escapeChar, String escapeString) {
        int s = pos;
        int e = s;
        if (this.end - e < 2 || this.input[e++] != escapeChar || this.input[e++] != escapeChar) {
            return null;
        }
        this.lastScanEnd = e;
        return escapeString;
    }

    private String scanCommentContents(int pos, boolean cond) throws TokenizerException {
        int s = pos;
        int e = s;
        if (e >= this.end) {
            return null;
        }
        int len = 0;
        while (e < this.end) {
            char c;
            if ((c = this.input[e++]) == '-' && e < this.end && this.input[e] == '-') {
                if (e + 1 < this.end && this.input[e + 1] == '>') break;
                if (cond) {
                    return null;
                }
                throw new TokenizerException("Illegal '--' in XML comment: %s", this.paraphrase());
            }
            if (!XMLChar.isChar(c)) break;
            ++len;
        }
        this.lastScanEnd = pos + len;
        return new String(this.input, s, len);
    }

    private String scanPITarget(int pos, boolean cond) throws TokenizerException {
        char c;
        int s = pos;
        int e = s;
        if (e >= this.end) {
            return null;
        }
        int len = 0;
        if (!XMLChar.isNameStartChar(c = this.input[e++])) {
            return null;
        }
        ++len;
        while (e < this.end && XMLChar.isNameChar(c = this.input[e++])) {
            ++len;
        }
        if (len == 0) {
            return null;
        }
        String target = new String(this.input, s, len);
        if (target.length() == 3 && target.toLowerCase().equals("xml")) {
            if (cond) {
                return null;
            }
            throw new TokenizerException("PITarget must not be '%s': %s", target, this.paraphrase());
        }
        this.lastScanEnd = pos + len;
        return target;
    }

    private String scanPIContents(int pos) {
        char c;
        int s = pos;
        int e = s;
        if (e >= this.end) {
            return null;
        }
        int len = 0;
        while (e < this.end && ((c = this.input[e++]) != '?' || e >= this.end || this.input[e] != '>') && XMLChar.isChar(c)) {
            ++len;
        }
        this.lastScanEnd = pos + len;
        return new String(this.input, s, len);
    }

    public class TokenizerException
    extends Exception {
        public TokenizerException(String message, Object ... args) {
            super(String.format(message, args));
        }

        public TokenizerException(Exception e, String message, Object ... args) {
            super(String.format(message, args), e);
        }
    }

    protected class Token {
        final int start;
        final int end;

        public Token(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String string() {
            return new String(Tokenizer.this.input, this.start, this.end - this.start);
        }

        public String toString() {
            return this.string();
        }
    }

    protected class EQNameToken
    extends Token {
        final String uri;
        final String prefix;
        final String ncname;

        public EQNameToken(int start, int end, String uri, String prefix, String ncname) {
            super(start, end);
            this.uri = uri;
            this.ncname = ncname;
            this.prefix = prefix;
        }

        public String uri() {
            return this.uri;
        }

        public String ncname() {
            return this.ncname;
        }

        public String prefix() {
            return this.prefix;
        }

        public QNm qname() {
            return new QNm(this.uri, this.prefix, this.ncname);
        }

        public QName getName() {
            return new QName(this.uri, this.ncname, this.prefix);
        }

        @Override
        public String string() {
            String prefixAndNcName = this.prefix != null ? this.prefix + ":" + this.ncname : this.ncname;
            return this.uri != null ? "\"" + this.uri + "\":" + prefixAndNcName : prefixAndNcName;
        }
    }

    protected class StringToken
    extends Token {
        final String s;

        public StringToken(int start, int end, String s) {
            super(start, end);
            this.s = s;
        }

        @Override
        public String string() {
            return this.s;
        }
    }

    public class IllegalCharRefException
    extends TokenizerException {
        public IllegalCharRefException(String charRef) {
            super("Illegal Unicode codepoint %s: '%s'", charRef, Tokenizer.this.paraphrase());
        }
    }

    public class MismatchException
    extends TokenizerException {
        public MismatchException(String ... expected) {
            super("Expected one of %s: '%s'", Arrays.toString(expected), Tokenizer.this.paraphrase());
        }
    }
}

