/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryException;
import io.brackit.query.jdm.Axis;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.node.TemporalNode;
import io.brackit.query.jdm.type.NodeType;
import io.brackit.query.node.stream.ArrayStream;
import io.brackit.query.node.stream.AtomStream;
import io.brackit.query.node.stream.EmptyStream;
import io.brackit.query.node.stream.IteratorStream;
import java.util.ArrayDeque;

public abstract class Accessor {
    public static final Accessor PARENT = new Accessor(Axis.PARENT){

        public Stream<Node<?>> performStep(Node<?> node) {
            Object parent = node.getParent();
            return parent != null ? new AtomStream(parent) : new EmptyStream();
        }
    };
    public static final Accessor CHILD = new Accessor(Axis.CHILD){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return node.getChildren();
        }
    };
    public static final Accessor ANCESTOR = new Accessor(Axis.ANCESTOR){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            Object parent = node.getParent();
            if (parent == null) {
                return new EmptyStream();
            }
            ArrayDeque<Node> deque = new ArrayDeque<Node>();
            try (Stream path = parent.getPath();){
                Node a;
                while ((a = (Node)path.next()) != null) {
                    deque.push(a);
                }
            }
            return new IteratorStream(deque.iterator());
        }
    };
    public static final Accessor DESCENDANT = new Accessor(Axis.DESCENDANT){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            Stream<?> subtree = node.getDescendantOrSelf();
            subtree.next();
            return subtree;
        }
    };
    public static final Accessor ANCESTOR_OR_SELF = new Accessor(Axis.ANCESTOR_OR_SELF){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            ArrayDeque<Node> deque = new ArrayDeque<Node>();
            try (Stream<?> path = node.getPath();){
                Node a;
                while ((a = (Node)path.next()) != null) {
                    deque.push(a);
                }
            }
            return new IteratorStream(deque.iterator());
        }
    };
    public static final Accessor DESCENDANT_OR_SELF = new Accessor(Axis.DESCENDANT_OR_SELF){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return node.getDescendantOrSelf();
        }
    };
    public static final Accessor ATTRIBUTE = new Accessor(Axis.ATTRIBUTE){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return node.getAttributes();
        }

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node, NodeType test) {
            if (test.getNodeKind() == Kind.ATTRIBUTE && test.getQName() != null) {
                Object att = node.getAttribute(test.getQName());
                if (att == null || test.getType() != null && !att.type().instanceOf(test.getType())) {
                    return new EmptyStream();
                }
                return new AtomStream(att);
            }
            return super.performStep(node, test);
        }
    };
    public static final Accessor SELF = new Accessor(Axis.SELF){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return new AtomStream(node);
        }
    };
    public static final Accessor FOLLOWING = new Accessor(Axis.FOLLOWING){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            final Node<?> n = node;
            return new Stream<Node<?>>(){
                Stream<? extends Node<?>> s;
                Node<?> anchor;
                Node<?> current;
                {
                    this.anchor = n;
                    this.current = n;
                }

                @Override
                public void close() {
                    if (this.s != null) {
                        this.s.close();
                        this.s = null;
                    }
                    this.current = null;
                    this.anchor = null;
                }

                @Override
                public Node<?> next() throws DocumentException {
                    while (true) {
                        if (this.s != null) {
                            Node<?> n2 = this.s.next();
                            if (n2 != null) {
                                return n2;
                            }
                            this.s.close();
                            this.s = null;
                        }
                        this.current = this.current.getNextSibling();
                        while (this.current == null) {
                            this.anchor = this.anchor.getParent();
                            if (this.anchor == null) {
                                return null;
                            }
                            this.current = this.anchor.getNextSibling();
                        }
                        this.s = this.current.getDescendantOrSelf();
                    }
                }
            };
        }
    };
    public static final Accessor FOLLOWING_SIBLING = new Accessor(Axis.FOLLOWING_SIBLING){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            Object nextSibling = node.getNextSibling();
            return new Stream<Node<?>>((Node)nextSibling){
                Node<?> next;
                final /* synthetic */ Node val$nextSibling;
                {
                    this.val$nextSibling = node;
                    this.next = this.val$nextSibling;
                }

                @Override
                public void close() {
                    this.next = null;
                }

                @Override
                public Node<?> next() throws DocumentException {
                    if (this.next == null) {
                        return null;
                    }
                    Node<?> deliver = this.next;
                    this.next = this.next.getNextSibling();
                    return deliver;
                }
            };
        }
    };
    public static final Accessor PRECEDING = new Accessor(Axis.PRECEDING){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            final Node<?> n = node;
            Object p = node.getParent();
            if (p == null || p.isDocumentRoot()) {
                return new EmptyStream();
            }
            if (!p.isDocumentRoot()) {
                Object a;
                while ((a = p.getParent()) != null && !a.isDocumentRoot()) {
                    p = a;
                }
            }
            final Stream fragment = p.getDescendantOrSelf();
            fragment.next();
            fragment.next();
            return new Stream<Node<?>>(){
                final Node<?> stopAt;
                Stream<? extends Node<?>> s;
                {
                    this.stopAt = n;
                    this.s = fragment;
                }

                @Override
                public void close() {
                    if (this.s != null) {
                        this.s.close();
                        this.s = null;
                    }
                }

                @Override
                public Node<?> next() throws DocumentException {
                    Node<?> n2;
                    if (this.s != null && (n2 = this.s.next()) != null) {
                        if (n2.isSelfOf(this.stopAt)) {
                            this.s.close();
                            this.s = null;
                            return null;
                        }
                        return n2;
                    }
                    return null;
                }
            };
        }
    };
    public static final Accessor PRECEDING_SIBLING = new Accessor(Axis.PRECEDING_SIBLING){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            final Node<?> n = node;
            Object p = node.getParent();
            if (p == null) {
                return new EmptyStream();
            }
            Object sibling = p.getFirstChild();
            return new Stream<Node<?>>((Node)sibling){
                final Node<?> stopAt;
                Node<?> next;
                final /* synthetic */ Node val$sibling;
                {
                    this.val$sibling = node2;
                    this.stopAt = n;
                    this.next = this.val$sibling;
                }

                @Override
                public void close() {
                    this.next = null;
                }

                @Override
                public Node<?> next() throws DocumentException {
                    if (this.next == null || this.next.isSelfOf(this.stopAt)) {
                        return null;
                    }
                    Node<?> deliver = this.next;
                    this.next = this.next.getNextSibling();
                    return deliver;
                }
            };
        }
    };
    public static final Accessor NEXT = new Accessor(Axis.NEXT){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            Object next = ((TemporalNode)node).getNext();
            if (next == null) {
                return new EmptyStream();
            }
            return new ArrayStream<TemporalNode>(new TemporalNode[]{next});
        }
    };
    public static final Accessor PREVIOUS = new Accessor(Axis.PREVIOUS){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            Object previous = ((TemporalNode)node).getPrevious();
            if (previous == null) {
                return new EmptyStream();
            }
            return new ArrayStream<TemporalNode>(new TemporalNode[]{previous});
        }
    };
    public static final Accessor FIRST = new Accessor(Axis.FIRST){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            Object first = ((TemporalNode)node).getFirst();
            if (first == null) {
                return new EmptyStream();
            }
            return new ArrayStream<TemporalNode>(new TemporalNode[]{first});
        }
    };
    public static final Accessor LAST = new Accessor(Axis.LAST){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            Object last = ((TemporalNode)node).getLast();
            if (last == null) {
                return new EmptyStream();
            }
            return new ArrayStream<TemporalNode>(new TemporalNode[]{last});
        }
    };
    public static final Accessor FUTURE = new Accessor(Axis.FUTURE){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return ((TemporalNode)node).getFuture(false);
        }
    };
    public static final Accessor FUTURE_OR_SELF = new Accessor(Axis.FUTURE_OR_SELF){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return ((TemporalNode)node).getFuture(true);
        }
    };
    public static final Accessor PAST = new Accessor(Axis.PAST){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return ((TemporalNode)node).getEarlier(false);
        }
    };
    public static final Accessor PAST_OR_SELF = new Accessor(Axis.PAST_OR_SELF){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return ((TemporalNode)node).getEarlier(true);
        }
    };
    public static final Accessor ALL_TIME = new Accessor(Axis.ALL_TIME){

        @Override
        public Stream<? extends Node<?>> performStep(Node<?> node) {
            return ((TemporalNode)node).getAllTime();
        }
    };
    private final Axis axis;

    public Accessor(Axis axis) {
        this.axis = axis;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public String toString() {
        return this.axis.toString();
    }

    public abstract Stream<? extends Node<?>> performStep(Node<?> var1) throws QueryException;

    public Stream<? extends Node<?>> performStep(Node<?> node, NodeType test) {
        KindFilter s = node.performStep(this.axis, test);
        return s != null ? s : new KindFilter(test, this.performStep(node));
    }

    protected static class KindFilter
    implements Stream<Node<?>> {
        private final NodeType test;
        private final Stream<? extends Node<?>> stream;

        public KindFilter(NodeType test, Stream<? extends Node<?>> stream) {
            this.test = test;
            this.stream = stream;
        }

        @Override
        public Node<?> next() throws DocumentException {
            try {
                Node<?> next;
                while ((next = this.stream.next()) != null && !this.test.matches(next)) {
                }
                return next;
            }
            catch (DocumentException e) {
                throw e;
            }
            catch (QueryException e) {
                throw new DocumentException(e);
            }
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }
}

