/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DTD;
import io.brackit.query.atomic.Date;
import io.brackit.query.atomic.DateTime;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.atomic.Time;
import io.brackit.query.atomic.YMD;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;

public class ArithmeticExpr
implements Expr {
    protected final Expr leftExpr;
    protected final Expr rightExpr;
    private final ArithmeticOp op;

    public ArithmeticExpr(ArithmeticOp op, Expr leftExpr, Expr rightExpr) {
        this.op = op;
        this.leftExpr = leftExpr;
        this.rightExpr = rightExpr;
    }

    @Override
    public final Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Type rightType;
        Item left = this.leftExpr.evaluateToItem(ctx, tuple);
        Item right = this.rightExpr.evaluateToItem(ctx, tuple);
        if (left == null || right == null) {
            return null;
        }
        left = left.atomize();
        right = right.atomize();
        Type leftType = ((Atomic)left).type();
        if (leftType.instanceOf(Type.UNA)) {
            left = Cast.cast(null, left, Type.DBL, false);
            leftType = Type.DBL;
        }
        if ((rightType = ((Atomic)right).type()).instanceOf(Type.UNA)) {
            right = Cast.cast(null, right, Type.DBL, false);
            rightType = Type.DBL;
        }
        if (leftType.isNumeric()) {
            if (rightType.isNumeric()) {
                switch (this.op.ordinal()) {
                    case 0: {
                        return ((Numeric)left).add((Numeric)right);
                    }
                    case 1: {
                        return ((Numeric)left).subtract((Numeric)right);
                    }
                    case 2: {
                        return ((Numeric)left).multiply((Numeric)right);
                    }
                    case 3: {
                        return ((Numeric)left).div((Numeric)right);
                    }
                    case 5: {
                        return ((Numeric)left).idiv((Numeric)right);
                    }
                    case 4: {
                        return ((Numeric)left).mod((Numeric)right);
                    }
                }
            }
        } else if (leftType.instanceOf(Type.DTD)) {
            if (rightType.instanceOf(Type.DTD)) {
                switch (this.op.ordinal()) {
                    case 0: {
                        return ((DTD)left).add((DTD)right);
                    }
                    case 1: {
                        return ((DTD)left).subtract((DTD)right);
                    }
                    case 3: {
                        return ((DTD)left).divide((DTD)right);
                    }
                }
            } else if (rightType.isNumeric()) {
                right = Cast.cast(null, right, Type.DBL, false);
                switch (this.op.ordinal()) {
                    case 2: {
                        return ((DTD)left).multiply((Dbl)right);
                    }
                    case 3: {
                        return ((DTD)left).divide((Dbl)right);
                    }
                }
            }
        } else if (leftType.instanceOf(Type.YMD)) {
            if (rightType.instanceOf(Type.YMD)) {
                switch (this.op.ordinal()) {
                    case 0: {
                        return ((YMD)left).add((YMD)right);
                    }
                    case 1: {
                        return ((YMD)left).subtract((YMD)right);
                    }
                    case 3: {
                        return ((YMD)left).divide((YMD)right);
                    }
                }
            } else if (rightType.isNumeric()) {
                right = Cast.cast(null, right, Type.DBL, false);
                switch (this.op.ordinal()) {
                    case 2: {
                        return ((YMD)left).multiply((Dbl)right);
                    }
                    case 3: {
                        return ((YMD)left).divide((Dbl)right);
                    }
                }
            }
        } else if (leftType.instanceOf(Type.DATI)) {
            if (rightType.instanceOf(Type.YMD)) {
                switch (this.op.ordinal()) {
                    case 0: {
                        return ((DateTime)left).add((YMD)right);
                    }
                    case 1: {
                        return ((DateTime)left).subtract((YMD)right);
                    }
                }
            } else if (rightType.instanceOf(Type.DTD)) {
                switch (this.op.ordinal()) {
                    case 0: {
                        return ((DateTime)left).add((DTD)right);
                    }
                    case 1: {
                        return ((DateTime)left).subtract((DTD)right);
                    }
                }
            } else if (rightType.instanceOf(Type.DATI)) {
                return ((DateTime)left).subtract((DateTime)right);
            }
        } else if (leftType.instanceOf(Type.DATE)) {
            if (rightType.instanceOf(Type.YMD)) {
                switch (this.op.ordinal()) {
                    case 0: {
                        return ((Date)left).add((YMD)right);
                    }
                    case 1: {
                        return ((Date)left).subtract((YMD)right);
                    }
                }
            } else if (rightType.instanceOf(Type.DTD)) {
                switch (this.op.ordinal()) {
                    case 0: {
                        return ((Date)left).add((DTD)right);
                    }
                    case 1: {
                        return ((Date)left).subtract((DTD)right);
                    }
                }
            } else if (rightType.instanceOf(Type.DATE)) {
                return ((Date)left).subtract((Date)right);
            }
        } else if (leftType.instanceOf(Type.TIME)) {
            if (rightType.instanceOf(Type.DTD)) {
                switch (this.op.ordinal()) {
                    case 0: {
                        return ((Time)left).add((DTD)right);
                    }
                    case 1: {
                        return ((Time)left).subtract((DTD)right);
                    }
                }
            } else if (rightType.instanceOf(Type.TIME)) {
                return ((Time)left).subtract((Time)right);
            }
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compute %s %s %s.", new Object[]{leftType, this.op, rightType});
    }

    @Override
    public boolean isUpdating() {
        return this.leftExpr.isUpdating() || this.rightExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return String.valueOf(this.leftExpr) + " " + String.valueOf((Object)this.op) + " " + String.valueOf(this.rightExpr);
    }

    public static enum ArithmeticOp {
        PLUS("+"),
        MINUS("-"),
        MULT("*"),
        DIV("/"),
        MOD("mod"),
        IDIV("idiv");

        final String s;

        private ArithmeticOp(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

