/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.block.Block;
import io.brackit.query.block.FJControl;
import io.brackit.query.block.MutexSink;
import io.brackit.query.block.SerialValve;
import io.brackit.query.block.Sink;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.sequence.FlatteningSequence;
import io.brackit.query.util.ExprUtil;
import io.brackit.query.util.forkjoin.Task;
import io.brackit.query.util.join.FastList;
import io.brackit.query.util.serialize.SerializationHandler;

public class BlockExpr
implements Expr {
    private final Block block;
    private final Expr expr;
    private final boolean ordered;

    public BlockExpr(Block block, Expr expr, boolean ordered) {
        this.block = block;
        this.expr = expr;
        this.ordered = ordered;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple t) throws QueryException {
        Return rs = new Return(ctx, this.expr);
        Sink end = this.ordered ? new SerialValve(FJControl.PERMITS, (Sink)rs) : rs;
        Sink start = this.block.create(ctx, end);
        EvalBlock task = new EvalBlock(t, start);
        FJControl.POOL.submit(task).join();
        return rs.asSequence();
    }

    public void serialize(QueryContext ctx, Tuple t, SerializationHandler handler) throws QueryException {
        SerializerReturn rs = new SerializerReturn(ctx, this.expr, handler);
        Sink end = this.ordered ? new SerialValve(FJControl.PERMITS, (Sink)rs) : rs;
        Sink start = this.block.create(ctx, end);
        EvalBlock task = new EvalBlock(t, start);
        FJControl.POOL.submit(task).join();
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple t) throws QueryException {
        return ExprUtil.asItem(this.evaluate(ctx, t));
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    private static class Return
    extends MutexSink {
        final QueryContext ctx;
        final Expr expr;
        final FastList<Sequence> buf;

        public Return(QueryContext ctx, Expr expr) {
            this.ctx = ctx;
            this.expr = expr;
            this.buf = new FastList();
        }

        @Override
        public Sink partition(Sink stopAt) {
            return this.fork();
        }

        @Override
        protected MutexSink.Out doPreOutput(Tuple[] buf, int len) throws QueryException {
            int nlen = 0;
            for (int i = 0; i < len; ++i) {
                Sequence s = this.expr.evaluate(this.ctx, buf[i]);
                if (s == null) continue;
                buf[nlen++] = s;
            }
            return new Result(buf, nlen);
        }

        @Override
        protected void doOutput(MutexSink.Out out) throws QueryException {
            Result res = (Result)out;
            this.buf.addAllSafe(res.buf, 0, res.len);
        }

        @Override
        protected void doBegin() {
        }

        @Override
        protected void doEnd() throws QueryException {
        }

        Sequence asSequence() {
            return new FlatteningSequence(){
                final int len;
                {
                    this.len = buf.getSize();
                }

                @Override
                protected Sequence sequence(int pos) throws QueryException {
                    return pos < this.len ? buf.get(pos) : null;
                }
            };
        }

        private static class Result
        extends MutexSink.Out {
            final Tuple[] buf;
            final int len;

            private Result(Tuple[] buf, int len) {
                this.buf = buf;
                this.len = len;
            }
        }
    }

    private static final class EvalBlock
    extends Task {
        private final Tuple t;
        private final Sink start;

        private EvalBlock(Tuple t, Sink start) {
            this.t = t;
            this.start = start;
        }

        @Override
        public void compute() throws QueryException {
            this.start.begin();
            try {
                this.start.output(new Tuple[]{this.t}, 1);
                this.start.end();
            }
            catch (QueryException e) {
                this.start.fail();
                throw e;
            }
        }
    }

    private static class SerializerReturn
    extends MutexSink {
        final QueryContext ctx;
        final Expr expr;
        final SerializationHandler handler;

        public SerializerReturn(QueryContext ctx, Expr expr, SerializationHandler handler) {
            this.ctx = ctx;
            this.expr = expr;
            this.handler = handler;
        }

        @Override
        public Sink partition(Sink stopAt) {
            return this.fork();
        }

        @Override
        protected MutexSink.Out doPreOutput(Tuple[] buf, int len) throws QueryException {
            int nlen = 0;
            for (int i = 0; i < len; ++i) {
                Sequence s = this.expr.evaluate(this.ctx, buf[i]);
                if (s == null) continue;
                buf[nlen++] = s;
            }
            return new Result(buf, nlen);
        }

        @Override
        protected void doOutput(MutexSink.Out out) throws QueryException {
            Result res = (Result)out;
            for (Tuple t : res.buf) {
                if (t == null) continue;
                Sequence s = (Sequence)t;
                if (s instanceof Item) {
                    this.handler.item((Item)s);
                    continue;
                }
                try (Iter it = s.iterate();){
                    Item i = it.next();
                    while (i != null) {
                        this.handler.item(i);
                        i = it.next();
                    }
                }
            }
        }

        @Override
        protected void doBegin() throws QueryException {
            this.handler.begin();
        }

        @Override
        protected void doEnd() throws QueryException {
            this.handler.end();
        }

        private static class Result
        extends MutexSink.Out {
            final Tuple[] buf;
            final int len;

            private Result(Tuple[] buf, int len) {
                this.buf = buf;
                this.len = len;
            }
        }
    }
}

