/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.B64;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.DTD;
import io.brackit.query.atomic.Date;
import io.brackit.query.atomic.DateTime;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Dec;
import io.brackit.query.atomic.Dur;
import io.brackit.query.atomic.Flt;
import io.brackit.query.atomic.GDay;
import io.brackit.query.atomic.GMD;
import io.brackit.query.atomic.GMon;
import io.brackit.query.atomic.GYE;
import io.brackit.query.atomic.GYM;
import io.brackit.query.atomic.Hex;
import io.brackit.query.atomic.Int;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.Int64;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.atomic.Time;
import io.brackit.query.atomic.TimeInstant;
import io.brackit.query.atomic.Una;
import io.brackit.query.atomic.YMD;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.Whitespace;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Cast
implements Expr {
    private final StaticContext sctx;
    private final Expr expr;
    private final Type target;
    private final boolean allowEmptySequence;

    public Cast(StaticContext sctx, Expr expr, Type targetType, boolean allowEmptySequence) {
        this.sctx = sctx;
        this.expr = expr;
        this.target = targetType;
        this.allowEmptySequence = allowEmptySequence;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Item item = this.expr.evaluateToItem(ctx, tuple);
        return Cast.cast(this.sctx, item, this.target, this.allowEmptySequence);
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    public static Atomic cast(StaticContext sctx, Item item, Type target, boolean allowEmptySequence) {
        if (item == null) {
            if (allowEmptySequence) {
                return null;
            }
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
        }
        if (!target.isAtomic()) {
            throw new QueryException(ErrorCode.ERR_UNKNOWN_ATOMIC_SCHEMA_TYPE, "Cannot cast to non-atomic type %s", target);
        }
        Atomic atomic = item.atomize();
        Type source = atomic.type();
        if (target == Type.ANA) {
            return atomic;
        }
        if (target.isCastPrimitive()) {
            return Cast.toPrimitive(sctx, atomic, source, target);
        }
        return Cast.toDerived(sctx, atomic, source, target);
    }

    public static Atomic cast(StaticContext sctx, Atomic atomic, Type target) {
        if (!target.isAtomic()) {
            throw new QueryException(ErrorCode.ERR_UNKNOWN_ATOMIC_SCHEMA_TYPE, "Cannot cast to non-atomic type %s", target);
        }
        Type source = atomic.type();
        if (source == target || target == Type.ANA) {
            return atomic;
        }
        if (target.isCastPrimitive()) {
            return Cast.toPrimitive(sctx, atomic, source, target);
        }
        return Cast.toDerived(sctx, atomic, source, target);
    }

    private static Atomic toDerived(StaticContext sctx, Atomic atomic, Type source, Type target) {
        Type targetBase;
        if (source.instanceOf(target)) {
            return atomic.asType(target);
        }
        Type sourceBase = source.getPrimitiveBase();
        if (sourceBase != (targetBase = target.getPrimitiveBase())) {
            Atomic temp = Cast.toPrimitive(sctx, atomic, source, sourceBase);
            if (sourceBase == Type.STR || sourceBase == Type.UNA) {
                // empty if block
            }
            atomic = Cast.castPrimitiveToPrimitive(sctx, temp, sourceBase, targetBase);
        }
        return atomic.asType(target);
    }

    private static Atomic toPrimitive(StaticContext sctx, Atomic atomic, Type source, Type target) {
        if (source.isCastPrimitive()) {
            return Cast.castPrimitiveToPrimitive(sctx, atomic, source, target);
        }
        if (source.instanceOf(target)) {
            return atomic.asType(target);
        }
        Type sourceBase = source.getPrimitiveBase();
        if (sourceBase == null) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Tried to cast %s to %s but did not find primitive base type", source, target);
        }
        Atomic temp = Cast.toPrimitive(sctx, atomic, source, sourceBase);
        return Cast.castPrimitiveToPrimitive(sctx, temp, sourceBase, target);
    }

    private static Atomic castPrimitiveToPrimitive(StaticContext sctx, Atomic atomic, Type source, Type target) {
        if (target == Type.UNA) {
            return new Una(atomic.stringValue());
        }
        if (target == Type.STR) {
            return new Str(atomic.stringValue());
        }
        if (target.isNumeric()) {
            if (target == Type.DBL) {
                return Cast.primitiveToDbl(atomic, source, target);
            }
            if (target == Type.INR) {
                return Cast.primitiveToInt(atomic, source, target);
            }
            if (target == Type.DEC) {
                return Cast.primitiveToDec(atomic, source, target);
            }
            if (target == Type.FLO) {
                return Cast.primitiveToFlt(atomic, source, target);
            }
            throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected numeric primitive target type: %s", target);
        }
        if (target.isDuration()) {
            if (target == Type.DUR) {
                return Cast.primitiveToDur(atomic, source, target);
            }
            if (target == Type.DTD) {
                return Cast.primitiveToDTDur(atomic, source, target);
            }
            if (target == Type.YMD) {
                return Cast.primitiveToYMDur(atomic, source, target);
            }
            throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected primitive duration target type: %s", target);
        }
        if (target.isTimeInstance()) {
            if (target == Type.DATI) {
                return Cast.primitiveToDateTime(atomic, source, target);
            }
            if (target == Type.DATE) {
                return Cast.primitiveToDate(atomic, source, target);
            }
            if (target == Type.TIME) {
                return Cast.primitiveToTime(atomic, source, target);
            }
            if (target == Type.GDAY) {
                return Cast.primitiveToGDay(atomic, source, target);
            }
            if (target == Type.GMD) {
                return Cast.primitiveToGMD(atomic, source, target);
            }
            if (target == Type.GMON) {
                return Cast.primitiveToGMon(atomic, source, target);
            }
            if (target == Type.GYE) {
                return Cast.primitiveToGYE(atomic, source, target);
            }
            if (target == Type.GYM) {
                return Cast.primitiveToGYM(atomic, source, target);
            }
            throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected primitive date/time target type: %s", target);
        }
        if (target == Type.BOOL) {
            return Cast.primitiveToBool(atomic, source, target);
        }
        if (target == Type.B64) {
            return Cast.primitiveToB64(atomic, source, target);
        }
        if (target == Type.HEX) {
            return Cast.primitiveToHex(atomic, source, target);
        }
        if (target == Type.AURI) {
            return Cast.primitiveToAnyURI(atomic, source, target);
        }
        if (target == Type.QNM) {
            if (source.instanceOf(Type.QNM)) {
                return atomic;
            }
            if (source.instanceOf(Type.NOT)) {
                return new QNm(atomic.stringValue());
            }
            QNm qnm = new QNm(atomic.stringValue());
            if (qnm.getPrefix() != null) {
                String uri = sctx.getNamespaces().resolve(qnm.getPrefix());
                if (uri == null) {
                    throw new QueryException(ErrorCode.ERR_UNKNOWN_NS_PREFIX_IN_COMP_CONSTR, "Statically unkown namespace prefix: '%s'", qnm.getPrefix());
                }
                return new QNm(uri, null, qnm.getLocalName());
            }
            String uri = sctx.getNamespaces().getDefaultElementNamespace();
            if (uri == null || uri.isEmpty()) {
                return qnm;
            }
            return new QNm(uri, null, qnm.getLocalName());
        }
        if (target == Type.NOT || target == Type.ANA) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_CAST_TARGET_TYPE, "Cast to %s is not allowed", target);
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected primitive target type: %s", target);
    }

    private static Atomic primitiveToGDay(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new GDay(atomic.stringValue());
        }
        if (source == Type.DATI || source == Type.DATE) {
            TimeInstant ti = (TimeInstant)atomic;
            return new GDay(ti.getDay(), ti.getTimezone());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToGMD(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new GMD(atomic.stringValue());
        }
        if (source == Type.DATI || source == Type.DATE) {
            TimeInstant ti = (TimeInstant)atomic;
            return new GMD(ti.getMonth(), ti.getDay(), ti.getTimezone());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToGMon(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new GMon(atomic.stringValue());
        }
        if (source == Type.DATI || source == Type.DATE) {
            TimeInstant ti = (TimeInstant)atomic;
            return new GMon(ti.getMonth(), ti.getTimezone());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToGYM(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new GYM(atomic.stringValue());
        }
        if (source == Type.DATI || source == Type.DATE) {
            TimeInstant ti = (TimeInstant)atomic;
            return new GYM(ti.getYear(), ti.getMonth(), ti.getTimezone());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToGYE(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new GYE(atomic.stringValue());
        }
        if (source == Type.DATI || source == Type.DATE) {
            TimeInstant ti = (TimeInstant)atomic;
            return new GYE(ti.getYear(), ti.getTimezone());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToDateTime(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new DateTime(atomic.stringValue());
        }
        if (source == Type.DATE) {
            Date d = (Date)atomic;
            return new DateTime(d.getYear(), d.getMonth(), d.getDay(), 0, 0, 0, d.getTimezone());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToDate(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new Date(atomic.stringValue());
        }
        if (source == Type.DATI) {
            return new Date((DateTime)atomic);
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToTime(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new Time(atomic.stringValue());
        }
        if (source == Type.DATI) {
            return new Time((DateTime)atomic);
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToDur(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new Dur(atomic.stringValue());
        }
        if (source == Type.YMD) {
            YMD ymd = (YMD)atomic;
            return new Dur(ymd.isNegative(), ymd.getYears(), ymd.getMonths(), 0, 0, 0, 0);
        }
        if (source == Type.DTD) {
            DTD dtd = (DTD)atomic;
            return new Dur(dtd.isNegative(), 0, 0, dtd.getDays(), dtd.getHours(), dtd.getMinutes(), dtd.getMicros());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToYMDur(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new YMD(atomic.stringValue());
        }
        if (source == Type.DUR) {
            Dur dur = (Dur)atomic;
            return new YMD(dur.isNegative(), dur.getYears(), dur.getMonths());
        }
        if (source == Type.DTD) {
            DTD dtd = (DTD)atomic;
            return new YMD(dtd.isNegative(), 0, 0);
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToDTDur(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new DTD(atomic.stringValue());
        }
        if (source == Type.DUR) {
            Dur dur = (Dur)atomic;
            return new DTD(dur.isNegative(), dur.getDays(), dur.getHours(), dur.getMinutes(), dur.getMicros());
        }
        if (source == Type.YMD) {
            YMD ymd = (YMD)atomic;
            return new DTD(ymd.isNegative(), 0, 0, 0, 0);
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToDbl(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR || source == Type.DEC || source == Type.INR) {
            return Dbl.parse(atomic.stringValue());
        }
        if (source == Type.FLO) {
            return new Dbl(((Numeric)atomic).floatValue());
        }
        if (source == Type.BOOL) {
            return new Dbl(((Bool)atomic).bool ? 1.0 : 0.0);
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToFlt(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR || source == Type.DEC || source == Type.INR) {
            return Flt.parse(atomic.stringValue());
        }
        if (source == Type.DBL) {
            return new Flt(((Numeric)atomic).floatValue());
        }
        if (source == Type.BOOL) {
            return new Flt(((Bool)atomic).bool ? 1.0f : 0.0f);
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToDec(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new Dec(atomic.stringValue());
        }
        if (source == Type.DBL) {
            double dv = ((Numeric)atomic).doubleValue();
            if (Double.isNaN(dv) || Double.isInfinite(dv)) {
                throw new QueryException(ErrorCode.ERR_INVALID_LEXICAL_VALUE);
            }
            return new Dec(new BigDecimal(dv));
        }
        if (source == Type.FLO) {
            float fv = ((Numeric)atomic).floatValue();
            if (Float.isNaN(fv) || Float.isInfinite(fv)) {
                throw new QueryException(ErrorCode.ERR_INVALID_LEXICAL_VALUE);
            }
            return new Dec(new BigDecimal(fv));
        }
        if (source == Type.INR) {
            return atomic.asType(Type.DEC);
        }
        if (source == Type.BOOL) {
            return new Dec(((Bool)atomic).bool ? BigDecimal.ONE : BigDecimal.ZERO);
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToInt(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return Int32.parse(atomic.stringValue());
        }
        if (source == Type.DBL || source == Type.FLO) {
            double d = ((Numeric)atomic).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new QueryException(ErrorCode.ERR_INVALID_LEXICAL_VALUE);
            }
            return Cast.asInteger(d);
        }
        if (source == Type.DEC) {
            return Cast.asInt(((Numeric)atomic).decimalValue());
        }
        if (source == Type.BOOL) {
            return ((Bool)atomic).bool ? Int32.ONE : Int32.ZERO;
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToBool(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            String s = Whitespace.collapseTrimOnly(atomic.stringValue());
            if ("true".equals(s) || "1".equals(s)) {
                return Bool.TRUE;
            }
            if ("false".equals(s) || "0".equals(s)) {
                return Bool.FALSE;
            }
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Illegal cast from %s to %s", source, target);
        }
        if (source.isNumeric()) {
            double d = ((Numeric)atomic).doubleValue();
            return new Bool(d != Double.NaN && d != 0.0);
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToAnyURI(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new AnyURI(atomic.stringValue());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToHex(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new Hex(atomic.stringValue());
        }
        if (source == Type.B64) {
            return new Hex(((B64)atomic).getBytes());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    private static Atomic primitiveToB64(Atomic atomic, Type source, Type target) {
        if (source == Type.UNA || source == Type.STR) {
            return new B64(atomic.stringValue());
        }
        if (source == Type.HEX) {
            return new B64(((Hex)atomic).getBytes());
        }
        if (source == target) {
            return atomic;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal cast from %s to %s", source, target);
    }

    public static IntNumeric asInt(BigDecimal d) {
        if (d.scale() != 0) {
            d = d.setScale(0, RoundingMode.DOWN);
        }
        if (d.compareTo(Int32.MAX_VALUE_AS_DECIMAL) <= 0 && d.compareTo(Int32.MIN_VALUE_AS_DECIMAL) >= 0) {
            return new Int32(d.intValue());
        }
        if (d.compareTo(Int64.MAX_VALUE_AS_DECIMAL) <= 0 && d.compareTo(Int64.MIN_VALUE_AS_DECIMAL) >= 0) {
            return new Int64(d.longValue());
        }
        return new Int(d);
    }

    public static IntNumeric asInteger(double d) {
        if (d == Double.NaN || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            throw new QueryException(ErrorCode.ERR_INVALID_LEXICAL_VALUE);
        }
        if (d <= 2.147483647E9 && d >= -2.147483648E9) {
            return new Int32((int)d);
        }
        if (d <= 9.223372036854776E18 || d >= -9.223372036854776E18) {
            return new Int64((long)d);
        }
        return new Int(d);
    }

    @Override
    public boolean isUpdating() {
        return this.expr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

